/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.scheduler;

import net.bolbat.kit.scheduler.Scheduler;
import net.bolbat.kit.scheduler.SchedulerConfigurationFactory;
import net.bolbat.kit.scheduler.SchedulerException;
import net.bolbat.kit.scheduler.TaskConfiguration;
import net.bolbat.utils.logging.LoggingUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerImpl
implements Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerImpl.class);
    private volatile org.quartz.Scheduler scheduler;
    private volatile JobDetail jobDetail;
    private final Object lock = new Object();

    protected SchedulerImpl(TaskConfiguration task) throws SchedulerException {
        try {
            this.scheduler = SchedulerConfigurationFactory.getConfiguration(task);
            this.scheduler.start();
            this.jobDetail = JobBuilder.newJob(task.getJobClass()).withIdentity("QueueTask", "Scheduler").build();
            if (task.getParameters() == null) {
                return;
            }
            this.jobDetail.getJobDataMap().put("TASK_CONFIGURATION", (Object)task);
        }
        catch (org.quartz.SchedulerException e) {
            String message = "SchedulerImpl(...) scheduler initialization fail.";
            LOGGER.error(LoggingUtils.FATAL, "SchedulerImpl(...) scheduler initialization fail.", (Throwable)e);
            throw new SchedulerException("SchedulerImpl(...) scheduler initialization fail.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws SchedulerException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.scheduler.isShutdown()) {
                    throw new IllegalStateException("Scheduler is off");
                }
                if (this.scheduler.isStarted()) {
                    this.scheduler.standby();
                }
            }
            catch (org.quartz.SchedulerException e) {
                String message = "pause() fail";
                LOGGER.error("pause() fail", (Throwable)e);
                throw new SchedulerException("pause() fail", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws SchedulerException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.scheduler.isShutdown()) {
                    throw new IllegalStateException("Scheduler is off");
                }
                if (this.scheduler.isInStandbyMode()) {
                    this.scheduler.start();
                }
            }
            catch (org.quartz.SchedulerException e) {
                String message = "resume() fail";
                LOGGER.error("resume() fail", (Throwable)e);
                throw new SchedulerException("resume() fail", e);
            }
        }
    }

    @Override
    public boolean isStarted() throws SchedulerException {
        try {
            return !this.scheduler.isShutdown();
        }
        catch (org.quartz.SchedulerException e) {
            String message = "isStarted() fail";
            LOGGER.error("isStarted() fail", (Throwable)e);
            throw new SchedulerException("isStarted() fail", e);
        }
    }

    @Override
    public boolean isPaused() throws SchedulerException {
        try {
            return this.scheduler.isInStandbyMode();
        }
        catch (org.quartz.SchedulerException e) {
            String message = "isStarted() fail";
            LOGGER.error("isStarted() fail", (Throwable)e);
            throw new SchedulerException("isStarted() fail", e);
        }
    }

    @Override
    public void schedule(String schedule) throws SchedulerException {
        try {
            if (this.scheduler.isShutdown()) {
                throw new IllegalStateException("Scheduler is off");
            }
            if (schedule == null || schedule.trim().isEmpty()) {
                return;
            }
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity("LoaderTrigger", "Scheduler").startNow();
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)schedule));
            triggerBuilder.forJob(this.jobDetail.getKey());
            this.configureTrigger(triggerBuilder.build());
        }
        catch (org.quartz.SchedulerException e) {
            String message = "schedule(" + schedule + ") fail";
            LOGGER.error(message, (Throwable)e);
            throw new SchedulerException(message, e);
        }
    }

    @Override
    public void schedule(long interval) throws SchedulerException {
        try {
            if (this.scheduler.isShutdown()) {
                throw new IllegalStateException("Scheduler is off");
            }
            if (interval < 1L) {
                throw new IllegalArgumentException("interval argument should be more then 0");
            }
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity("LoaderTrigger", "Scheduler").startNow();
            triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval).repeatForever());
            this.configureTrigger(triggerBuilder.build());
        }
        catch (org.quartz.SchedulerException e) {
            String message = "schedule(" + interval + ") fail";
            LOGGER.error(message, (Throwable)e);
            throw new SchedulerException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.scheduler.isShutdown()) {
                    return;
                }
                this.scheduler.shutdown(true);
                while (!this.scheduler.isShutdown()) {
                    Thread.sleep(1L);
                }
            }
            catch (org.quartz.SchedulerException e) {
                String message = "tearDown() fail";
                LOGGER.error(message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized void configureTrigger(Trigger trigger) throws SchedulerException {
        try {
            this.pause();
            if (this.scheduler.checkExists(this.jobDetail.getKey())) {
                this.scheduler.deleteJob(this.jobDetail.getKey());
            }
            this.scheduler.scheduleJob(this.jobDetail, trigger);
            this.resume();
        }
        catch (org.quartz.SchedulerException e) {
            String message = "configureTrigger(" + trigger + ") fail";
            LOGGER.error(message, (Throwable)e);
            throw new SchedulerException(message, e);
        }
    }
}

