/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.scheduler.task.execution;

import net.bolbat.kit.scheduler.Task;
import net.bolbat.kit.scheduler.task.ConfigurableTask;
import net.bolbat.kit.scheduler.task.ProcessingException;
import net.bolbat.kit.scheduler.task.execution.ExecutionProcessor;
import net.bolbat.kit.scheduler.task.execution.ExecutionTaskConfiguration;
import net.bolbat.utils.logging.LoggingUtils;
import net.bolbat.utils.reflect.Instantiator;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionTask.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Object taskConfiguration = context.getJobDetail().getJobDataMap().get((Object)"TASK_CONFIGURATION");
        if (!(taskConfiguration instanceof ExecutionTaskConfiguration)) {
            LOGGER.error("execute(context) fail. No configured ExecutionTaskConfiguration.");
            return;
        }
        ExecutionTaskConfiguration configuration = (ExecutionTaskConfiguration)ExecutionTaskConfiguration.class.cast(taskConfiguration);
        ExecutionProcessor processor = (ExecutionProcessor)Instantiator.instantiate(configuration.getProcessorClass());
        if (processor instanceof ConfigurableTask) {
            ((ConfigurableTask)ConfigurableTask.class.cast(processor)).configure(configuration.getParameters());
        }
        LoggingUtils.debug((Logger)LOGGER, (String)("executing " + ExecutionTask.class));
        try {
            processor.process();
        }
        catch (ProcessingException e) {
            LOGGER.error("execute(context) processing fail.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("execute(context) processing fail.", (Throwable)e);
        }
    }
}

