/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.scheduler.task.queue;

import java.util.List;
import net.bolbat.kit.scheduler.Task;
import net.bolbat.kit.scheduler.task.ConfigurableTask;
import net.bolbat.kit.scheduler.task.LoadingException;
import net.bolbat.kit.scheduler.task.ProcessingException;
import net.bolbat.kit.scheduler.task.queue.ProcessingMode;
import net.bolbat.kit.scheduler.task.queue.QueueLoader;
import net.bolbat.kit.scheduler.task.queue.QueueProcessor;
import net.bolbat.kit.scheduler.task.queue.QueueTaskConfiguration;
import net.bolbat.utils.logging.LoggingUtils;
import net.bolbat.utils.reflect.Instantiator;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueueTask<T>
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueTask.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        QueueProcessor processor;
        Object taskConfiguration = context.getJobDetail().getJobDataMap().get((Object)"TASK_CONFIGURATION");
        if (!(taskConfiguration instanceof QueueTaskConfiguration)) {
            LOGGER.error("execute(context) fail. No configured QueueTaskConfiguration.");
            return;
        }
        QueueTaskConfiguration configuration = (QueueTaskConfiguration)QueueTaskConfiguration.class.cast(taskConfiguration);
        QueueLoader loader = (QueueLoader)Instantiator.instantiate(configuration.getLoaderClass());
        if (loader instanceof ConfigurableTask) {
            ((ConfigurableTask)ConfigurableTask.class.cast(loader)).configure(configuration.getParameters());
        }
        if ((processor = (QueueProcessor)Instantiator.instantiate(configuration.getProcessorClass())) instanceof ConfigurableTask) {
            ((ConfigurableTask)ConfigurableTask.class.cast(processor)).configure(configuration.getParameters());
        }
        ProcessingMode processingMode = configuration.getProcessingMode();
        try {
            LoggingUtils.debug((Logger)LOGGER, (String)("executing " + QueueTask.class));
            List result = loader.load();
            LoggingUtils.debug((Logger)LOGGER, (String)("loaded " + (result != null ? result.size() : 0) + " elements"));
            if (result == null || result.isEmpty()) {
                return;
            }
            if (processingMode == ProcessingMode.SYNC) {
                for (Object element : result) {
                    try {
                        LoggingUtils.debug((Logger)LOGGER, (String)("processing element[" + element + "]"));
                        processor.process(element);
                    }
                    catch (ProcessingException e) {
                        LOGGER.error("execute(context) processing fail. Skipping element[" + element + "].", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOGGER.error("execute(context) processing fail. Skipping element[" + element + "].", (Throwable)e);
                    }
                }
            }
        }
        catch (LoadingException e) {
            String message = "execute(context) loading fail.";
            LOGGER.error("execute(context) loading fail.", (Throwable)e);
        }
        catch (Exception e) {
            String message = "execute(context) fail";
            LOGGER.error("execute(context) fail", (Throwable)e);
            throw new JobExecutionException("execute(context) fail", (Throwable)e);
        }
    }
}

