/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.scheduler.task.queue;

import net.bolbat.kit.scheduler.SchedulerConfigurationType;
import net.bolbat.kit.scheduler.TaskBuilder;
import net.bolbat.kit.scheduler.TaskConfiguration;
import net.bolbat.kit.scheduler.TaskParameters;
import net.bolbat.kit.scheduler.task.queue.ProcessingMode;
import net.bolbat.kit.scheduler.task.queue.QueueLoader;
import net.bolbat.kit.scheduler.task.queue.QueueProcessor;
import net.bolbat.kit.scheduler.task.queue.QueueTaskConfiguration;

public class QueueTaskBuilder<T>
implements TaskBuilder {
    private Class<? extends QueueLoader<T>> loaderClass;
    private Class<? extends QueueProcessor<T>> processorClass;
    private ProcessingMode processingMode;
    private String configuration;
    private SchedulerConfigurationType configurationType;
    private TaskParameters parameters = new TaskParameters();

    public QueueTaskBuilder<T> loaderClass(Class<? extends QueueLoader<T>> aLoaderClass) {
        this.loaderClass = aLoaderClass;
        return this;
    }

    public QueueTaskBuilder<T> processorClass(Class<? extends QueueProcessor<T>> aProcessorClass) {
        this.processorClass = aProcessorClass;
        return this;
    }

    public QueueTaskBuilder<T> processingMode(ProcessingMode aProcessingMode) {
        this.processingMode = aProcessingMode;
        return this;
    }

    public QueueTaskBuilder<T> configuration(String aConfiguration) {
        this.configuration = aConfiguration;
        return this;
    }

    public QueueTaskBuilder<T> configurationType(SchedulerConfigurationType aConfigurationType) {
        this.configurationType = aConfigurationType;
        return this;
    }

    public QueueTaskBuilder<T> parameters(TaskParameters aParameters) {
        if (aParameters != null) {
            this.parameters = aParameters;
        }
        return this;
    }

    @Override
    public TaskConfiguration build() {
        return new QueueTaskConfiguration(this.loaderClass, this.processorClass, this.processingMode, this.parameters, this.configuration, this.configurationType);
    }
}

