/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.vo;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.bolbat.kit.property.Property;
import net.bolbat.kit.vo.AccountId;
import net.bolbat.kit.vo.EntityVO;
import net.bolbat.utils.lang.StringUtils;
import net.bolbat.utils.lang.ToStringUtils;

public class AccountVO
extends EntityVO {
    private static final long serialVersionUID = 4957254145120125765L;
    public static final int TYPE_MAX_LENGTH = 64;
    public static final int STATUS_MAX_LENGTH = 64;
    private AccountId id = AccountId.EMPTY_ID;
    private Set<String> types = new HashSet<String>();
    private Set<String> statuses = new HashSet<String>();
    private Map<String, Property<?>> properties = new HashMap();

    public AccountVO() {
    }

    public AccountVO(AccountId aId) {
        this.setId(aId);
    }

    public AccountId getId() {
        return this.id;
    }

    public void setId(AccountId aId) {
        this.id = aId == null ? AccountId.EMPTY_ID : aId;
    }

    public Set<String> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public void addType(String type) {
        if (StringUtils.isEmpty((String)type)) {
            throw new IllegalArgumentException("type argument is empty.");
        }
        if (type.length() > 64) {
            throw new IllegalArgumentException("type argument too long, maximum length is [64] characters.");
        }
        this.types.add(type);
    }

    public void removeType(String type) {
        if (StringUtils.isEmpty((String)type) || type.length() > 64) {
            return;
        }
        this.types.remove(type);
    }

    public boolean hasType(String type) {
        if (StringUtils.isEmpty((String)type) || type.length() > 64) {
            return false;
        }
        return this.types.contains(type);
    }

    public Set<String> getStatuses() {
        return Collections.unmodifiableSet(this.statuses);
    }

    public void addStatus(String status) {
        if (StringUtils.isEmpty((String)status)) {
            throw new IllegalArgumentException("status argument is empty.");
        }
        if (status.length() > 64) {
            throw new IllegalArgumentException("status argument too long, maximum length is [64] characters.");
        }
        this.statuses.add(status);
    }

    public void removeStatus(String status) {
        if (StringUtils.isEmpty((String)status) || status.length() > 64) {
            return;
        }
        this.statuses.remove(status);
    }

    public boolean hasStatus(String status) {
        if (StringUtils.isEmpty((String)status) || status.length() > 64) {
            return false;
        }
        return this.statuses.contains(status);
    }

    public Map<String, Property<?>> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Property<?> getProperty(String propertyKey) {
        return StringUtils.isNotEmpty((String)propertyKey) ? this.properties.get(propertyKey) : null;
    }

    public void addProperty(Property<?> property) {
        if (property == null) {
            throw new IllegalArgumentException("property argument is null.");
        }
        if (StringUtils.isEmpty((String)property.getKey())) {
            throw new IllegalArgumentException("property.key argument is empty.");
        }
        this.properties.put(property.getKey(), property);
    }

    public void removeProperty(String propertyKey) {
        if (StringUtils.isEmpty((String)propertyKey)) {
            return;
        }
        this.properties.remove(propertyKey);
    }

    public boolean hasProperty(String propertyKey) {
        if (StringUtils.isEmpty((String)propertyKey)) {
            return false;
        }
        return this.properties.get(propertyKey) != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountVO)) {
            return false;
        }
        AccountVO other = (AccountVO)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [id=").append(this.id);
        builder.append(", types=").append(ToStringUtils.toString(this.types));
        builder.append(", statuses=").append(ToStringUtils.toString(this.statuses));
        builder.append(", properties=").append(ToStringUtils.toString(this.properties));
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public AccountVO clone() {
        AccountVO result = (AccountVO)AccountVO.class.cast(super.clone());
        result.id = this.id.clone();
        result.types = new HashSet<String>();
        for (String string : this.types) {
            result.addType(string);
        }
        result.statuses = new HashSet<String>();
        for (String string : this.statuses) {
            result.addStatus(string);
        }
        result.properties = new HashMap();
        for (Property property : this.properties.values()) {
            result.addProperty(property.clone());
        }
        return result;
    }
}

