/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.vo;

import net.bolbat.kit.vo.Locking;
import net.bolbat.kit.vo.LockingReadException;
import net.bolbat.kit.vo.LockingState;
import net.bolbat.kit.vo.LockingWriteException;

public class LockingVO
implements Locking {
    private static final long serialVersionUID = 6937292885330225838L;
    private LockingState state = LockingState.DEFAULT;

    @Override
    public LockingState getLockingState() {
        return this.state;
    }

    @Override
    public boolean isReadAllowed() {
        return this.getLockingState().equals((Object)LockingState.BOTH) || this.getLockingState().equals((Object)LockingState.READABLE);
    }

    @Override
    public boolean isWriteAllowed() {
        return this.getLockingState().equals((Object)LockingState.BOTH) || this.getLockingState().equals((Object)LockingState.WRITABLE);
    }

    protected void checkRead() {
        if (!this.isReadAllowed()) {
            throw new LockingReadException(this.state);
        }
    }

    protected void checkWrite() {
        if (!this.isWriteAllowed()) {
            throw new LockingWriteException(this.state);
        }
    }

    protected void lock(boolean reads, boolean writes) {
        if (reads && writes) {
            this.state = LockingState.BOTH;
            return;
        }
        if (reads && !writes) {
            this.state = LockingState.READABLE;
            return;
        }
        if (!reads && writes) {
            this.state = LockingState.WRITABLE;
            return;
        }
        this.state = LockingState.NO_ACCESS;
    }

    protected void unlock() {
        this.lock(true, true);
    }
}

