/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.test.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class CommonTester {
    private CommonTester() {
        throw new IllegalAccessError("Shouldn't be instantiated.");
    }

    public static void checkNotInstantiableDefaultConstructor(Class<?> clazz) {
        CommonTester.checkNotInstantiableDefaultConstructor(clazz, null);
    }

    public static <T extends Throwable> void checkNotInstantiableDefaultConstructor(Class<?> clazz, Class<T> expectedException) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            throw new AssertionError((Object)String.format("Shouldn't be possible type[%s] instantiation", clazz));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)String.format("Unexpected type[%s] instantiation problem ", clazz));
        }
        catch (InvocationTargetException e) {
            if (!(expectedException == null || e.getCause() != null && e.getCause().getClass().equals(expectedException))) {
                String format = "Unexpected type[%s] instantiation exception cause[%s], expected[%s]";
                String message = String.format("Unexpected type[%s] instantiation exception cause[%s], expected[%s]", clazz, e.getCause(), expectedException);
                throw new AssertionError((Object)message);
            }
            return;
        }
    }

    public static <T extends Exception> void checkExceptionInstantiation(Class<T> clazz) {
        Constructor<?>[] constructors;
        String exceptionMessage = "Test exception";
        IllegalArgumentException exceptionCause = new IllegalArgumentException("Test cause");
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Exception instance;
            if (constructor.getParameterTypes().length == 0) {
                instance = (Exception)CommonTester.instantiate(constructor, new Object[0]);
                if (instance.getMessage() != null) {
                    throw new AssertionError((Object)("Exception[" + instance + "] message should be null."));
                }
                if (instance.getCause() != null) {
                    throw new AssertionError((Object)("Exception[" + instance + "] cause should be null."));
                }
                continue;
            }
            if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == String.class) {
                instance = (Exception)CommonTester.instantiate(constructor, "Test exception");
                if (instance.getMessage() == null) {
                    throw new AssertionError((Object)("Exception[" + instance + "] message shouldn't be null."));
                }
                if (!"Test exception".equals(instance.getMessage())) {
                    throw new AssertionError((Object)("Exception[" + instance + "] message should be equal with [" + "Test exception" + "]."));
                }
                if (instance.getCause() != null) {
                    throw new AssertionError((Object)("Exception[" + instance + "] cause should be null."));
                }
                continue;
            }
            if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Throwable.class) {
                instance = (Exception)CommonTester.instantiate(constructor, exceptionCause);
                if (instance.getMessage() == null) {
                    throw new AssertionError((Object)("Exception[" + instance + "] message shouldn't be null."));
                }
                if (!exceptionCause.toString().equals(instance.getMessage())) {
                    throw new AssertionError((Object)("Exception[" + instance + "] message should be equal with [" + exceptionCause.toString() + "]."));
                }
                if (instance.getCause() == null) {
                    throw new AssertionError((Object)("Exception[" + instance + "] cause shouldn't be null."));
                }
                if (!exceptionCause.getMessage().equals(instance.getCause().getMessage())) {
                    throw new AssertionError((Object)("Exception[" + instance + "] cause message should be equal with [" + exceptionCause.getMessage() + "]."));
                }
                continue;
            }
            if (constructor.getParameterTypes().length != 2 || constructor.getParameterTypes()[0] != String.class || constructor.getParameterTypes()[1] != Throwable.class) continue;
            instance = (Exception)CommonTester.instantiate(constructor, "Test exception", exceptionCause);
            if (instance.getMessage() == null) {
                throw new AssertionError((Object)("Exception[" + instance + "] message shouldn't be null."));
            }
            if (!"Test exception".equals(instance.getMessage())) {
                throw new AssertionError((Object)("Exception[" + instance + "] message should be equal with [" + "Test exception" + "]."));
            }
            if (instance.getCause() == null) {
                throw new AssertionError((Object)("Exception[" + instance + "] cause shouldn't be null."));
            }
            if (!exceptionCause.getMessage().equals(instance.getCause().getMessage())) {
                throw new AssertionError((Object)("Exception[" + instance + "] cause message should be equal with [" + exceptionCause.getMessage() + "]."));
            }
        }
    }

    private static <T> T instantiate(Constructor<T> constructor, Object ... parameters) {
        if (constructor == null) {
            throw new IllegalArgumentException("arg[constructor] is null");
        }
        try {
            if (parameters == null || parameters.length == 0) {
                return constructor.newInstance(new Object[0]);
            }
            return constructor.newInstance(parameters);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

