/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.codegen.config;

import com.bookrain.codegen.database.ColumnTypeConverter;
import com.bookrain.codegen.database.Dialect;
import com.bookrain.codegen.database.TableQuery;
import com.bookrain.codegen.database.impl.MysqlColumnTypeConverter;
import com.bookrain.codegen.database.impl.MysqlDialect;
import com.bookrain.codegen.database.impl.MysqlTableQuery;
import com.bookrain.codegen.enums.DbType;
import java.sql.Connection;
import java.sql.DriverManager;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * .
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-06-01 20:20:34
 */
@Data
@Accessors(chain = true)
public class DataSourceConfig {

    private Dialect dialect;
    private DbType dbType;
    private TableQuery tableQuery;
    private ColumnTypeConverter columnTypeConverter;
    private String url;
    private String driverClassName;
    private String username;
    private String password;

    public Dialect getDialect() {
        // TODO 支持其他数据库
        if (this.dialect == null) {
            dialect = new MysqlDialect();
        }
        return dialect;
    }

    public DbType getDbType() {
        // TODO 支持其他数据库
        if (this.dbType == null) {
            this.dbType = DbType.MYSQL;
        }
        return dbType;
    }

    public ColumnTypeConverter getColumnTypeConverter() {
        // TODO 支持其他数据库
        if (this.columnTypeConverter == null) {
            this.columnTypeConverter = new MysqlColumnTypeConverter();
        }
        return columnTypeConverter;
    }

    public TableQuery getTableQuery() {
        // TODO 支持其他数据库
        if (tableQuery == null) {
            this.tableQuery = new MysqlTableQuery();
        }
        return this.tableQuery;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName(driverClassName);
            conn = DriverManager.getConnection(url, username, password);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

}
