/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.codegen.config;

import com.bookrain.codegen.constants.CodeGenConstants;
import com.bookrain.codegen.dto.in.AddField;
import com.bookrain.codegen.dto.in.GetField;
import com.bookrain.codegen.dto.out.PageField;
import com.bookrain.codegen.dto.in.QueryField;
import com.bookrain.codegen.dto.TableInfo;
import com.bookrain.codegen.dto.in.UpdateField;
import com.bookrain.codegen.dto.out.ListField;
import com.bookrain.codegen.dto.out.ObjectField;
import io.swagger.annotations.ApiModel;
import java.util.List;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * .
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-06-01 20:20:33
 */
@Data
@Accessors(chain = true)
@ApiModel(description = "生成代码策略配置")
public class StrategyConfig {

    private TableInfo table;
    private Boolean override = true;

    // 输入类型
    private List<QueryField> queryFields;
    private List<AddField> addFields;
    private List<GetField> getFields;
    private List<UpdateField> updateFields;

    // 输出类型
    private List<PageField> pageFields;
    private List<ListField> listFields;
    private List<ObjectField> objFields;

    // java
    private String pkg;
    private String basePkg = CodeGenConstants.DEFAULT_BASE_PKG;
    private String entityPkg = CodeGenConstants.DEFAULT_ENTITY_PKG;
    private String entityName;
    private String dtoPkg = CodeGenConstants.DEFAULT_DTO_PKG;
    private String dtoName;
    private String superEntityName = CodeGenConstants.DEFAULT_SUPER_ENTITY_NAME;
    private String superEntityClass = CodeGenConstants.DEFAULT_SUPER_ENTITY_CLASS;
    private String controllerPkg = CodeGenConstants.DEFAULT_CONTROLLER_PKG;
    private String controllerName;
    private String superControllerName = CodeGenConstants.DEFAULT_SUPER_CONTROLLER_NAME;
    private String superControllerClass = CodeGenConstants.DEFAULT_SUPER_CONTROLLER_CLASS;
    private String servicePkg = CodeGenConstants.DEFAULT_SERVICE_PKG;
    private String serviceName = CodeGenConstants.DEFAULT_SUPER_SERVICE_NAME;
    private String superServiceName = CodeGenConstants.DEFAULT_SUPER_SERVICE_NAME;
    private String superServiceClass = CodeGenConstants.DEFAULT_SUPER_SERVICE_CLASS;
    private String serviceImplPkg = CodeGenConstants.DEFAULT_SERVICEIMPL_PKG;
    private String serviceImplName;
    private String superServiceImplName = CodeGenConstants.DEFAULT_SUPER_SERVICEIMPL_NAME;
    private String superServiceImplClass = CodeGenConstants.DEFAULT_SUPER_SERVICEIMPL_CLASS;
    private String mapperPkg = CodeGenConstants.DEFAULT_MAPPER_PKG;
    private String mapperName;
    private String superMapperName = CodeGenConstants.DEFAULT_SUPER_MAPPER_NAME;
    private String superMapperClass = CodeGenConstants.DEFAULT_SUPER_MAPPER_CLASS;
    private String mapperXmlDir = CodeGenConstants.DEFAULT_XML_DIR;
    private String mapperXmlName;
    private String baseMapping = CodeGenConstants.DEFAULT_BASE_MAPPING;
    // js
    private String namespace;
}
