/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.codegen.constants;

import com.bookrain.codegen.enums.IdType;
import com.bookrain.codegen.enums.QueryType;
import com.bookrain.codegen.enums.ShowType;
import com.bookrain.core.controller.BaseController;
import com.bookrain.database.entity.BaseEntity;
import com.bookrain.database.mapper.BaseMapper;
import com.bookrain.database.service.BaseService;
import com.bookrain.database.service.impl.BaseServiceImpl;

/**
 * 后端生成器常量.
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-05-29 17:17:28
 */
public class CodeGenConstants {

    /** 作者 */
    public static String DEFAULT_AUTHOR = "Bookrain Chu";
    /** 父包名 */
    public static String DEFAULT_BASE_PKG = "com.bookrain";
    /** Controller包名 */
    public static String DEFAULT_CONTROLLER_PKG = "controller";
    public static String DEFAULT_SUPER_CONTROLLER_NAME = "BaseController";
    public static String DEFAULT_SUPER_CONTROLLER_CLASS = BaseController.class.getName();
    /** Entity包名 */
    public static String DEFAULT_ENTITY_PKG = "entity";
    public static String DEFAULT_SUPER_ENTITY_NAME = "BaseEntity";
    public static String DEFAULT_SUPER_ENTITY_CLASS = BaseEntity.class.getName();
    /** Dto包名 */
    public static String DEFAULT_DTO_PKG = "dto";
    /** Service包名 */
    public static String DEFAULT_SERVICE_PKG = "service";
    public static String DEFAULT_SUPER_SERVICE_NAME = "BaseService";
    public static String DEFAULT_SUPER_SERVICE_CLASS = BaseService.class.getName();
    /** Service Impl包名 */
    public static String DEFAULT_SERVICEIMPL_PKG = "service.impl";
    public static String DEFAULT_SUPER_SERVICEIMPL_NAME = "BaseServiceImpl";
    public static String DEFAULT_SUPER_SERVICEIMPL_CLASS = BaseServiceImpl.class.getName();
    /** Mapper包名 */
    public static String DEFAULT_MAPPER_PKG = "mapper";
    public static String DEFAULT_SUPER_MAPPER_NAME = "BaseMapper";
    public static String DEFAULT_SUPER_MAPPER_CLASS = BaseMapper.class.getName();
    /** Mapper XML包名 */
    public static String DEFAULT_XML_DIR = "mappings";

    public static String DEFAULT_TEMPLATE_ENTITY = "/templates/java/entity.java.ftl";
    public static String DEFAULT_TEMPLATE_DTO = "/templates/java/dto.java.ftl";
    public static String DEFAULT_TEMPLATE_SERVICE = "/templates/java/service.java.ftl";
    public static String DEFAULT_TEMPLATE_SERVICEIMPL = "/templates/java/serviceImpl.java.ftl";
    public static String DEFAULT_TEMPLATE_MAPPER = "/templates/java/mapper.java.ftl";
    public static String DEFAULT_TEMPLATE_CONTROLLER = "/templates/java/controller.java.ftl";
    public static String DEFAULT_TEMPLATE_MAPPER_XML = "/templates/mapper.xml.ftl";
    public static String DEFAULT_BASE_MAPPING = "";
    public static IdType DEFAULT_ID_TYPE = IdType.AUTO;
    public static QueryType DEFAULT_QUERY_TYPE = QueryType.EQ;
    public static ShowType DEFAULT_SHOW_TYPE = ShowType.INPUT;
}
