/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.codegen.database;

import com.bookrain.codegen.enums.DbType;

/**
 * .
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-06-03 16:16:54
 */
public interface TableQuery {

    /**
     * 数据库类型
     *
     * @return 数据库类型
     */
    DbType dbType();


    /**
     * 表信息查询 SQL
     *
     * @return 表信息查询 SQL
     */
    String tableSql();

    /**
     * 表信息查询 SQL
     *
     * @return 表信息查询 SQL
     */
    String allTableSql();

    /**
     * 表字段信息查询 SQL
     *
     * @return 表字段信息查询 SQL
     */
    String tableFieldsSql();


    /**
     * 表名称
     *
     * @return 表名称
     */
    String tableName();


    /**
     * 表注释
     *
     * @return 表注释
     */
    String tableComment();


    /**
     * 字段名称
     *
     * @return 字段名称
     */
    String fieldName();


    /**
     * 字段类型
     *
     * @return 字段类型
     */
    String fieldType();


    /**
     * 字段注释
     *
     * @return 字段注释
     */
    String fieldComment();


    /**
     * 主键判断标识
     *
     * @return 主键判断标识
     */
    String key();
}
