/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.codegen.database.impl;

import com.bookrain.codegen.database.ColumnTypeConverter;
import com.bookrain.codegen.enums.FieldType;

/**
 * .
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-06-01 22:22:55
 */
public class MysqlColumnTypeConverter implements ColumnTypeConverter {

    @Override
    public FieldType convert(String columnType) {
        String t = columnType.toLowerCase();
        if (t.contains("char")) {
            return FieldType.STRING;
        } else if (t.contains("bigint")) {
            return FieldType.LONG;
        } else if (t.contains("tinyint(1)")) {
            return FieldType.BOOLEAN;
        } else if (t.contains("int")) {
            return FieldType.INTEGER;
        } else if (t.contains("text")) {
            return FieldType.STRING;
        } else if (t.contains("bit")) {
            return FieldType.BOOLEAN;
        } else if (t.contains("decimal")) {
            return FieldType.BIG_DECIMAL;
        } else if (t.contains("clob")) {
            return FieldType.CLOB;
        } else if (t.contains("blob")) {
            return FieldType.BLOB;
        } else if (t.contains("binary")) {
            return FieldType.BYTE_ARRAY;
        } else if (t.contains("float")) {
            return FieldType.FLOAT;
        } else if (t.contains("double")) {
            return FieldType.DOUBLE;
        } else if (t.contains("json") || t.contains("enum")) {
            return FieldType.STRING;
        } else if (t.contains("date") || t.contains("time") || t.contains("year")) {
            return FieldType.DATE;
        }
        return FieldType.STRING;
    }
}
