/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.codegen.enums;

import com.bookrain.core.enums.IEnum;
import lombok.Getter;

/**
 * .
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-06-02 20:20:48
 */
public enum QueryType implements IEnum {
    NONE("none", "不查询", null),
    EQ("eq", "相等", new ShowType[]{ShowType.INPUT}),
    GT("gt", "大于", new ShowType[]{ShowType.INPUT}),
    GE("ge", "大于等于", new ShowType[]{ShowType.INPUT}),
    LT("lt", "小于", new ShowType[]{ShowType.INPUT}),
    LE("le", "小于等于", new ShowType[]{ShowType.INPUT}),
    LIKE("like", "模糊查询", new ShowType[]{ShowType.INPUT}),
    LEFT_LIKE("left_like", "左模糊查询", new ShowType[]{ShowType.INPUT}),
    RIGHT_LIKE("right_like", "右模糊查询", new ShowType[]{ShowType.INPUT});

    @Getter
    private String type;
    @Getter
    private String desc;
    @Getter
    private ShowType[] showTypes;

    QueryType(String type, String desc, ShowType[] showTypes) {
        this.type = type;
        this.desc = desc;
        this.showTypes = showTypes;
    }

    @Override
    public String getValue() {
        return name();
    }
}
