/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.codegen.service;

import com.bookrain.codegen.config.CommonConfig;
import com.bookrain.codegen.config.DataSourceConfig;
import com.bookrain.codegen.config.StrategyConfig;
import com.bookrain.codegen.config.TemplateConfig;
import com.bookrain.codegen.dto.TableInfo;
import java.sql.SQLException;
import java.util.List;

/**
 * 生成代码服务类.
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-06-01 16:16:43
 */
public interface CodeGenService {

    /**
     * 生成模板代码.<p>
     *
     * @param dataSourceConfig 数据库配置
     * @param commonConfig 通用配置
     * @param templateConfig 模板配置
     * @param strategyConfig 生成策略配置
     * @throws SQLException 异常
     */
    void generate(DataSourceConfig dataSourceConfig, CommonConfig commonConfig, TemplateConfig templateConfig,
        StrategyConfig strategyConfig) throws Exception;

    /**
     * 获取表信息.<p>
     *
     * @param dataSourceConfig 数据库配置
     * @param tableName 表名
     * @return 表信息
     * @throws SQLException 异常
     */
    TableInfo getTableInfo(DataSourceConfig dataSourceConfig, String tableName) throws SQLException;

    /**
     * 获取数据库所有表名.<p>
     *
     * @param dataSourceConfig 数据库配置Ò
     * @return 数据库所有表名
     * @throws SQLException 异常
     */
    List<String> getTableNames(DataSourceConfig dataSourceConfig) throws SQLException;
}
