<#-- 版权 -->
<#if copyright??>
  ${copyright!}
<#else>
  <#include "copyright.java.ftl"/>
</#if>
package ${basePkg}<#if pkg??>.${pkg}</#if>.${controllerPkg};


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bookrain.core.api.ApiResponse;
import com.bookrain.database.constants.PaginationConstant;
import com.bookrain.core.dto.Pagination;
import com.bookrain.core.utils.BeanUtils;
import com.bookrain.database.enums.OrderBy;
import ${superControllerClass};
import ${basePkg}<#if pkg??>.${pkg}</#if>.${entityPkg}.${entityName};
import ${basePkg}<#if pkg??>.${pkg}</#if>.${servicePkg}.${serviceName};
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import lombok.Data;
import lombok.experimental.Accessors;
<#list controllerImports as import>
import ${import};
</#list>
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

<#list table.fields as field>
    <#if field.pk == true>
        <#assign idColumnName = field.name>
        <#assign idPropertyName = field.name>
        <#if field.typePkg??>
        <#assign idPropertyType = field.typePkg>
        <#else>
        <#assign idPropertyType = field.type>
        </#if>
    </#if>
</#list>

@Api(tags = "${description!}接口")
@RestController
@RequestMapping("${baseMapping}")
public class ${controllerName} extends ${superControllerName} {
    @Autowired
    private ${serviceName} ${serviceName?uncap_first};

    @ApiOperation(value = "获取新增${description!}初始化数据")
    @GetMapping(value = "initAdd", produces = "application/json")
    public ApiResponse<InitAddResponse> getAddInfo() {
        InitAddResponse body = new InitAddResponse();
        return ApiResponse.ok(body);
    }

    @ApiOperation(value = "新增${description!}")
    @PostMapping(value = "add", produces = "application/json")
    public ApiResponse add(@RequestBody AddRequest addRequest)  throws Exception{
        ${serviceName?uncap_first}.save(BeanUtils.copyToClass(addRequest, ${module}.class));
        return ok();
    }

    @ApiOperation(value = "根据id删除${description!}")
    @DeleteMapping(value = "delete/{${idPropertyName}}", produces = "application/json")
    public ApiResponse delete(@ApiParam(value = "${description!}${idPropertyName}") @PathVariable(name = "${idPropertyName}") ${idPropertyType} ${idPropertyName}) {
        ${serviceName?uncap_first}.removeById(${idPropertyName});
        return ok();
    }

    @ApiOperation(value = "批量删除${description!}")
    @DeleteMapping(value = "deleteBatch", produces = "application/json")
    public ApiResponse deleteBatch(DeleteBatchRequest deleteBatchRequest) {
        ${serviceName?uncap_first}.removeByIds(Arrays.asList(deleteBatchRequest.get${idPropertyName?cap_first}s()));
        return ok();
    }

    @ApiOperation(value = "获取根据${idPropertyName}更新${description!}初始化数据")
    @GetMapping(value = "initUpdate/{${idPropertyName}}", produces = "application/json")
    public ApiResponse<InitUpdateResponse> initUpdate(@PathVariable(name = "${idPropertyName}") ${idPropertyType} ${idPropertyName}) throws Exception {
        InitUpdateResponse body = new InitUpdateResponse();

        ${module} ${module?uncap_first} = ${serviceName?uncap_first}.getById(${idPropertyName});
        body.setObj(BeanUtils.copyToClass(${module?uncap_first}, InitUpdateDTO.class));
        return ok(body);
    }

    @ApiOperation(value = "根据${idPropertyName}更新${description!}")
    @PutMapping(value = "update", produces = "application/json")
    public ApiResponse update(@RequestBody UpdateRequest updateRequest) {
        ${module} ${module?uncap_first} = ${serviceName?uncap_first}.getById(updateRequest.getId());
        if (${module?uncap_first} == null) {
            return no("记录不存在");
        }
        BeanUtils.copyToObj(updateRequest, ${module?uncap_first}, "${idColumnName}");
        ${serviceName?uncap_first}.updateById(${module?uncap_first});
        return ok();
    }

    @ApiOperation(value = "获取分页数据")
    @GetMapping(value = "getPage", produces = "application/json")
    public ApiResponse<GetPageResponse> getPage(@RequestBody GetPageRequest getPageRequest) throws Exception {
        GetPageResponse body = new GetPageResponse();

        // 设置分页
        Page<${module}> page = new Page<>();
        Integer current = getPageRequest.getCurrent();
        if (current == null || current < 1) {
            current = PaginationConstant.DEFAULT_PAGE_CURRENT;
        }
        page.setCurrent(current);
        Integer pageSize = getPageRequest.getPageSize();
        if (pageSize == null || pageSize < 1) {
            pageSize = PaginationConstant.DEFAULT_PAGE_SIZE;
        }
        page.setSize(pageSize);

        QueryWrapper<${module}> queryWrapper = new QueryWrapper<>();
        <#list queryFields as field>
        <#switch field.queryType>
        <#case 'EQ'>
        queryWrapper.eq("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#case 'GT'>
        queryWrapper.gt("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#case 'GE'>
        queryWrapper.ge("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LT'>
        queryWrapper.lt("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LE'>
        queryWrapper.le("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LIKE'>
        queryWrapper.like("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LEFT_LIKE'>
        queryWrapper.likeLeft("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#case 'RIGHT_LIKE'>
        queryWrapper.likeRight("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        <#break>
        <#default>
        queryWrapper.eq("${field.columnName}", getPageRequest.get${field.name?cap_first}());
        </#switch>
        </#list>

        IPage<${module}> pageData = ${serviceName?uncap_first}.page(page, queryWrapper);
        Pagination pagination = new Pagination();
        pagination.setCurrent(pageData.getCurrent());
        pagination.setPageSize(pageData.getSize());
        pagination.setTotal(pageData.getTotal());
        body.setList(BeanUtils.copyToList(pageData.getRecords(), GetPageDTO.class)).setPagination(pagination);
        return ok(body);
    }

    @ApiOperation(value = "获取列表数据")
    @GetMapping(value = "getList", produces = "application/json")
    public ApiResponse<GetListResponse> getList(GetListRequest getListRequest) throws Exception {
        GetListResponse body = new GetListResponse();
        QueryWrapper<${module}> queryWrapper = new QueryWrapper<>();
        <#list queryFields as field>
        <#switch field.queryType>
        <#case 'EQ'>
        queryWrapper.eq("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#case 'GT'>
        queryWrapper.gt("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#case 'GE'>
        queryWrapper.ge("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LT'>
        queryWrapper.lt("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LE'>
        queryWrapper.le("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LIKE'>
        queryWrapper.like("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#case 'LEFT_LIKE'>
        queryWrapper.likeLeft("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#case 'RIGHT_LIKE'>
        queryWrapper.likeRight("${field.columnName}", getListRequest.get${field.name?cap_first}());
        <#break>
        <#default>
        queryWrapper.eq("${field.columnName}", getListRequest.get${field.name?cap_first}());
        </#switch>
        </#list>
        List<${module}> ${module?uncap_first}s = ${serviceName?uncap_first}.list(queryWrapper);
        body.setList(BeanUtils.copyToList(${module?uncap_first}s, GetListDTO.class));
        return ok(body);
    }


    @ApiOperation(value = "根据${idPropertyName}获取信息")
    @GetMapping(value = "get/{${idPropertyName}}", produces = "application/json")
    public ApiResponse<GetResponse> get(@PathVariable(name = "${idPropertyName}") ${idPropertyType} ${idPropertyName}) throws Exception {
        GetResponse body = new GetResponse();
        ${module} ${module?uncap_first} = ${serviceName?uncap_first}.getById(${idPropertyName});
        body.setObj(BeanUtils.copyToClass(${module?uncap_first}, GetDTO.class));
        return ok(body);
    }

    /*******************************************************实体对象****************************************************/
    @Data
    @Accessors(chain = true)
    @ApiModel(description = "新增${description!}初始化数据响应")
    public static class InitAddResponse {
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "新增${description!}请求")
    public static class AddRequest {
        <#list addFields as field>
        @ApiModelProperty(value = "${field.comment!}"<#if field.required??><#if field.required == true>, required = true</#if></#if>)
        private ${field.type} ${field.name};
        </#list>
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "批量删除${description!}请求")
    public static class DeleteBatchRequest {

        @ApiModelProperty(value = "批量${description!}${idPropertyName}", required = true)
        private ${idPropertyType}[] ${idPropertyName}s;
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "获取更新测试初始化数据响应")
    public static class InitUpdateResponse {

        private InitUpdateDTO obj;
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "更新初始化数据")
    public static class InitUpdateDTO {
        <#list updateFields as field>
        @ApiModelProperty(value = "${field.comment!}"<#if field.required??><#if field.required == true>, required = true</#if></#if>)
        private ${field.type} ${field.name};
        </#list>
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "更新${description!}")
    public static class UpdateRequest {

        <#list updateFields as field>
        @ApiModelProperty(value = "${field.comment!}"<#if field.required??><#if field.required == true>, required = true</#if></#if>)
        private ${field.type} ${field.name};
        </#list>
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "获取分页数据请求")
    public static class GetPageRequest {

        @ApiModelProperty(value = "每页数据条数")
        private Integer pageSize;
        @ApiModelProperty(value = "当前页")
        private Integer current;
        <#list queryFields as field>
        @ApiModelProperty(value = "${field.comment!}")
        private ${field.type} ${field.name};
        </#list>
        private List<OrderBy> orderBys;
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "获取${description!}分页数据响应")
    public static class GetPageResponse {

        @ApiModelProperty(value  = "${description!}分页数据列表")
        private List<GetPageDTO> list;
        private Pagination pagination;
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "${description!}分页数据实体")
    public static class GetPageDTO {
        <#list pageFields as field>
        @ApiModelProperty(value = "${field.comment!}")
        private ${field.type} ${field.name};
        </#list>
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "获取${description!}列表数据请求")
    public static class GetListRequest {
        <#list queryFields as field>
        @ApiModelProperty(value = "${field.comment!}")
        private ${field.type} ${field.name};
        </#list>
        private List<OrderBy> orderBys;
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "获取${description!}列表数据响应")
    public static class GetListResponse {

        @ApiModelProperty(value = "${description!}列表数据")
        private List<GetListDTO> list;
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "${description!}列表数据实体")
    public static class GetListDTO {
        <#list listFields as field>
        @ApiModelProperty(value = "${field.comment!}")
        private ${field.type} ${field.name};
        </#list>
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "根据${idPropertyName}获取信息响应")
    public static class GetResponse {

        @ApiModelProperty(value = "${description!}信息")
        private GetDTO obj;
    }

    @Data
    @Accessors(chain = true)
    @ApiModel(description = "${description!}信息")
    public static class GetDTO {
        <#list objFields as field>
        @ApiModelProperty(value = "${field.comment!}")
        private ${field.type} ${field.name};
        </#list>
    }
}
