/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.codegen.config;

import com.bookrain.codegen.database.ColumnTypeConverter;
import com.bookrain.codegen.database.Dialect;
import com.bookrain.codegen.database.TableQuery;
import com.bookrain.codegen.database.impl.MysqlColumnTypeConverter;
import com.bookrain.codegen.database.impl.MysqlDialect;
import com.bookrain.codegen.database.impl.MysqlTableQuery;
import com.bookrain.codegen.enums.DbType;
import java.sql.Connection;
import java.sql.DriverManager;

public class DataSourceConfig {
    private Dialect dialect;
    private DbType dbType;
    private TableQuery tableQuery;
    private ColumnTypeConverter columnTypeConverter;
    private String url;
    private String driverClassName;
    private String username;
    private String password;

    public Dialect getDialect() {
        if (this.dialect == null) {
            this.dialect = new MysqlDialect();
        }
        return this.dialect;
    }

    public DbType getDbType() {
        if (this.dbType == null) {
            this.dbType = DbType.MYSQL;
        }
        return this.dbType;
    }

    public ColumnTypeConverter getColumnTypeConverter() {
        if (this.columnTypeConverter == null) {
            this.columnTypeConverter = new MysqlColumnTypeConverter();
        }
        return this.columnTypeConverter;
    }

    public TableQuery getTableQuery() {
        if (this.tableQuery == null) {
            this.tableQuery = new MysqlTableQuery();
        }
        return this.tableQuery;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName(this.driverClassName);
            conn = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DataSourceConfig setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public DataSourceConfig setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public DataSourceConfig setTableQuery(TableQuery tableQuery) {
        this.tableQuery = tableQuery;
        return this;
    }

    public DataSourceConfig setColumnTypeConverter(ColumnTypeConverter columnTypeConverter) {
        this.columnTypeConverter = columnTypeConverter;
        return this;
    }

    public DataSourceConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public DataSourceConfig setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public DataSourceConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataSourceConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig other = (DataSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Dialect this$dialect = this.getDialect();
        Dialect other$dialect = other.getDialect();
        if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !((Object)((Object)this$dbType)).equals((Object)other$dbType)) {
            return false;
        }
        TableQuery this$tableQuery = this.getTableQuery();
        TableQuery other$tableQuery = other.getTableQuery();
        if (this$tableQuery == null ? other$tableQuery != null : !this$tableQuery.equals(other$tableQuery)) {
            return false;
        }
        ColumnTypeConverter this$columnTypeConverter = this.getColumnTypeConverter();
        ColumnTypeConverter other$columnTypeConverter = other.getColumnTypeConverter();
        if (this$columnTypeConverter == null ? other$columnTypeConverter != null : !this$columnTypeConverter.equals(other$columnTypeConverter)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Dialect $dialect = this.getDialect();
        result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : ((Object)((Object)$dbType)).hashCode());
        TableQuery $tableQuery = this.getTableQuery();
        result = result * 59 + ($tableQuery == null ? 43 : $tableQuery.hashCode());
        ColumnTypeConverter $columnTypeConverter = this.getColumnTypeConverter();
        result = result * 59 + ($columnTypeConverter == null ? 43 : $columnTypeConverter.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceConfig(dialect=" + this.getDialect() + ", dbType=" + (Object)((Object)this.getDbType()) + ", tableQuery=" + this.getTableQuery() + ", columnTypeConverter=" + this.getColumnTypeConverter() + ", url=" + this.getUrl() + ", driverClassName=" + this.getDriverClassName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

