/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.codegen.controller;

import com.alibaba.fastjson.JSONObject;
import com.bookrain.codegen.config.CommonConfig;
import com.bookrain.codegen.config.DataSourceConfig;
import com.bookrain.codegen.config.StrategyConfig;
import com.bookrain.codegen.config.TemplateConfig;
import com.bookrain.codegen.constants.CodeGenConstants;
import com.bookrain.codegen.dto.TableField;
import com.bookrain.codegen.dto.TableInfo;
import com.bookrain.codegen.dto.in.AddField;
import com.bookrain.codegen.dto.in.QueryField;
import com.bookrain.codegen.dto.in.UpdateField;
import com.bookrain.codegen.dto.out.ListField;
import com.bookrain.codegen.dto.out.ObjectField;
import com.bookrain.codegen.dto.out.PageField;
import com.bookrain.codegen.enums.AddType;
import com.bookrain.codegen.enums.CodeGenType;
import com.bookrain.codegen.enums.FieldType;
import com.bookrain.codegen.enums.IdType;
import com.bookrain.codegen.enums.QueryType;
import com.bookrain.codegen.enums.ShowType;
import com.bookrain.codegen.enums.UpdateType;
import com.bookrain.codegen.service.CodeGenService;
import com.bookrain.core.api.ApiResponse;
import com.bookrain.core.controller.BaseController;
import com.bookrain.core.utils.BeanUtils;
import com.bookrain.core.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ee3\u7801\u751f\u6210"})
@RestController
@RequestMapping(value={"/codegen"})
public class CodeGenController
extends BaseController {
    @Autowired
    private DataSourceConfig dataSourceConfig;
    @Autowired
    private CodeGenService codeGenService;

    @ApiOperation(value="\u83b7\u53d6\u65b0\u589e\u6d4b\u8bd5\u521d\u59cb\u5316\u6570\u636e")
    @GetMapping(value={"/initCodeGen"}, produces={"application/json"})
    public ApiResponse initCodeGen() throws SQLException {
        InitCodeGenResponse initCodeGenResponse = new InitCodeGenResponse();
        initCodeGenResponse.setAllTableNames(this.codeGenService.getTableNames(this.dataSourceConfig));
        JSONObject idTypes = new JSONObject();
        for (IdType value : IdType.values()) {
            idTypes.put(value.name(), (Object)value.getDesc());
        }
        JSONObject codeGenTypes = new JSONObject();
        for (CodeGenType value : CodeGenType.values()) {
            codeGenTypes.put(value.name(), (Object)value.getDesc());
        }
        JSONObject fieldTypes = new JSONObject();
        for (FieldType value : FieldType.values()) {
            fieldTypes.put(value.name(), (Object)(value.getPkg() == null ? value.getType() : value.getPkg()));
        }
        JSONObject showTypes = new JSONObject();
        for (ShowType value : ShowType.values()) {
            showTypes.put(value.name(), (Object)value.getDesc());
        }
        JSONObject queryTypes = new JSONObject();
        for (QueryType value : QueryType.values()) {
            queryTypes.put(value.name(), (Object)value.getDesc());
        }
        JSONObject addTypes = new JSONObject();
        for (AddType value : AddType.values()) {
            addTypes.put(value.name(), (Object)value.getDesc());
        }
        JSONObject updateTypes = new JSONObject();
        for (UpdateType value : UpdateType.values()) {
            updateTypes.put(value.name(), (Object)value.getDesc());
        }
        initCodeGenResponse.setIdTypes(idTypes).setShowTypes(showTypes).setQueryTypes(queryTypes).setCodeGenTypes(codeGenTypes).setFieldTypes(fieldTypes).setAddTypes(addTypes).setUpdateTypes(updateTypes);
        return CodeGenController.ok((Object)initCodeGenResponse);
    }

    @ApiOperation(value="\u83b7\u53d6\u65b0\u589e\u6d4b\u8bd5\u521d\u59cb\u5316\u6570\u636e")
    @GetMapping(value={"/getGenerateInfo"}, produces={"application/json"})
    @ApiImplicitParam(name="tableName", value="\u8868\u540d")
    public ApiResponse getGenerateInfo(String tableName) throws Exception {
        String namespace;
        String dir;
        String pkg;
        GetCodeGenInfoResponse getCodeGenInfoResponse = new GetCodeGenInfoResponse();
        String[] tableNameSplits = tableName.split("_");
        StringBuilder mapping = new StringBuilder();
        StringBuilder module = new StringBuilder();
        if (tableNameSplits.length > 1) {
            pkg = tableNameSplits[1];
            dir = tableNameSplits[1];
            namespace = tableNameSplits[1];
            for (int i = 1; i < tableNameSplits.length; ++i) {
                module.append(StringUtils.capitalFirst((String)tableNameSplits[i]));
                mapping.append("/" + StringUtils.capitalFirst((String)tableNameSplits[i]).toLowerCase());
            }
        } else {
            pkg = tableNameSplits[0];
            module = new StringBuilder(StringUtils.capitalFirst((String)tableNameSplits[0]));
            mapping.append("/" + StringUtils.capitalFirst((String)tableNameSplits[0]).toLowerCase());
            dir = tableNameSplits[0];
            namespace = tableNameSplits[0];
        }
        TableInfo table = this.codeGenService.getTableInfo(this.dataSourceConfig, tableName);
        TableInfoDto tableInfoDto = new TableInfoDto().setName(table.getName()).setIdType(table.getIdType()).setComment(table.getComment());
        ArrayList<TableFieldDto> tableInfoDtos = new ArrayList<TableFieldDto>();
        for (int i = 0; i < table.getFields().size(); ++i) {
            TableField tableField = table.getFields().get(i);
            TableFieldDto tableFieldDto = new TableFieldDto().setId(i).setPk(tableField.getPk()).setComment(tableField.getComment()).setColumnName(tableField.getColumnName()).setColumnType(tableField.getColumnType()).setType(tableField.getType()).setName(tableField.getName());
            tableInfoDtos.add(tableFieldDto);
        }
        tableInfoDto.setFields(tableInfoDtos);
        getCodeGenInfoResponse.setTableInfo(tableInfoDto).setModule(module.toString()).setJavaOutputDir((System.getProperty("java.io.tmpdir") + "/" + dir.toLowerCase() + "/java").replace("//", "/")).setJsOutputDir((System.getProperty("java.io.tmpdir") + "/" + dir.toLowerCase() + "/react").replace("//", "/")).setDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date())).setNamespace(namespace.toLowerCase()).setDescription(table.getComment()).setPkg(pkg.toLowerCase()).setBaseMapping(mapping.toString().toLowerCase());
        return CodeGenController.ok((Object)getCodeGenInfoResponse);
    }

    @ApiOperation(value="\u83b7\u53d6\u65b0\u589e\u6d4b\u8bd5\u521d\u59cb\u5316\u6570\u636e")
    @PostMapping(value={"/generate"}, produces={"application/json"})
    public ApiResponse generate(@RequestBody GenerateRequest generateRequest) throws Exception {
        String module = StringUtils.capitalFirst((String)generateRequest.getModule());
        CommonConfig commonConfig = new CommonConfig();
        commonConfig.setJavaOutputDir(generateRequest.getJavaOutputDir());
        commonConfig.setJsOutputDir(generateRequest.getJsOutputDir());
        commonConfig.setDescription(generateRequest.getDescription());
        commonConfig.setAuthor(generateRequest.getAuthor());
        commonConfig.setModule(generateRequest.getModule());
        commonConfig.setDate(generateRequest.getDate());
        StrategyConfig strategyConfig = new StrategyConfig();
        strategyConfig.setPkg(generateRequest.getPkg());
        strategyConfig.setBasePkg(generateRequest.getBasePkg());
        strategyConfig.setBaseMapping(generateRequest.getBaseMapping());
        strategyConfig.setDtoName(module + "Dto");
        strategyConfig.setEntityName(module);
        strategyConfig.setMapperName(module + "Mapper");
        strategyConfig.setServiceName(module + "Service");
        strategyConfig.setServiceImplName(module + "ServiceImpl");
        strategyConfig.setControllerName(module + "Controller");
        strategyConfig.setMapperXmlName(module + "Mapper");
        strategyConfig.setNamespace(generateRequest.getNamespace());
        strategyConfig.setBaseMapping(generateRequest.getBaseMapping());
        GenerateTableInfoDto generateTableInfoDto = generateRequest.getTableInfo();
        TableInfo tableInfo = new TableInfo();
        tableInfo.setIdType(generateTableInfoDto.getIdType());
        tableInfo.setName(generateTableInfoDto.getName());
        tableInfo.setComment(generateTableInfoDto.getComment());
        tableInfo.setFields(BeanUtils.copyToList(generateTableInfoDto.getFields(), TableField.class, (String[])new String[]{"queryType", "addType", "updateType"}));
        ArrayList<AddField> addFields = new ArrayList<AddField>();
        generateTableInfoDto.getFields().forEach(generateTableFieldInfoDto -> {
            AddType addType = generateTableFieldInfoDto.getAddType();
            if (addType != AddType.NONE) {
                AddField addField = new AddField();
                addField.setName(generateTableFieldInfoDto.getName());
                addField.setComment(generateTableFieldInfoDto.getComment());
                addField.setRequired(addType == AddType.REQUIRED);
                addField.setType(generateTableFieldInfoDto.getType());
                addField.setShowType(generateTableFieldInfoDto.getShowType());
                addFields.add(addField);
            }
        });
        ArrayList<QueryField> queryFields = new ArrayList<QueryField>();
        generateTableInfoDto.getFields().forEach(generateTableFieldInfoDto -> {
            QueryType queryType = generateTableFieldInfoDto.getQueryType();
            if (queryType != QueryType.NONE) {
                QueryField queryField = new QueryField();
                queryField.setQueryType(queryType);
                queryField.setColumnName(generateTableFieldInfoDto.getColumnName());
                queryField.setComment(generateTableFieldInfoDto.getComment());
                queryField.setName(generateTableFieldInfoDto.getName());
                queryField.setType(generateTableFieldInfoDto.getType());
                queryField.setShowType(generateTableFieldInfoDto.getShowType());
                queryFields.add(queryField);
            }
        });
        ArrayList<UpdateField> updateFields = new ArrayList<UpdateField>();
        generateTableInfoDto.getFields().forEach(generateTableFieldInfoDto -> {
            UpdateType updateType = generateTableFieldInfoDto.getUpdateType();
            if (updateType != UpdateType.NONE) {
                UpdateField updateField = new UpdateField();
                updateField.setName(generateTableFieldInfoDto.getName());
                updateField.setComment(generateTableFieldInfoDto.getComment());
                updateField.setRequired(updateType == UpdateType.REQUIRED);
                updateField.setType(generateTableFieldInfoDto.getType());
                updateField.setShowType(generateTableFieldInfoDto.getShowType());
                updateFields.add(updateField);
            }
        });
        ArrayList<ObjectField> objectFields = new ArrayList<ObjectField>();
        generateTableInfoDto.getFields().forEach(generateTableFieldInfoDto -> {
            if (generateTableFieldInfoDto.getObjField().booleanValue()) {
                ObjectField objectField = new ObjectField();
                objectField.setName(generateTableFieldInfoDto.getName());
                objectField.setComment(generateTableFieldInfoDto.getComment());
                objectField.setType(generateTableFieldInfoDto.getType());
                objectFields.add(objectField);
            }
        });
        ArrayList<ListField> listFields = new ArrayList<ListField>();
        generateTableInfoDto.getFields().forEach(generateTableFieldInfoDto -> {
            if (generateTableFieldInfoDto.getListField().booleanValue()) {
                ListField listField = new ListField();
                listField.setName(generateTableFieldInfoDto.getName());
                listField.setComment(generateTableFieldInfoDto.getComment());
                listField.setType(generateTableFieldInfoDto.getType());
                listFields.add(listField);
            }
        });
        ArrayList<PageField> pageFields = new ArrayList<PageField>();
        generateTableInfoDto.getFields().forEach(generateTableFieldInfoDto -> {
            if (generateTableFieldInfoDto.getPageField().booleanValue()) {
                PageField pageField = new PageField();
                pageField.setName(generateTableFieldInfoDto.getName());
                pageField.setComment(generateTableFieldInfoDto.getComment());
                pageField.setType(generateTableFieldInfoDto.getType());
                pageFields.add(pageField);
            }
        });
        strategyConfig.setTable(tableInfo).setAddFields(addFields).setQueryFields(queryFields).setUpdateFields(updateFields).setObjFields(objectFields).setListFields(listFields).setPageFields(pageFields);
        this.codeGenService.generate(this.dataSourceConfig, commonConfig, new TemplateConfig(), strategyConfig);
        return this.ok();
    }

    @ApiModel(description="\u751f\u6210\u4ee3\u7801\u8bf7\u6c42\u6570\u636e\u5e93\u5b57\u6bb5\u5185\u5bb9")
    public static class GenerateTableFieldInfoDto {
        @ApiModelProperty(value="\u662f\u5426\u4e3b\u952e")
        private Boolean pk;
        @ApiModelProperty(value="\u5217\u540d")
        private String columnName;
        @ApiModelProperty(value="\u5217\u7c7b\u578b")
        private String columnType;
        @ApiModelProperty(value="\u5c5e\u6027\u540d")
        private String name;
        @ApiModelProperty(value="\u5c5e\u6027\u7c7b\u578b")
        private FieldType type;
        @ApiModelProperty(value="\u5b57\u6bb5\u6ce8\u91ca")
        private String comment;
        @ApiModelProperty(value="\u663e\u793a\u7c7b\u578b")
        private ShowType showType;
        @ApiModelProperty(value="\u67e5\u8be2\u7c7b\u578b")
        private QueryType queryType;
        @ApiModelProperty(value="\u65b0\u589e\u7c7b\u578b")
        private AddType addType;
        @ApiModelProperty(value="\u66f4\u65b0\u7c7b\u578b")
        private UpdateType updateType;
        @ApiModelProperty(value="\u5355\u6761\u5b57\u6bb5\u8fd4\u56de")
        private Boolean objField;
        @ApiModelProperty(value="\u5217\u8868\u5b57\u6bb5\u8fd4\u56de")
        private Boolean listField;
        @ApiModelProperty(value="\u5206\u9875\u5b57\u6bb5")
        private Boolean pageField;

        public Boolean getPk() {
            return this.pk;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public String getName() {
            return this.name;
        }

        public FieldType getType() {
            return this.type;
        }

        public String getComment() {
            return this.comment;
        }

        public ShowType getShowType() {
            return this.showType;
        }

        public QueryType getQueryType() {
            return this.queryType;
        }

        public AddType getAddType() {
            return this.addType;
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public Boolean getObjField() {
            return this.objField;
        }

        public Boolean getListField() {
            return this.listField;
        }

        public Boolean getPageField() {
            return this.pageField;
        }

        public GenerateTableFieldInfoDto setPk(Boolean pk) {
            this.pk = pk;
            return this;
        }

        public GenerateTableFieldInfoDto setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public GenerateTableFieldInfoDto setColumnType(String columnType) {
            this.columnType = columnType;
            return this;
        }

        public GenerateTableFieldInfoDto setName(String name) {
            this.name = name;
            return this;
        }

        public GenerateTableFieldInfoDto setType(FieldType type) {
            this.type = type;
            return this;
        }

        public GenerateTableFieldInfoDto setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public GenerateTableFieldInfoDto setShowType(ShowType showType) {
            this.showType = showType;
            return this;
        }

        public GenerateTableFieldInfoDto setQueryType(QueryType queryType) {
            this.queryType = queryType;
            return this;
        }

        public GenerateTableFieldInfoDto setAddType(AddType addType) {
            this.addType = addType;
            return this;
        }

        public GenerateTableFieldInfoDto setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public GenerateTableFieldInfoDto setObjField(Boolean objField) {
            this.objField = objField;
            return this;
        }

        public GenerateTableFieldInfoDto setListField(Boolean listField) {
            this.listField = listField;
            return this;
        }

        public GenerateTableFieldInfoDto setPageField(Boolean pageField) {
            this.pageField = pageField;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenerateTableFieldInfoDto)) {
                return false;
            }
            GenerateTableFieldInfoDto other = (GenerateTableFieldInfoDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$pk = this.getPk();
            Boolean other$pk = other.getPk();
            if (this$pk == null ? other$pk != null : !((Object)this$pk).equals(other$pk)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$columnType = this.getColumnType();
            String other$columnType = other.getColumnType();
            if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            FieldType this$type = this.getType();
            FieldType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            ShowType this$showType = this.getShowType();
            ShowType other$showType = other.getShowType();
            if (this$showType == null ? other$showType != null : !((Object)((Object)this$showType)).equals((Object)other$showType)) {
                return false;
            }
            QueryType this$queryType = this.getQueryType();
            QueryType other$queryType = other.getQueryType();
            if (this$queryType == null ? other$queryType != null : !((Object)((Object)this$queryType)).equals((Object)other$queryType)) {
                return false;
            }
            AddType this$addType = this.getAddType();
            AddType other$addType = other.getAddType();
            if (this$addType == null ? other$addType != null : !((Object)((Object)this$addType)).equals((Object)other$addType)) {
                return false;
            }
            UpdateType this$updateType = this.getUpdateType();
            UpdateType other$updateType = other.getUpdateType();
            if (this$updateType == null ? other$updateType != null : !((Object)((Object)this$updateType)).equals((Object)other$updateType)) {
                return false;
            }
            Boolean this$objField = this.getObjField();
            Boolean other$objField = other.getObjField();
            if (this$objField == null ? other$objField != null : !((Object)this$objField).equals(other$objField)) {
                return false;
            }
            Boolean this$listField = this.getListField();
            Boolean other$listField = other.getListField();
            if (this$listField == null ? other$listField != null : !((Object)this$listField).equals(other$listField)) {
                return false;
            }
            Boolean this$pageField = this.getPageField();
            Boolean other$pageField = other.getPageField();
            return !(this$pageField == null ? other$pageField != null : !((Object)this$pageField).equals(other$pageField));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenerateTableFieldInfoDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $pk = this.getPk();
            result = result * 59 + ($pk == null ? 43 : ((Object)$pk).hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $columnType = this.getColumnType();
            result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            FieldType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            ShowType $showType = this.getShowType();
            result = result * 59 + ($showType == null ? 43 : ((Object)((Object)$showType)).hashCode());
            QueryType $queryType = this.getQueryType();
            result = result * 59 + ($queryType == null ? 43 : ((Object)((Object)$queryType)).hashCode());
            AddType $addType = this.getAddType();
            result = result * 59 + ($addType == null ? 43 : ((Object)((Object)$addType)).hashCode());
            UpdateType $updateType = this.getUpdateType();
            result = result * 59 + ($updateType == null ? 43 : ((Object)((Object)$updateType)).hashCode());
            Boolean $objField = this.getObjField();
            result = result * 59 + ($objField == null ? 43 : ((Object)$objField).hashCode());
            Boolean $listField = this.getListField();
            result = result * 59 + ($listField == null ? 43 : ((Object)$listField).hashCode());
            Boolean $pageField = this.getPageField();
            result = result * 59 + ($pageField == null ? 43 : ((Object)$pageField).hashCode());
            return result;
        }

        public String toString() {
            return "CodeGenController.GenerateTableFieldInfoDto(pk=" + this.getPk() + ", columnName=" + this.getColumnName() + ", columnType=" + this.getColumnType() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", comment=" + this.getComment() + ", showType=" + (Object)((Object)this.getShowType()) + ", queryType=" + (Object)((Object)this.getQueryType()) + ", addType=" + (Object)((Object)this.getAddType()) + ", updateType=" + (Object)((Object)this.getUpdateType()) + ", objField=" + this.getObjField() + ", listField=" + this.getListField() + ", pageField=" + this.getPageField() + ")";
        }
    }

    @ApiModel(description="\u751f\u6210\u4ee3\u7801\u8bf7\u6c42\u6570\u636e\u5e93\u5185\u5bb9")
    public static class GenerateTableInfoDto {
        @ApiModelProperty(value="\u8868\u540d")
        private String name;
        @ApiModelProperty(value="\u4e3b\u952e\u751f\u6210\u7b56\u7565")
        private IdType idType;
        @ApiModelProperty(value="\u8868\u6ce8\u91ca")
        private String comment;
        private List<GenerateTableFieldInfoDto> fields;

        public String getName() {
            return this.name;
        }

        public IdType getIdType() {
            return this.idType;
        }

        public String getComment() {
            return this.comment;
        }

        public List<GenerateTableFieldInfoDto> getFields() {
            return this.fields;
        }

        public GenerateTableInfoDto setName(String name) {
            this.name = name;
            return this;
        }

        public GenerateTableInfoDto setIdType(IdType idType) {
            this.idType = idType;
            return this;
        }

        public GenerateTableInfoDto setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public GenerateTableInfoDto setFields(List<GenerateTableFieldInfoDto> fields) {
            this.fields = fields;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenerateTableInfoDto)) {
                return false;
            }
            GenerateTableInfoDto other = (GenerateTableInfoDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            IdType this$idType = this.getIdType();
            IdType other$idType = other.getIdType();
            if (this$idType == null ? other$idType != null : !((Object)((Object)this$idType)).equals((Object)other$idType)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            List<GenerateTableFieldInfoDto> this$fields = this.getFields();
            List<GenerateTableFieldInfoDto> other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenerateTableInfoDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            IdType $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : ((Object)((Object)$idType)).hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            List<GenerateTableFieldInfoDto> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            return result;
        }

        public String toString() {
            return "CodeGenController.GenerateTableInfoDto(name=" + this.getName() + ", idType=" + (Object)((Object)this.getIdType()) + ", comment=" + this.getComment() + ", fields=" + this.getFields() + ")";
        }
    }

    @ApiModel(description="\u751f\u6210\u4ee3\u7801\u8bf7\u6c42")
    public static class GenerateRequest {
        @ApiModelProperty(value="\u57fa\u7840\u5305\u8def\u5f84")
        private String baseMapping;
        @ApiModelProperty(value="\u57fa\u7840\u5305\u8def\u5f84")
        private String basePkg;
        @ApiModelProperty(value="\u6a21\u5757\u5305")
        private String pkg;
        @ApiModelProperty(value="\u751f\u6210\u7684\u6a21\u5757\u540d,\u6587\u4ef6\u524d\u7f00\uff0c\u9ed8\u8ba4\u4f1a\u9996\u5b57\u6bcd\u5927\u5199")
        private String module;
        @ApiModelProperty(value="\u4ee3\u7801\u751f\u6210\u7c7b\u578b")
        private CodeGenType codeGenType;
        @ApiModelProperty(value="\u6a21\u5757\u63cf\u8ff0")
        private String description;
        @ApiModelProperty(value="\u4f5c\u8005")
        private String author;
        @ApiModelProperty(value="\u65f6\u95f4")
        private String date;
        @ApiModelProperty(value="\u751f\u6210java\u540e\u7aef\u4ee3\u7801\u8def\u5f84")
        private String javaOutputDir;
        @ApiModelProperty(value="\u751f\u6210react\u524d\u7aef\u4ee3\u7801\u8def\u5f84")
        private String jsOutputDir;
        @ApiModelProperty(value="react\u547d\u540d\u7a7a\u95f4")
        private String namespace;
        private GenerateTableInfoDto tableInfo;

        public String getBaseMapping() {
            return this.baseMapping;
        }

        public String getBasePkg() {
            return this.basePkg;
        }

        public String getPkg() {
            return this.pkg;
        }

        public String getModule() {
            return this.module;
        }

        public CodeGenType getCodeGenType() {
            return this.codeGenType;
        }

        public String getDescription() {
            return this.description;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getDate() {
            return this.date;
        }

        public String getJavaOutputDir() {
            return this.javaOutputDir;
        }

        public String getJsOutputDir() {
            return this.jsOutputDir;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public GenerateTableInfoDto getTableInfo() {
            return this.tableInfo;
        }

        public GenerateRequest setBaseMapping(String baseMapping) {
            this.baseMapping = baseMapping;
            return this;
        }

        public GenerateRequest setBasePkg(String basePkg) {
            this.basePkg = basePkg;
            return this;
        }

        public GenerateRequest setPkg(String pkg) {
            this.pkg = pkg;
            return this;
        }

        public GenerateRequest setModule(String module) {
            this.module = module;
            return this;
        }

        public GenerateRequest setCodeGenType(CodeGenType codeGenType) {
            this.codeGenType = codeGenType;
            return this;
        }

        public GenerateRequest setDescription(String description) {
            this.description = description;
            return this;
        }

        public GenerateRequest setAuthor(String author) {
            this.author = author;
            return this;
        }

        public GenerateRequest setDate(String date) {
            this.date = date;
            return this;
        }

        public GenerateRequest setJavaOutputDir(String javaOutputDir) {
            this.javaOutputDir = javaOutputDir;
            return this;
        }

        public GenerateRequest setJsOutputDir(String jsOutputDir) {
            this.jsOutputDir = jsOutputDir;
            return this;
        }

        public GenerateRequest setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GenerateRequest setTableInfo(GenerateTableInfoDto tableInfo) {
            this.tableInfo = tableInfo;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenerateRequest)) {
                return false;
            }
            GenerateRequest other = (GenerateRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseMapping = this.getBaseMapping();
            String other$baseMapping = other.getBaseMapping();
            if (this$baseMapping == null ? other$baseMapping != null : !this$baseMapping.equals(other$baseMapping)) {
                return false;
            }
            String this$basePkg = this.getBasePkg();
            String other$basePkg = other.getBasePkg();
            if (this$basePkg == null ? other$basePkg != null : !this$basePkg.equals(other$basePkg)) {
                return false;
            }
            String this$pkg = this.getPkg();
            String other$pkg = other.getPkg();
            if (this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            CodeGenType this$codeGenType = this.getCodeGenType();
            CodeGenType other$codeGenType = other.getCodeGenType();
            if (this$codeGenType == null ? other$codeGenType != null : !((Object)((Object)this$codeGenType)).equals((Object)other$codeGenType)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            String this$javaOutputDir = this.getJavaOutputDir();
            String other$javaOutputDir = other.getJavaOutputDir();
            if (this$javaOutputDir == null ? other$javaOutputDir != null : !this$javaOutputDir.equals(other$javaOutputDir)) {
                return false;
            }
            String this$jsOutputDir = this.getJsOutputDir();
            String other$jsOutputDir = other.getJsOutputDir();
            if (this$jsOutputDir == null ? other$jsOutputDir != null : !this$jsOutputDir.equals(other$jsOutputDir)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            GenerateTableInfoDto this$tableInfo = this.getTableInfo();
            GenerateTableInfoDto other$tableInfo = other.getTableInfo();
            return !(this$tableInfo == null ? other$tableInfo != null : !((Object)this$tableInfo).equals(other$tableInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenerateRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseMapping = this.getBaseMapping();
            result = result * 59 + ($baseMapping == null ? 43 : $baseMapping.hashCode());
            String $basePkg = this.getBasePkg();
            result = result * 59 + ($basePkg == null ? 43 : $basePkg.hashCode());
            String $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            CodeGenType $codeGenType = this.getCodeGenType();
            result = result * 59 + ($codeGenType == null ? 43 : ((Object)((Object)$codeGenType)).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            String $javaOutputDir = this.getJavaOutputDir();
            result = result * 59 + ($javaOutputDir == null ? 43 : $javaOutputDir.hashCode());
            String $jsOutputDir = this.getJsOutputDir();
            result = result * 59 + ($jsOutputDir == null ? 43 : $jsOutputDir.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            GenerateTableInfoDto $tableInfo = this.getTableInfo();
            result = result * 59 + ($tableInfo == null ? 43 : ((Object)$tableInfo).hashCode());
            return result;
        }

        public String toString() {
            return "CodeGenController.GenerateRequest(baseMapping=" + this.getBaseMapping() + ", basePkg=" + this.getBasePkg() + ", pkg=" + this.getPkg() + ", module=" + this.getModule() + ", codeGenType=" + (Object)((Object)this.getCodeGenType()) + ", description=" + this.getDescription() + ", author=" + this.getAuthor() + ", date=" + this.getDate() + ", javaOutputDir=" + this.getJavaOutputDir() + ", jsOutputDir=" + this.getJsOutputDir() + ", namespace=" + this.getNamespace() + ", tableInfo=" + this.getTableInfo() + ")";
        }
    }

    @ApiModel(description="\u8868\u5b57\u6bb5\u4fe1\u606f")
    public static class TableFieldDto {
        @ApiModelProperty(value="\u5b57\u6bb5\u5e8f\u53f7")
        private int id;
        @ApiModelProperty(value="\u662f\u5426\u662f\u4e3b\u952e")
        private Boolean pk;
        @ApiModelProperty(value="\u6570\u636e\u5e93\u5217\u540d")
        private String columnName;
        @ApiModelProperty(value="\u6570\u636e\u5e93\u5217\u7c7b\u578b")
        private String columnType;
        @ApiModelProperty(value="\u5c5e\u6027\u540d\u79f0")
        private String name;
        @ApiModelProperty(value="\u6570\u636e\u5e93\u5217\u6ce8\u91ca")
        private String comment;
        @ApiModelProperty(value="\u5c5e\u6027\u7c7b\u578b")
        private FieldType type;

        public int getId() {
            return this.id;
        }

        public Boolean getPk() {
            return this.pk;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public FieldType getType() {
            return this.type;
        }

        public TableFieldDto setId(int id) {
            this.id = id;
            return this;
        }

        public TableFieldDto setPk(Boolean pk) {
            this.pk = pk;
            return this;
        }

        public TableFieldDto setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public TableFieldDto setColumnType(String columnType) {
            this.columnType = columnType;
            return this;
        }

        public TableFieldDto setName(String name) {
            this.name = name;
            return this;
        }

        public TableFieldDto setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public TableFieldDto setType(FieldType type) {
            this.type = type;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableFieldDto)) {
                return false;
            }
            TableFieldDto other = (TableFieldDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            Boolean this$pk = this.getPk();
            Boolean other$pk = other.getPk();
            if (this$pk == null ? other$pk != null : !((Object)this$pk).equals(other$pk)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$columnType = this.getColumnType();
            String other$columnType = other.getColumnType();
            if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            FieldType this$type = this.getType();
            FieldType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableFieldDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            Boolean $pk = this.getPk();
            result = result * 59 + ($pk == null ? 43 : ((Object)$pk).hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $columnType = this.getColumnType();
            result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            FieldType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "CodeGenController.TableFieldDto(id=" + this.getId() + ", pk=" + this.getPk() + ", columnName=" + this.getColumnName() + ", columnType=" + this.getColumnType() + ", name=" + this.getName() + ", comment=" + this.getComment() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    @ApiModel(description="\u8868\u4fe1\u606f")
    public static class TableInfoDto {
        @ApiModelProperty(value="\u4e3b\u952e\u751f\u6210\u7c7b\u578b")
        private IdType idType;
        @ApiModelProperty(value="\u8868\u540d")
        private String name;
        @ApiModelProperty(value="\u8868\u6ce8\u91ca")
        private String comment;
        private List<TableFieldDto> fields;

        public IdType getIdType() {
            return this.idType;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public List<TableFieldDto> getFields() {
            return this.fields;
        }

        public TableInfoDto setIdType(IdType idType) {
            this.idType = idType;
            return this;
        }

        public TableInfoDto setName(String name) {
            this.name = name;
            return this;
        }

        public TableInfoDto setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public TableInfoDto setFields(List<TableFieldDto> fields) {
            this.fields = fields;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableInfoDto)) {
                return false;
            }
            TableInfoDto other = (TableInfoDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IdType this$idType = this.getIdType();
            IdType other$idType = other.getIdType();
            if (this$idType == null ? other$idType != null : !((Object)((Object)this$idType)).equals((Object)other$idType)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            List<TableFieldDto> this$fields = this.getFields();
            List<TableFieldDto> other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableInfoDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IdType $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : ((Object)((Object)$idType)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            List<TableFieldDto> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            return result;
        }

        public String toString() {
            return "CodeGenController.TableInfoDto(idType=" + (Object)((Object)this.getIdType()) + ", name=" + this.getName() + ", comment=" + this.getComment() + ", fields=" + this.getFields() + ")";
        }
    }

    @ApiModel(description="\u83b7\u53d6\u65b0\u589e\u6d4b\u8bd5\u521d\u59cb\u5316\u6570\u636e\u54cd\u5e94")
    public static class GetCodeGenInfoResponse {
        private TableInfoDto tableInfo;
        @ApiModelProperty(value="\u57fa\u7840\u62e6\u622a\u8def\u5f84")
        private String baseMapping;
        @ApiModelProperty(value="\u4f5c\u8005")
        private String author = CodeGenConstants.DEFAULT_AUTHOR;
        @ApiModelProperty(value="\u6a21\u5757\u540d")
        private String module;
        @ApiModelProperty(value="\u65e5\u671f")
        private String date;
        @ApiModelProperty(value="\u540e\u53f0\u8f93\u51fa\u8def\u5f84")
        private String javaOutputDir;
        @ApiModelProperty(value="react\u8f93\u51fa\u8def\u5f84")
        private String jsOutputDir;
        @ApiModelProperty(value="\u6a21\u5757\u5305")
        private String pkg;
        @ApiModelProperty(value="\u57fa\u7840\u5305\u8def\u5f84")
        private String basePkg = CodeGenConstants.DEFAULT_BASE_PKG;
        @ApiModelProperty(value="\u6a21\u5757\u63cf\u8ff0")
        private String description;
        @ApiModelProperty(value="react\u547d\u540d\u7a7a\u95f4")
        private String namespace;

        public TableInfoDto getTableInfo() {
            return this.tableInfo;
        }

        public String getBaseMapping() {
            return this.baseMapping;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getModule() {
            return this.module;
        }

        public String getDate() {
            return this.date;
        }

        public String getJavaOutputDir() {
            return this.javaOutputDir;
        }

        public String getJsOutputDir() {
            return this.jsOutputDir;
        }

        public String getPkg() {
            return this.pkg;
        }

        public String getBasePkg() {
            return this.basePkg;
        }

        public String getDescription() {
            return this.description;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public GetCodeGenInfoResponse setTableInfo(TableInfoDto tableInfo) {
            this.tableInfo = tableInfo;
            return this;
        }

        public GetCodeGenInfoResponse setBaseMapping(String baseMapping) {
            this.baseMapping = baseMapping;
            return this;
        }

        public GetCodeGenInfoResponse setAuthor(String author) {
            this.author = author;
            return this;
        }

        public GetCodeGenInfoResponse setModule(String module) {
            this.module = module;
            return this;
        }

        public GetCodeGenInfoResponse setDate(String date) {
            this.date = date;
            return this;
        }

        public GetCodeGenInfoResponse setJavaOutputDir(String javaOutputDir) {
            this.javaOutputDir = javaOutputDir;
            return this;
        }

        public GetCodeGenInfoResponse setJsOutputDir(String jsOutputDir) {
            this.jsOutputDir = jsOutputDir;
            return this;
        }

        public GetCodeGenInfoResponse setPkg(String pkg) {
            this.pkg = pkg;
            return this;
        }

        public GetCodeGenInfoResponse setBasePkg(String basePkg) {
            this.basePkg = basePkg;
            return this;
        }

        public GetCodeGenInfoResponse setDescription(String description) {
            this.description = description;
            return this;
        }

        public GetCodeGenInfoResponse setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetCodeGenInfoResponse)) {
                return false;
            }
            GetCodeGenInfoResponse other = (GetCodeGenInfoResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TableInfoDto this$tableInfo = this.getTableInfo();
            TableInfoDto other$tableInfo = other.getTableInfo();
            if (this$tableInfo == null ? other$tableInfo != null : !((Object)this$tableInfo).equals(other$tableInfo)) {
                return false;
            }
            String this$baseMapping = this.getBaseMapping();
            String other$baseMapping = other.getBaseMapping();
            if (this$baseMapping == null ? other$baseMapping != null : !this$baseMapping.equals(other$baseMapping)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            String this$javaOutputDir = this.getJavaOutputDir();
            String other$javaOutputDir = other.getJavaOutputDir();
            if (this$javaOutputDir == null ? other$javaOutputDir != null : !this$javaOutputDir.equals(other$javaOutputDir)) {
                return false;
            }
            String this$jsOutputDir = this.getJsOutputDir();
            String other$jsOutputDir = other.getJsOutputDir();
            if (this$jsOutputDir == null ? other$jsOutputDir != null : !this$jsOutputDir.equals(other$jsOutputDir)) {
                return false;
            }
            String this$pkg = this.getPkg();
            String other$pkg = other.getPkg();
            if (this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg)) {
                return false;
            }
            String this$basePkg = this.getBasePkg();
            String other$basePkg = other.getBasePkg();
            if (this$basePkg == null ? other$basePkg != null : !this$basePkg.equals(other$basePkg)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetCodeGenInfoResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TableInfoDto $tableInfo = this.getTableInfo();
            result = result * 59 + ($tableInfo == null ? 43 : ((Object)$tableInfo).hashCode());
            String $baseMapping = this.getBaseMapping();
            result = result * 59 + ($baseMapping == null ? 43 : $baseMapping.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            String $javaOutputDir = this.getJavaOutputDir();
            result = result * 59 + ($javaOutputDir == null ? 43 : $javaOutputDir.hashCode());
            String $jsOutputDir = this.getJsOutputDir();
            result = result * 59 + ($jsOutputDir == null ? 43 : $jsOutputDir.hashCode());
            String $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
            String $basePkg = this.getBasePkg();
            result = result * 59 + ($basePkg == null ? 43 : $basePkg.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        public String toString() {
            return "CodeGenController.GetCodeGenInfoResponse(tableInfo=" + this.getTableInfo() + ", baseMapping=" + this.getBaseMapping() + ", author=" + this.getAuthor() + ", module=" + this.getModule() + ", date=" + this.getDate() + ", javaOutputDir=" + this.getJavaOutputDir() + ", jsOutputDir=" + this.getJsOutputDir() + ", pkg=" + this.getPkg() + ", basePkg=" + this.getBasePkg() + ", description=" + this.getDescription() + ", namespace=" + this.getNamespace() + ")";
        }
    }

    @ApiModel(description="\u83b7\u53d6\u4ee3\u7801\u751f\u6210\u521d\u59cb\u5316\u6570\u636e")
    public static class InitCodeGenResponse {
        @ApiModelProperty(value="\u6570\u636e\u5e93\u6240\u6709\u8868\u540d\u79f0")
        private List<String> allTableNames;
        @ApiModelProperty(value="\u4e3b\u952e\u751f\u6210\u7b56\u7565")
        private JSONObject idTypes;
        @ApiModelProperty(value="\u67e5\u8be2\u7c7b\u578b")
        private JSONObject queryTypes;
        @ApiModelProperty(value="\u663e\u793a\u7c7b\u578b\uff0c\u9875\u9762\u6587\u672c\u6846\u7684\u7c7b\u578b")
        private JSONObject showTypes;
        @ApiModelProperty(value="\u751f\u6210\u4ee3\u7801\u7c7b\u578b")
        private JSONObject codeGenTypes;
        @ApiModelProperty(value="\u5c5e\u6027\u7c7b\u578b")
        private JSONObject fieldTypes;
        @ApiModelProperty(value="\u65b0\u589e\u7c7b\u578b")
        private JSONObject addTypes;
        @ApiModelProperty(value="\u66f4\u65b0\u7c7b\u578b")
        private JSONObject updateTypes;

        public List<String> getAllTableNames() {
            return this.allTableNames;
        }

        public JSONObject getIdTypes() {
            return this.idTypes;
        }

        public JSONObject getQueryTypes() {
            return this.queryTypes;
        }

        public JSONObject getShowTypes() {
            return this.showTypes;
        }

        public JSONObject getCodeGenTypes() {
            return this.codeGenTypes;
        }

        public JSONObject getFieldTypes() {
            return this.fieldTypes;
        }

        public JSONObject getAddTypes() {
            return this.addTypes;
        }

        public JSONObject getUpdateTypes() {
            return this.updateTypes;
        }

        public InitCodeGenResponse setAllTableNames(List<String> allTableNames) {
            this.allTableNames = allTableNames;
            return this;
        }

        public InitCodeGenResponse setIdTypes(JSONObject idTypes) {
            this.idTypes = idTypes;
            return this;
        }

        public InitCodeGenResponse setQueryTypes(JSONObject queryTypes) {
            this.queryTypes = queryTypes;
            return this;
        }

        public InitCodeGenResponse setShowTypes(JSONObject showTypes) {
            this.showTypes = showTypes;
            return this;
        }

        public InitCodeGenResponse setCodeGenTypes(JSONObject codeGenTypes) {
            this.codeGenTypes = codeGenTypes;
            return this;
        }

        public InitCodeGenResponse setFieldTypes(JSONObject fieldTypes) {
            this.fieldTypes = fieldTypes;
            return this;
        }

        public InitCodeGenResponse setAddTypes(JSONObject addTypes) {
            this.addTypes = addTypes;
            return this;
        }

        public InitCodeGenResponse setUpdateTypes(JSONObject updateTypes) {
            this.updateTypes = updateTypes;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitCodeGenResponse)) {
                return false;
            }
            InitCodeGenResponse other = (InitCodeGenResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allTableNames = this.getAllTableNames();
            List<String> other$allTableNames = other.getAllTableNames();
            if (this$allTableNames == null ? other$allTableNames != null : !((Object)this$allTableNames).equals(other$allTableNames)) {
                return false;
            }
            JSONObject this$idTypes = this.getIdTypes();
            JSONObject other$idTypes = other.getIdTypes();
            if (this$idTypes == null ? other$idTypes != null : !this$idTypes.equals(other$idTypes)) {
                return false;
            }
            JSONObject this$queryTypes = this.getQueryTypes();
            JSONObject other$queryTypes = other.getQueryTypes();
            if (this$queryTypes == null ? other$queryTypes != null : !this$queryTypes.equals(other$queryTypes)) {
                return false;
            }
            JSONObject this$showTypes = this.getShowTypes();
            JSONObject other$showTypes = other.getShowTypes();
            if (this$showTypes == null ? other$showTypes != null : !this$showTypes.equals(other$showTypes)) {
                return false;
            }
            JSONObject this$codeGenTypes = this.getCodeGenTypes();
            JSONObject other$codeGenTypes = other.getCodeGenTypes();
            if (this$codeGenTypes == null ? other$codeGenTypes != null : !this$codeGenTypes.equals(other$codeGenTypes)) {
                return false;
            }
            JSONObject this$fieldTypes = this.getFieldTypes();
            JSONObject other$fieldTypes = other.getFieldTypes();
            if (this$fieldTypes == null ? other$fieldTypes != null : !this$fieldTypes.equals(other$fieldTypes)) {
                return false;
            }
            JSONObject this$addTypes = this.getAddTypes();
            JSONObject other$addTypes = other.getAddTypes();
            if (this$addTypes == null ? other$addTypes != null : !this$addTypes.equals(other$addTypes)) {
                return false;
            }
            JSONObject this$updateTypes = this.getUpdateTypes();
            JSONObject other$updateTypes = other.getUpdateTypes();
            return !(this$updateTypes == null ? other$updateTypes != null : !this$updateTypes.equals(other$updateTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitCodeGenResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allTableNames = this.getAllTableNames();
            result = result * 59 + ($allTableNames == null ? 43 : ((Object)$allTableNames).hashCode());
            JSONObject $idTypes = this.getIdTypes();
            result = result * 59 + ($idTypes == null ? 43 : $idTypes.hashCode());
            JSONObject $queryTypes = this.getQueryTypes();
            result = result * 59 + ($queryTypes == null ? 43 : $queryTypes.hashCode());
            JSONObject $showTypes = this.getShowTypes();
            result = result * 59 + ($showTypes == null ? 43 : $showTypes.hashCode());
            JSONObject $codeGenTypes = this.getCodeGenTypes();
            result = result * 59 + ($codeGenTypes == null ? 43 : $codeGenTypes.hashCode());
            JSONObject $fieldTypes = this.getFieldTypes();
            result = result * 59 + ($fieldTypes == null ? 43 : $fieldTypes.hashCode());
            JSONObject $addTypes = this.getAddTypes();
            result = result * 59 + ($addTypes == null ? 43 : $addTypes.hashCode());
            JSONObject $updateTypes = this.getUpdateTypes();
            result = result * 59 + ($updateTypes == null ? 43 : $updateTypes.hashCode());
            return result;
        }

        public String toString() {
            return "CodeGenController.InitCodeGenResponse(allTableNames=" + this.getAllTableNames() + ", idTypes=" + this.getIdTypes() + ", queryTypes=" + this.getQueryTypes() + ", showTypes=" + this.getShowTypes() + ", codeGenTypes=" + this.getCodeGenTypes() + ", fieldTypes=" + this.getFieldTypes() + ", addTypes=" + this.getAddTypes() + ", updateTypes=" + this.getUpdateTypes() + ")";
        }
    }
}

