/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.codegen.database.impl;

import com.bookrain.codegen.database.ColumnTypeConverter;
import com.bookrain.codegen.enums.FieldType;

public class MysqlColumnTypeConverter
implements ColumnTypeConverter {
    @Override
    public FieldType convert(String columnType) {
        String t = columnType.toLowerCase();
        if (t.contains("char")) {
            return FieldType.STRING;
        }
        if (t.contains("bigint")) {
            return FieldType.LONG;
        }
        if (t.contains("tinyint(1)")) {
            return FieldType.BOOLEAN;
        }
        if (t.contains("int")) {
            return FieldType.INTEGER;
        }
        if (t.contains("text")) {
            return FieldType.STRING;
        }
        if (t.contains("bit")) {
            return FieldType.BOOLEAN;
        }
        if (t.contains("decimal")) {
            return FieldType.BIG_DECIMAL;
        }
        if (t.contains("clob")) {
            return FieldType.CLOB;
        }
        if (t.contains("blob")) {
            return FieldType.BLOB;
        }
        if (t.contains("binary")) {
            return FieldType.BYTE_ARRAY;
        }
        if (t.contains("float")) {
            return FieldType.FLOAT;
        }
        if (t.contains("double")) {
            return FieldType.DOUBLE;
        }
        if (t.contains("json") || t.contains("enum")) {
            return FieldType.STRING;
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            return FieldType.DATE;
        }
        return FieldType.STRING;
    }
}

