/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.codegen.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.bookrain.codegen.config.CommonConfig;
import com.bookrain.codegen.config.DataSourceConfig;
import com.bookrain.codegen.config.StrategyConfig;
import com.bookrain.codegen.config.TemplateConfig;
import com.bookrain.codegen.database.TableQuery;
import com.bookrain.codegen.dto.TableField;
import com.bookrain.codegen.dto.TableInfo;
import com.bookrain.codegen.service.CodeGenService;
import com.bookrain.core.utils.StringUtils;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class CodeGenServiceImpl
implements CodeGenService {
    private static final Logger log = LoggerFactory.getLogger(CodeGenServiceImpl.class);
    @Autowired
    private DataSourceConfig dataSourceConfig;

    @Override
    public void generate(DataSourceConfig dataSourceConfig, CommonConfig commonConfig, TemplateConfig templateConfig, StrategyConfig strategyConfig) throws Exception {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new ClassPathResource("templates/" + name).getURL();
                }
                catch (IOException e) {
                    log.error("\u83b7\u53d6freemarker\u6a21\u677f\u5931\u8d25", (Object)e.getLocalizedMessage());
                    return null;
                }
            }
        });
        JSONObject data = new JSONObject();
        data.putAll((Map)JSONObject.parseObject((String)JSON.toJSON((Object)commonConfig).toString()));
        SimplePropertyPreFilter strategyConfigPPF = new SimplePropertyPreFilter(new String[0]);
        strategyConfigPPF.getExcludes().add("table");
        strategyConfigPPF.getExcludes().add("queryFields");
        strategyConfigPPF.getExcludes().add("addFields");
        strategyConfigPPF.getExcludes().add("updateFields");
        strategyConfigPPF.getExcludes().add("pageFields");
        strategyConfigPPF.getExcludes().add("listFields");
        strategyConfigPPF.getExcludes().add("objFields");
        data.putAll((Map)JSONObject.parseObject((String)JSON.toJSONString((Object)strategyConfig, (SerializeFilter)strategyConfigPPF, (SerializerFeature[])new SerializerFeature[0])));
        ArrayList controllerImports = new ArrayList();
        data.put("controllerImports", controllerImports);
        ArrayList queryFields = new ArrayList();
        strategyConfig.getQueryFields().forEach(queryField -> {
            JSONObject field = new JSONObject();
            field.put("columnName", (Object)queryField.getColumnName());
            field.put("name", (Object)queryField.getName());
            field.put("type", (Object)queryField.getType().getType());
            field.put("comment", (Object)queryField.getComment());
            field.put("queryType", (Object)queryField.getQueryType());
            field.put("showType", (Object)queryField.getShowType());
            if (queryField.getType().getPkg() != null && !controllerImports.contains(queryField.getType().getPkg())) {
                controllerImports.add(queryField.getType().getPkg());
            }
            queryFields.add(field);
        });
        data.put("queryFields", queryFields);
        ArrayList getFields = new ArrayList();
        strategyConfig.getAddFields().forEach(addField -> {
            JSONObject field = new JSONObject();
            field.put("name", (Object)addField.getName());
            field.put("type", (Object)addField.getType().getType());
            field.put("comment", (Object)addField.getComment());
            if (addField.getType().getPkg() != null && !controllerImports.contains(addField.getType().getPkg())) {
                controllerImports.add(addField.getType().getPkg());
            }
            getFields.add(field);
        });
        data.put("getFields", getFields);
        ArrayList addFields = new ArrayList();
        strategyConfig.getAddFields().forEach(addField -> {
            JSONObject field = new JSONObject();
            field.put("name", (Object)addField.getName());
            field.put("type", (Object)addField.getType().getType());
            field.put("comment", (Object)addField.getComment());
            field.put("required", (Object)addField.getRequired());
            if (addField.getType().getPkg() != null && !controllerImports.contains(addField.getType().getPkg())) {
                controllerImports.add(addField.getType().getPkg());
            }
            addFields.add(field);
        });
        data.put("addFields", addFields);
        ArrayList updateFields = new ArrayList();
        strategyConfig.getUpdateFields().forEach(updateField -> {
            JSONObject field = new JSONObject();
            field.put("name", (Object)updateField.getName());
            field.put("type", (Object)updateField.getType().getType());
            field.put("comment", (Object)updateField.getComment());
            field.put("required", (Object)updateField.getRequired());
            if (updateField.getType().getPkg() != null && !controllerImports.contains(updateField.getType().getPkg())) {
                controllerImports.add(updateField.getType().getPkg());
            }
            updateFields.add(field);
        });
        data.put("updateFields", updateFields);
        ArrayList listFields = new ArrayList();
        strategyConfig.getListFields().forEach(listField -> {
            JSONObject field = new JSONObject();
            field.put("name", (Object)listField.getName());
            field.put("type", (Object)listField.getType().getType());
            field.put("comment", (Object)listField.getComment());
            if (listField.getType().getPkg() != null && !controllerImports.contains(listField.getType().getPkg())) {
                controllerImports.add(listField.getType().getPkg());
            }
            listFields.add(field);
        });
        data.put("listFields", listFields);
        ArrayList objFields = new ArrayList();
        strategyConfig.getObjFields().forEach(objField -> {
            JSONObject field = new JSONObject();
            field.put("name", (Object)objField.getName());
            field.put("type", (Object)objField.getType().getType());
            field.put("comment", (Object)objField.getComment());
            if (objField.getType().getPkg() != null && !controllerImports.contains(objField.getType().getPkg())) {
                controllerImports.add(objField.getType().getPkg());
            }
            objFields.add(field);
        });
        data.put("objFields", objFields);
        ArrayList pageFields = new ArrayList();
        strategyConfig.getPageFields().forEach(pageField -> {
            JSONObject field = new JSONObject();
            field.put("name", (Object)pageField.getName());
            field.put("type", (Object)pageField.getType().getType());
            field.put("comment", (Object)pageField.getComment());
            if (pageField.getType().getPkg() != null && !controllerImports.contains(pageField.getType().getPkg())) {
                controllerImports.add(pageField.getType().getPkg());
            }
            pageFields.add(field);
        });
        data.put("pageFields", pageFields);
        JSONObject table = new JSONObject();
        SimplePropertyPreFilter tablePPF = new SimplePropertyPreFilter(new String[0]);
        tablePPF.getExcludes().add("fields");
        table.putAll((Map)JSONObject.parseObject((String)JSON.toJSONString((Object)strategyConfig.getTable(), (SerializeFilter)tablePPF, (SerializerFeature[])new SerializerFeature[0])));
        JSONArray fields = new JSONArray();
        table.put("fields", (Object)fields);
        for (TableField f : strategyConfig.getTable().getFields()) {
            JSONObject field = JSONObject.parseObject((String)JSON.toJSON((Object)f).toString());
            field.put("type", (Object)f.getType().getType());
            field.put("typePkg", (Object)f.getType().getPkg());
            fields.add((Object)field);
        }
        data.put("table", (Object)table);
        String javaBaseDir = commonConfig.getJavaOutputDir() + "/src/main/java/" + strategyConfig.getBasePkg().replace('.', '/');
        if (StringUtils.isNotBlank((String)strategyConfig.getPkg())) {
            javaBaseDir = javaBaseDir + "/" + strategyConfig.getPkg().replace('.', '/');
        }
        this.generateFile(configuration, strategyConfig.getOverride(), "java/entity.java.ftl", javaBaseDir + "/" + strategyConfig.getEntityPkg().replace('.', '/'), strategyConfig.getEntityName() + ".java", data);
        this.generateFile(configuration, strategyConfig.getOverride(), "java/dto.java.ftl", javaBaseDir + "/" + strategyConfig.getDtoPkg().replace('.', '/'), strategyConfig.getDtoName() + ".java", data);
        this.generateFile(configuration, strategyConfig.getOverride(), "java/mapper.java.ftl", javaBaseDir + "/" + strategyConfig.getMapperPkg().replace('.', '/'), strategyConfig.getMapperName() + ".java", data);
        String mapperXmlDir = commonConfig.getJavaOutputDir() + "/src/main/resources/" + strategyConfig.getMapperXmlDir();
        if (StringUtils.isNotBlank((String)strategyConfig.getPkg())) {
            mapperXmlDir = mapperXmlDir + "/" + strategyConfig.getPkg().replace('.', '/');
        }
        this.generateFile(configuration, strategyConfig.getOverride(), "java/mapper.xml.ftl", mapperXmlDir, strategyConfig.getMapperName() + ".xml", data);
        this.generateFile(configuration, strategyConfig.getOverride(), "java/service.java.ftl", javaBaseDir + "/" + strategyConfig.getServicePkg().replace('.', '/'), strategyConfig.getServiceName() + ".java", data);
        this.generateFile(configuration, strategyConfig.getOverride(), "java/serviceImpl.java.ftl", javaBaseDir + "/" + strategyConfig.getServiceImplPkg().replace('.', '/'), strategyConfig.getServiceImplName() + ".java", data);
        this.generateFile(configuration, strategyConfig.getOverride(), "java/controller.java.ftl", javaBaseDir + "/" + strategyConfig.getControllerPkg().replace('.', '/'), strategyConfig.getControllerName() + ".java", data);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableInfo getTableInfo(DataSourceConfig dataSourceConfig, String tableName) throws SQLException {
        connection = dataSourceConfig.getConnection();
        tableQuery = dataSourceConfig.getTableQuery();
        columnTypeConverter = dataSourceConfig.getColumnTypeConverter();
        tableInfo = null;
        tableSql = String.format(tableQuery.tableSql(), new Object[]{tableName});
        preparedStatement = connection.prepareStatement(tableSql);
        var9_9 = null;
        try {
            results = preparedStatement.executeQuery();
            var11_13 = null;
            try {
                while (results.next() != false) {
                    block48: {
                        block50: {
                            block49: {
                                tableName = results.getString(tableQuery.tableName());
                                if (!StringUtils.isNotEmpty((String)tableName)) ** GOTO lbl35
                                tableComment = results.getString(tableQuery.tableComment());
                                tableInfo = new TableInfo();
                                tableInfo.setName(tableName);
                                tableInfo.setComment(tableComment);
                                fields = new ArrayList<TableField>();
                                tableInfo.setFields(fields);
                                tableFieldsSql = String.format(tableQuery.tableFieldsSql(), new Object[]{tableName});
                                fieldsPreparedStatement = connection.prepareStatement(tableFieldsSql);
                                var16_20 = null;
                                fieldsResults = fieldsPreparedStatement.executeQuery();
                                var18_24 = null;
                                ** try [egrp 3[TRYBLOCK] [1, 2 : 199->445)] { 
lbl31:
                                // 1 sources

                                break block49;
lbl32:
                                // 1 sources

                                catch (Throwable var19_27) {
                                    var18_24 = var19_27;
                                    throw var19_27;
                                }
lbl35:
                                // 1 sources

                                CodeGenServiceImpl.log.error("table[" + tableName + "]\u4e0d\u5b58\u5728");
                                continue;
                            }
                            while (fieldsResults.next()) {
                                field = new TableField();
                                key = fieldsResults.getString(tableQuery.key());
                                field.setPk(StringUtils.isNotEmpty((String)tableQuery.key()) != false && "PRI".equals(key.toUpperCase()) != false);
                                fieldName = fieldsResults.getString(tableQuery.fieldName());
                                field.setColumnName(fieldName);
                                field.setColumnType(fieldsResults.getString(tableQuery.fieldType()));
                                propertyNameBuilder = new StringBuilder();
                                for (String split : fieldName.toLowerCase().split("_")) {
                                    propertyNameBuilder.append(StringUtils.capitalFirst((String)split));
                                }
                                field.setName(StringUtils.lowerFirst((String)propertyNameBuilder.toString()));
                                field.setType(columnTypeConverter.convert(tableQuery.fieldType()));
                                field.setComment(fieldsResults.getString(tableQuery.fieldComment()));
                                fields.add(field);
                            }
                            break block50;
lbl63:
                            // 1 sources

                            finally {
                                if (fieldsResults != null) {
                                    if (var18_24 != null) {
                                        try {
                                            fieldsResults.close();
                                        }
                                        catch (Throwable var19_26) {
                                            var18_24.addSuppressed(var19_26);
                                        }
                                    } else {
                                        fieldsResults.close();
                                    }
                                }
                            }
                        }
                        if (fieldsPreparedStatement == null) continue;
                        if (var16_20 == null) break block48;
                        try {
                            fieldsPreparedStatement.close();
                            continue;
                        }
                        catch (Throwable var17_22) {
                            var16_20.addSuppressed(var17_22);
                            continue;
                        }
                    }
                    fieldsPreparedStatement.close();
                }
                return tableInfo;
                catch (Throwable var17_23) {
                    try {
                        var16_20 = var17_23;
                        throw var17_23;
                    }
                    catch (Throwable var29_37) {
                        if (fieldsPreparedStatement == null) throw var29_37;
                        if (var16_20 == null) {
                            fieldsPreparedStatement.close();
                            throw var29_37;
                        }
                        try {
                            fieldsPreparedStatement.close();
                            throw var29_37;
                        }
                        catch (Throwable var30_38) {
                            var16_20.addSuppressed(var30_38);
                            throw var29_37;
                        }
                    }
                }
            }
            catch (Throwable var12_16) {
                var11_13 = var12_16;
                throw var12_16;
            }
            finally {
                if (results != null) {
                    if (var11_13 != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable var12_15) {
                            var11_13.addSuppressed(var12_15);
                        }
                    } else {
                        results.close();
                    }
                }
            }
        }
        catch (Throwable var10_12) {
            var9_9 = var10_12;
            throw var10_12;
        }
        finally {
            if (preparedStatement != null) {
                if (var9_9 != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable var10_11) {
                        var9_9.addSuppressed(var10_11);
                    }
                } else {
                    preparedStatement.close();
                }
            }
        }
    }

    @Override
    public List<String> getTableNames(DataSourceConfig dataSourceConfig) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Connection connection = dataSourceConfig.getConnection();
        TableQuery tableQuery = dataSourceConfig.getTableQuery();
        try (PreparedStatement preparedStatement = connection.prepareStatement(tableQuery.allTableSql());
             ResultSet results = preparedStatement.executeQuery();){
            while (results.next()) {
                tables.add(results.getString(tableQuery.tableName()));
            }
        }
        return tables;
    }

    private void generateFile(Configuration configuration, Boolean override, String templateFilepath, String outputDir, String filename, JSONObject data) throws Exception {
        Template template = configuration.getTemplate(templateFilepath);
        new File(outputDir).mkdirs();
        File file = new File(outputDir + "/" + filename);
        if (override.booleanValue() || !file.exists()) {
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
                template.process((Object)data, (Writer)out);
            }
        }
    }
}

