/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.file.csv;

import com.bookrain.file.csv.builder.CsvReaderBuilder;
import com.bookrain.file.csv.builder.CsvWriterBuilder;
import com.bookrain.file.csv.handler.CsvReaderHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class Csv {
    public static CsvReaderBuilder read(String filepath) throws Exception {
        return Csv.read(new File(filepath));
    }

    public static CsvReaderBuilder read(String filepath, String encoding) throws Exception {
        return Csv.read(new File(filepath), encoding);
    }

    public static CsvReaderBuilder read(String filepath, String encoding, CsvReaderHandler handler) throws Exception {
        return Csv.read(new File(filepath), encoding);
    }

    public static CsvReaderBuilder read(File file) throws Exception {
        return Csv.read(new InputStreamReader(new FileInputStream(file)));
    }

    public static CsvReaderBuilder read(File file, String encoding) throws Exception {
        return Csv.read(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
    }

    public static CsvReaderBuilder read(InputStream inputStream) {
        return Csv.read(new InputStreamReader(inputStream));
    }

    public static CsvReaderBuilder read(InputStream inputStream, String encoding) throws Exception {
        return Csv.read(new InputStreamReader(inputStream, encoding));
    }

    public static CsvReaderBuilder read(Reader reader) {
        return new CsvReaderBuilder().reader(reader);
    }

    public static CsvWriterBuilder write(String filepath) throws Exception {
        return Csv.write(new File(filepath));
    }

    public static CsvWriterBuilder write(String filepath, String encoding) throws Exception {
        return Csv.write(new File(filepath), encoding);
    }

    public static CsvWriterBuilder write(File file) throws Exception {
        return Csv.write(new OutputStreamWriter(new FileOutputStream(file)));
    }

    public static CsvWriterBuilder write(File file, String encoding) throws Exception {
        return Csv.write(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
    }

    public static CsvWriterBuilder write(OutputStream outputStream) {
        return Csv.write(new OutputStreamWriter(outputStream));
    }

    public static CsvWriterBuilder write(OutputStream outputStream, String encoding) throws Exception {
        return Csv.write(new OutputStreamWriter(outputStream, encoding));
    }

    public static CsvWriterBuilder write(Writer writer) {
        return new CsvWriterBuilder().writer(writer);
    }
}

