/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.file.csv.builder;

import com.bookrain.core.utils.StringUtils;
import com.bookrain.file.common.annotation.DateTimeFormat;
import com.bookrain.file.csv.annotation.CsvProperty;
import com.bookrain.file.csv.context.CsvReaderContext;
import com.bookrain.file.csv.handler.CsvReaderHandler;
import java.io.Reader;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(CsvReaderBuilder.class);
    private CSVFormat csvFormat = CSVFormat.DEFAULT;
    private CsvReaderHandler handler;
    private Reader reader;
    private Class clazz;
    private boolean autoClose = true;

    public CsvReaderBuilder reader(Reader reader) {
        this.reader = reader;
        return this;
    }

    public CsvReaderBuilder autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public CsvReaderBuilder handler(CsvReaderHandler handler) {
        this.handler = handler;
        return this;
    }

    public CsvReaderBuilder allowDuplicateHeaderNames() {
        this.csvFormat = this.csvFormat.withAllowDuplicateHeaderNames();
        return this;
    }

    public CsvReaderBuilder allowMissingColumnNames() {
        this.csvFormat = this.csvFormat.withAllowMissingColumnNames();
        return this;
    }

    public CsvReaderBuilder autoFlush(boolean autoFlush) {
        this.csvFormat = this.csvFormat.withAutoFlush(autoFlush);
        return this;
    }

    public CsvReaderBuilder commentMarker(Character commentMarker) {
        this.csvFormat = this.csvFormat.withCommentMarker(commentMarker);
        return this;
    }

    public CsvReaderBuilder delimiter(char delimiter) {
        this.csvFormat = this.csvFormat.withDelimiter(delimiter);
        return this;
    }

    public CsvReaderBuilder escape(Character escapeCharacter) {
        this.csvFormat = this.csvFormat.withEscape(escapeCharacter);
        return this;
    }

    public CsvReaderBuilder header(String[] headers) {
        this.csvFormat = this.csvFormat.withHeader(headers);
        return this;
    }

    public CsvReaderBuilder header(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public CsvReaderBuilder ignoreEmptyLines() {
        this.csvFormat = this.csvFormat.withIgnoreEmptyLines();
        return this;
    }

    public CsvReaderBuilder ignoreHeaderCase() {
        this.csvFormat = this.csvFormat.withIgnoreHeaderCase();
        return this;
    }

    public CsvReaderBuilder ignoreSurroundingSpaces() {
        this.csvFormat = this.csvFormat.withIgnoreSurroundingSpaces();
        return this;
    }

    public CsvReaderBuilder nullString(String nullString) {
        this.csvFormat = this.csvFormat.withNullString(nullString);
        return this;
    }

    public CsvReaderBuilder quote(Character quoteCharacter) {
        this.csvFormat = this.csvFormat.withQuote(quoteCharacter);
        return this;
    }

    public CsvReaderBuilder quoteMode(QuoteMode quoteMode) {
        this.csvFormat = this.csvFormat.withQuoteMode(quoteMode);
        return this;
    }

    public CsvReaderBuilder recordSeparator(char recordSeparator) {
        this.csvFormat = this.csvFormat.withRecordSeparator(recordSeparator);
        return this;
    }

    public CsvReaderBuilder skipHeaderRecord() {
        this.csvFormat = this.csvFormat.withSkipHeaderRecord();
        if (this.csvFormat.getHeader() == null) {
            this.csvFormat.withHeader(new String[0]);
        }
        return this;
    }

    public CsvReaderBuilder trailingDelimiter() {
        this.csvFormat = this.csvFormat.withTrailingDelimiter();
        return this;
    }

    public CsvReaderBuilder trim() {
        this.csvFormat = this.csvFormat.withTrim();
        return this;
    }

    public void doRead() throws Exception {
        this.doRead(this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRead(CsvReaderHandler handler) throws Exception {
        try {
            CSVParser csvParser = new CSVParser(this.reader, this.csvFormat);
            for (CSVRecord record : csvParser.getRecords()) {
                Object row;
                CsvReaderContext context = new CsvReaderContext(this.csvFormat, this.reader);
                context.setComment(record.getComment());
                context.setRowIndex(record.getRecordNumber() - 1L);
                if (this.clazz != null) {
                    Field[] fields;
                    row = this.clazz.newInstance();
                    for (Field field : fields = this.clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        CsvProperty csvProperty = field.getAnnotation(CsvProperty.class);
                        if (csvProperty == null) continue;
                        if (csvProperty.index() >= record.size()) {
                            throw new ArrayIndexOutOfBoundsException("index is out of range [" + record.size() + "]");
                        }
                        Object val = csvProperty.converter().newInstance().convertToJavaData(record.get(csvProperty.index()));
                        DateTimeFormat dtf = field.getAnnotation(DateTimeFormat.class);
                        if (dtf != null && StringUtils.isNotBlank((String)dtf.value()) && field.getType() == Date.class && StringUtils.isNotBlank((String)String.valueOf(val))) {
                            field.set(row, new SimpleDateFormat(dtf.value()).parse(String.valueOf(val)));
                            continue;
                        }
                        field.set(row, val);
                    }
                } else {
                    row = new HashMap();
                    for (int i = 0; i < record.size(); ++i) {
                        ((Map)row).put(i, record.get(i));
                    }
                }
                context.setRow(row);
                handler.before(context);
                try {
                    handler.handle(row, context);
                }
                catch (Exception e) {
                    handler.excetpion(e, context);
                }
                handler.after(context);
            }
        }
        finally {
            if (this.autoClose) {
                this.reader.close();
            }
        }
    }
}

