/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.file.csv.builder;

import com.bookrain.core.utils.StringUtils;
import com.bookrain.file.common.annotation.DateTimeFormat;
import com.bookrain.file.csv.annotation.CsvProperty;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.ehcache.spi.serialization.UnsupportedTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvWriterBuilder {
    private static final Logger log = LoggerFactory.getLogger(CsvWriterBuilder.class);
    private CSVFormat csvFormat = CSVFormat.DEFAULT;
    private Class clazz;
    private Writer writer;
    private boolean autoClose = true;

    public CsvWriterBuilder writer(Writer writer) {
        this.writer = writer;
        return this;
    }

    public CsvWriterBuilder autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public CsvWriterBuilder allowDuplicateHeaderNames() {
        this.csvFormat = this.csvFormat.withAllowDuplicateHeaderNames();
        return this;
    }

    public CsvWriterBuilder allowMissingColumnNames() {
        this.csvFormat = this.csvFormat.withAllowMissingColumnNames();
        return this;
    }

    public CsvWriterBuilder autoFlush(boolean autoFlush) {
        this.csvFormat = this.csvFormat.withAutoFlush(autoFlush);
        return this;
    }

    public CsvWriterBuilder commentMarker(Character commentMarker) {
        this.csvFormat = this.csvFormat.withCommentMarker(commentMarker);
        return this;
    }

    public CsvWriterBuilder delimiter(char delimiter) {
        this.csvFormat = this.csvFormat.withDelimiter(delimiter);
        return this;
    }

    public CsvWriterBuilder escape(Character escapeCharacter) {
        this.csvFormat = this.csvFormat.withEscape(escapeCharacter);
        return this;
    }

    public CsvWriterBuilder header(String[] headers) {
        this.csvFormat = this.csvFormat.withHeader(headers);
        return this;
    }

    public CsvWriterBuilder header(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public CsvWriterBuilder ignoreEmptyLines() {
        this.csvFormat = this.csvFormat.withIgnoreEmptyLines();
        return this;
    }

    public CsvWriterBuilder ignoreHeaderCase() {
        this.csvFormat = this.csvFormat.withIgnoreHeaderCase();
        return this;
    }

    public CsvWriterBuilder ignoreSurroundingSpaces() {
        this.csvFormat = this.csvFormat.withIgnoreSurroundingSpaces();
        return this;
    }

    public CsvWriterBuilder nullString(String nullString) {
        this.csvFormat = this.csvFormat.withNullString(nullString);
        return this;
    }

    public CsvWriterBuilder quote(Character quoteCharacter) {
        this.csvFormat = this.csvFormat.withQuote(quoteCharacter);
        return this;
    }

    public CsvWriterBuilder quoteMode(QuoteMode quoteMode) {
        this.csvFormat = this.csvFormat.withQuoteMode(quoteMode);
        return this;
    }

    public CsvWriterBuilder recordSeparator(char recordSeparator) {
        this.csvFormat = this.csvFormat.withRecordSeparator(recordSeparator);
        return this;
    }

    public CsvWriterBuilder skipHeaderRecord() {
        this.csvFormat = this.csvFormat.withSkipHeaderRecord();
        if (this.csvFormat.getHeader() == null) {
            this.csvFormat.withHeader(new String[0]);
        }
        return this;
    }

    public CsvWriterBuilder trailingDelimiter() {
        this.csvFormat = this.csvFormat.withTrailingDelimiter();
        return this;
    }

    public CsvWriterBuilder trim() {
        this.csvFormat = this.csvFormat.withTrim();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWrite(List data) throws Exception {
        try {
            CSVPrinter printer = new CSVPrinter((Appendable)this.writer, this.csvFormat);
            for (Object record : data) {
                ArrayList<String> row = new ArrayList<String>();
                if (this.clazz != null && record.getClass() == this.clazz) {
                    Field[] fields;
                    for (Field field : fields = this.clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        CsvProperty csvProperty = field.getAnnotation(CsvProperty.class);
                        if (csvProperty == null) continue;
                        int index = csvProperty.index();
                        Object val = csvProperty.converter().newInstance().convertToFileData(field.get(record));
                        DateTimeFormat dtf = field.getAnnotation(DateTimeFormat.class);
                        if (dtf != null && StringUtils.isNotBlank((String)dtf.value())) {
                            if (field.getType() != Date.class) continue;
                            row.add(index, new SimpleDateFormat(dtf.value()).format(val));
                            continue;
                        }
                        row.add(index, String.valueOf(val));
                    }
                    printer.printRecord(row);
                    continue;
                }
                if (record instanceof List) {
                    printer.printRecord((Iterable)((List)record));
                    continue;
                }
                throw new UnsupportedTypeException(record.getClass().getCanonicalName());
            }
        }
        finally {
            if (this.autoClose) {
                this.writer.close();
            }
        }
    }
}

