/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.file.txt;

import com.bookrain.file.csv.handler.CsvReaderHandler;
import com.bookrain.file.txt.builder.TxtReaderBuilder;
import com.bookrain.file.txt.builder.TxtWriterBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class Txt {
    public static TxtReaderBuilder read(String filepath) throws Exception {
        return Txt.read(new File(filepath));
    }

    public static TxtReaderBuilder read(String filepath, String encoding) throws Exception {
        return Txt.read(new File(filepath), encoding);
    }

    public static TxtReaderBuilder read(String filepath, String encoding, CsvReaderHandler handler) throws Exception {
        return Txt.read(new File(filepath), encoding);
    }

    public static TxtReaderBuilder read(File file) throws Exception {
        return Txt.read(new InputStreamReader(new FileInputStream(file)));
    }

    public static TxtReaderBuilder read(File file, String encoding) throws Exception {
        return Txt.read(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
    }

    public static TxtReaderBuilder read(InputStream inputStream) {
        return Txt.read(new InputStreamReader(inputStream));
    }

    public static TxtReaderBuilder read(InputStream inputStream, String encoding) throws Exception {
        return Txt.read(new InputStreamReader(inputStream, encoding));
    }

    public static TxtReaderBuilder read(Reader reader) {
        return new TxtReaderBuilder().reader(reader);
    }

    public static TxtWriterBuilder write(String filepath) throws Exception {
        return Txt.write(new File(filepath));
    }

    public static TxtWriterBuilder write(String filepath, String encoding) throws Exception {
        return Txt.write(new File(filepath), encoding);
    }

    public static TxtWriterBuilder write(File file) throws Exception {
        return Txt.write(new FileWriter(file));
    }

    public static TxtWriterBuilder write(File file, String encoding) throws Exception {
        return Txt.write(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
    }

    public static TxtWriterBuilder write(OutputStream outputStream) {
        return Txt.write(new OutputStreamWriter(outputStream));
    }

    public static TxtWriterBuilder write(OutputStream outputStream, String encoding) throws Exception {
        return Txt.write(new OutputStreamWriter(outputStream, encoding));
    }

    public static TxtWriterBuilder write(Writer writer) {
        return new TxtWriterBuilder().writer(writer);
    }
}

