/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.file.txt.builder;

import com.bookrain.core.utils.StringUtils;
import com.bookrain.file.common.annotation.DateTimeFormat;
import com.bookrain.file.txt.annotation.TxtProperty;
import com.bookrain.file.txt.context.TxtReaderContext;
import com.bookrain.file.txt.handler.TxtReaderHandler;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TxtReaderBuilder {
    private String seperator;
    private Reader reader;
    private boolean autoClose;
    private Class clazz;
    private TxtReaderHandler handler;
    private boolean isHeader;
    private List<String> headers = new ArrayList<String>();

    public TxtReaderBuilder seperator(String seperator) {
        this.seperator = seperator;
        return this;
    }

    public TxtReaderBuilder reader(Reader reader) {
        this.reader = reader;
        return this;
    }

    public TxtReaderBuilder handler(TxtReaderHandler handler) {
        this.handler = handler;
        return this;
    }

    public TxtReaderBuilder header(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public TxtReaderBuilder header(List<String> headers) {
        this.headers = headers;
        return this;
    }

    public TxtReaderBuilder isHeader(boolean header) {
        this.isHeader = this.isHeader;
        return this;
    }

    public TxtReaderBuilder autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public void doRead(TxtReaderHandler handler) throws Exception {
        if (this.reader != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(this.reader);
                int rowIndex = -1;
                while ((line = br.readLine()) != null) {
                    HashMap row;
                    TxtReaderContext context = new TxtReaderContext();
                    if (this.isHeader && rowIndex < 0) {
                        String[] headers = line.split(this.seperator);
                        if (headers.length > 0) {
                            context.getHeaders().addAll(Arrays.asList(headers));
                            this.headers = Arrays.asList(headers);
                            continue;
                        }
                        if (this.headers.size() <= 0) continue;
                        context.getHeaders().addAll(this.headers);
                        continue;
                    }
                    context.setRawData(line);
                    context.setRowIndex(++rowIndex);
                    String[] cols = line.split(this.seperator);
                    if (this.clazz == null) {
                        row = new HashMap();
                        for (int i = 0; i < cols.length; ++i) {
                            ((Map)row).put(i, cols[i]);
                        }
                        context.setRow(row);
                    } else {
                        Field[] fields;
                        row = this.clazz.newInstance();
                        for (Field field : fields = this.clazz.getDeclaredFields()) {
                            field.setAccessible(true);
                            TxtProperty txtProperty = field.getAnnotation(TxtProperty.class);
                            if (txtProperty == null) continue;
                            int index = txtProperty.index();
                            if (index >= cols.length) {
                                throw new ArrayIndexOutOfBoundsException("index is out of range [" + cols.length + "]");
                            }
                            Object val = txtProperty.converter().newInstance().convertToJavaData(cols[index]);
                            DateTimeFormat dtf = field.getAnnotation(DateTimeFormat.class);
                            if (dtf != null && StringUtils.isNotBlank((String)dtf.value()) && field.getType() == Date.class && StringUtils.isNotBlank((String)String.valueOf(val))) {
                                field.set(row, new SimpleDateFormat(dtf.value()).parse(String.valueOf(val)));
                                continue;
                            }
                            field.set(row, val);
                        }
                        context.setRow(row);
                    }
                    handler.before(context);
                    try {
                        handler.handle(row, context);
                    }
                    catch (Exception e) {
                        handler.excetpion(e, context);
                    }
                    handler.after(context);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (this.autoClose) {
                    this.reader.close();
                }
            }
        }
        throw new NullPointerException("reader is null");
    }
}

