/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.file.txt.builder;

import com.bookrain.core.utils.StringUtils;
import com.bookrain.file.common.annotation.DateTimeFormat;
import com.bookrain.file.txt.annotation.TxtProperty;
import com.bookrain.file.txt.handler.TxtReaderHandler;
import com.google.common.base.Joiner;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.ehcache.spi.serialization.UnsupportedTypeException;

public class TxtWriterBuilder {
    private String seperator = ",";
    private Writer writer;
    private boolean autoClose;
    private Class clazz;
    private TxtReaderHandler handler;
    private boolean isHeader;
    private List<String> headers = new ArrayList<String>();

    public TxtWriterBuilder seperator(String seperator) {
        this.seperator = seperator;
        return this;
    }

    public TxtWriterBuilder writer(Writer writer) {
        this.writer = writer;
        return this;
    }

    public TxtWriterBuilder handler(TxtReaderHandler handler) {
        this.handler = handler;
        return this;
    }

    public TxtWriterBuilder header(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public TxtWriterBuilder header(List<String> headers) {
        this.headers = headers;
        return this;
    }

    public TxtWriterBuilder isHeader(boolean header) {
        this.isHeader = this.isHeader;
        return this;
    }

    public TxtWriterBuilder autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public void doWrite(List data) throws Exception {
        if (this.writer != null) {
            try {
                if (this.isHeader && this.headers.size() > 0) {
                    this.writer.write(Joiner.on((String)this.seperator).useForNull("").join(this.headers));
                }
                for (int i = 0; i < data.size(); ++i) {
                    if (this.clazz != null && data.get(i).getClass() == this.clazz) {
                        Field[] fields;
                        ArrayList<Object> row = new ArrayList<Object>();
                        for (Field field : fields = this.clazz.getDeclaredFields()) {
                            TxtProperty txtProperty = field.getAnnotation(TxtProperty.class);
                            if (txtProperty == null) continue;
                            int index = txtProperty.index();
                            Object val = txtProperty.converter().newInstance().convertToFileData(field.get(data.get(i)));
                            DateTimeFormat dtf = field.getAnnotation(DateTimeFormat.class);
                            if (dtf != null && StringUtils.isNotBlank((String)dtf.value()) && field.getType() == Date.class && val != null) {
                                row.add(index, new SimpleDateFormat(dtf.value()).format(val));
                                continue;
                            }
                            row.add(index, val);
                        }
                        this.writer.write(Joiner.on((String)this.seperator).useForNull("").join(row));
                        continue;
                    }
                    if (data.get(i) instanceof List) {
                        this.writer.write(Joiner.on((String)this.seperator).useForNull("").join((Iterable)((List)data.get(i))));
                        if (i >= data.size() - 1) continue;
                        this.writer.write(System.getProperty("line.separator"));
                        continue;
                    }
                    throw new UnsupportedTypeException("data type is not supported");
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (this.autoClose) {
                    this.writer.close();
                }
            }
        } else {
            throw new NullPointerException();
        }
    }
}

