/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.qrcode.properties;

import java.awt.Font;
import java.awt.image.BufferedImage;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * .
 *
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-07-08 00:31
 */
@Data
@Accessors(chain = true)
public class QrCodeProperties {

    private String fileFormat = "png";
    private String content;
    private String charSet = "utf-8";
    private Size size = new Size().setWidth(200).setHeight(200);
    private Integer margin = 0;
    private Point topLeft;
    private Point bottomRight;
    private Boolean showDesc = false;
    private Boolean showLogo = false;
    private Logo logo;
    private Desc desc;

    @Data
    @Accessors(chain = true)
    public static class Desc {

        private String desc;

        private Boolean center = false;

        private Font font = new Font("", Font.PLAIN, 16);

        private Integer margin = 4;
    }

    @Data
    @Accessors(chain = true)
    public static class Logo {

        private BufferedImage logo;
        private Size size;
        private Float ratio = 1 - 0.618f;
    }

    @Data
    @Accessors(chain = true)
    public static class Size {

        private Integer width;
        private Integer height;
    }

    @Data
    @Accessors(chain = true)
    public static class Point {

        private Integer x;
        private Integer y;
    }
}
