/*
 * Decompiled with CFR 0.152.
 */
package com.bookrain.qrcode.generator;

import com.bookrain.qrcode.properties.QrCodeProperties;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class QrCodeGenerator {
    public static void drawQrCodeImage(QrCodeProperties qrCodeProperties, OutputStream output) throws Exception {
        BufferedImage qrCodeImage = QrCodeGenerator.drawRawQrCodeImage(qrCodeProperties);
        int width = qrCodeImage.getWidth();
        int height = qrCodeImage.getHeight();
        int widthWithoutMargin = qrCodeProperties.getBottomRight().getX() - qrCodeProperties.getTopLeft().getX();
        if (qrCodeProperties.getShowLogo().booleanValue()) {
            int logoHeight;
            int logoWidth;
            QrCodeProperties.Logo logo = qrCodeProperties.getLogo();
            if (qrCodeProperties.getLogo().getSize() == null) {
                logoWidth = (int)((float)qrCodeProperties.getSize().getWidth().intValue() * logo.getRatio().floatValue());
                logoHeight = (int)((float)qrCodeProperties.getSize().getHeight().intValue() * logo.getRatio().floatValue());
            } else {
                logoWidth = logo.getSize().getWidth();
                logoHeight = logo.getSize().getHeight();
            }
            int x = (width - logoWidth) / 2;
            int y = (height - logoHeight) / 2;
            qrCodeImage.getGraphics().drawImage(logo.getLogo(), x, y, logoWidth, logoHeight, null);
        }
        if (qrCodeProperties.getShowDesc().booleanValue()) {
            QrCodeProperties.Desc desc = qrCodeProperties.getDesc();
            int fontHeight = qrCodeImage.getGraphics().getFontMetrics(desc.getFont()).getHeight();
            ArrayList<String> lines = new ArrayList<String>();
            int lineNo = 1;
            int lineWidth = 0;
            String line = "";
            for (int i = 0; i < desc.getDesc().length(); ++i) {
                char c = desc.getDesc().charAt(i);
                int charWidth = qrCodeImage.getGraphics().getFontMetrics(desc.getFont()).charWidth(c);
                if (lineWidth + charWidth > widthWithoutMargin) {
                    ++lineNo;
                    lines.add(line);
                    line = "";
                    lineWidth = 0;
                    continue;
                }
                lineWidth += charWidth;
                line = line + c;
            }
            if (!"".equals(line)) {
                lines.add(line);
            }
            int descHeight = fontHeight * lineNo;
            int descBufferedImageHeight = height + descHeight + desc.getMargin() - (height - qrCodeProperties.getBottomRight().getY());
            BufferedImage descBufferedImage = new BufferedImage(width, descBufferedImageHeight, 1);
            Graphics graphics = descBufferedImage.getGraphics();
            int finalDescHeight = descHeight + desc.getMargin() - (height - qrCodeProperties.getBottomRight().getY());
            if (finalDescHeight > 0) {
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, height, width, finalDescHeight);
            }
            graphics.setColor(Color.black);
            graphics.setFont(desc.getFont());
            graphics.drawImage(qrCodeImage, 0, 0, null);
            for (int i = 0; i < lines.size(); ++i) {
                lineWidth = graphics.getFontMetrics(desc.getFont()).stringWidth((String)lines.get(i));
                int startX = qrCodeProperties.getTopLeft().getX();
                if (desc.getCenter().booleanValue()) {
                    startX = (width - lineWidth) / 2;
                }
                graphics.drawString((String)lines.get(i), startX, qrCodeProperties.getBottomRight().getY() + 1 + graphics.getFontMetrics().getAscent() + fontHeight * i + desc.getMargin());
            }
            graphics.dispose();
            qrCodeImage = descBufferedImage;
        }
        ImageIO.write((RenderedImage)qrCodeImage, qrCodeProperties.getFileFormat(), output);
    }

    public static void drawQrCodeImage(QrCodeProperties qrCodeProperties, File qrCodeFile) throws Exception {
        QrCodeGenerator.drawQrCodeImage(qrCodeProperties, new FileOutputStream(qrCodeFile));
    }

    public static void drawQrCodeImage(QrCodeProperties qrCodeProperties, String filePath) throws Exception {
        QrCodeGenerator.drawQrCodeImage(qrCodeProperties, new File(filePath));
    }

    private static BufferedImage drawRawQrCodeImage(QrCodeProperties qrCodeProperties) throws Exception {
        String contents = qrCodeProperties.getContent();
        HashMap<EncodeHintType, Object> hint = new HashMap<EncodeHintType, Object>();
        hint.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hint.put(EncodeHintType.CHARACTER_SET, qrCodeProperties.getCharSet());
        hint.put(EncodeHintType.MARGIN, qrCodeProperties.getMargin());
        MultiFormatWriter writer = new MultiFormatWriter();
        BitMatrix bm = writer.encode(contents, BarcodeFormat.QR_CODE, qrCodeProperties.getSize().getWidth().intValue(), qrCodeProperties.getSize().getHeight().intValue(), hint);
        int[] topLeft = bm.getTopLeftOnBit();
        int[] bottomRight = bm.getBottomRightOnBit();
        qrCodeProperties.setTopLeft(new QrCodeProperties.Point().setX(topLeft[0]).setY(topLeft[1]));
        qrCodeProperties.setBottomRight(new QrCodeProperties.Point().setX(bottomRight[0]).setY(bottomRight[1]));
        BufferedImage img = new BufferedImage(bm.getWidth(), bm.getHeight(), 1);
        for (int x = 0; x < bm.getWidth(); ++x) {
            for (int y = 0; y < bm.getHeight(); ++y) {
                img.setRGB(x, y, bm.get(x, y) ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
            }
        }
        return img;
    }
}

