package com.bookrain.wechat.pay.model;

public class WxPayField {

  /** 签名 */
  public static final String SIGN = "sign";

  /** 微信分配的公众账号ID */
  public static final String APPID = "appid";

  /** 微信支付分配的商户号 */
  public static final String MCH_ID = "mch_id";

  /** 微信支付分配的终端设备号，商户自定义 */
  public static final String DEVICE_INFO = "device_info";

  /** 随机字符串，不长于32位。推荐随机数生成算法 */
  public static final String NONCE_STR = "nonce_str";

  /** 商品或支付单简要描述 */
  public static final String BODY = "body";

  /** 商品名称明细列表 */
  public static final String DETAIL = "detail";

  /** 附加数据，在查询API和支付通知中原样返回，该字段主要用于商户携带订单的自定义数据 */
  public static final String ATTACH = "attach";

  /** 商户系统内部的订单号,32个字符内、可包含字母, 其他说明见商户订单号 */
  public static final String OUT_TRADE_NO = "out_trade_no";

  /** 符合ISO 4217标准的三位字母代码，默认人民币：CNY，其他值列表详见货币类型 */
  public static final String FEE_TYPE = "fee_type";

  /** 订单总金额，只能为整数，详见支付金额 */
  public static final String TOTAL_FEE = "total_fee";

  /** APP和网页支付提交用户端ip，Native支付填调用微信支付API的机器IP。 */
  public static final String SPBILL_CREATE_IP = "spbill_create_ip";

  /** 订单生成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。其他详见时间规则的值 */
  public static final String TIME_START = "time_start";

  /** 订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。其他详见时间规则 */
  public static final String TIME_EXPIRE = "time_expire";

  /** 商品标记，代金券或立减优惠功能的参数，说明详见代金券或立减优惠 */
  public static final String GOODS_TAG = "goods_tag";

  /** 获取需要转换的URL，签名用原串，传输需URL encode的值 */
  public static final String LONG_URL = "long_url";

  /** 接收微信支付异步通知回调地址 */
  public static final String NOTIFY_URL = "notify_url";

  /** 取值如下：JSAPI，NATIVE，APP，详细说明见参数规定 */
  public static final String TRADE_TYPE = "trade_type";

  /** trade_type=NATIVE，此参数必传。此id为二维码中包含的商品ID，商户自行定义。 */
  public static final String PRODUCT_ID = "product_id";

  /** trade_type=JSAPI，此参数必传，用户在商户appid下的唯一标识。下单前需要调用【网页授权获取用户信息】接口获取到用户的Openid。 */
  public static final String OPENID = "openid";

  /**
   * 上报对应的接口的完整URL，类似：https://api.mch.weixin.qq.com/pay/unifiedorder对于被扫支付，为更好的和商户共同分析一次业务行为的整体耗时情况，对于两种接入模式，请都在门店侧对一次被扫行为进行一次单独的整体上报，上报URL指定为：https://api.mch.weixin.qq.com/pay/micropay/total关于两种接入模式具体可参考本文档章节：被扫支付商户接入模式其它接口调用仍然按照调用一次，上报一次来进行。
   */
  public static final String INTERFACE_URL = "interface_url";

  /** 接口耗时情况，单位为毫秒 */
  public static final String EXECUTE_TIME_ = "execute_time_";

  /** SUCCESS/FAIL此字段是通信标识，非交易标识，交易是否成功需要查看trade_state来判断 */
  public static final String RETURN_CODE = "return_code";

  /** 设置返回信息，如非空，为错误原因签名失败参数格式校验错误 */
  public static final String RETURN_MSG = "return_msg";

  /** SUCCESS/FAIL */
  public static final String RESULT_CODE = "result_code";

  /** ORDERNOTEXIST—订单不存在SYSTEMERROR—系统错误 */
  public static final String ERR_CODE = "err_code";

  /** 结果信息描述 */
  public static final String ERR_CODE_DES = "err_code_des";

  /** 发起接口调用时的机器IP */
  public static final String USER_IP = "user_ip";

  /** 系统时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。其他详见时间规则 */
  public static final String TIME = "time";

  /** 微信的订单号 */
  public static final String TRANSACTION_ID = "transaction_id";

  /** 商户系统内部的退款单号，商户系统内部唯一，同一退款单号多次请求只退一笔 */
  public static final String OUT_REFUND_NO = "out_refund_no";

  /** 退款总金额，订单总金额，单位为分，只能为整数，详见支付金额 */
  public static final String REFUND_FEE = "refund_fee";

  /** 货币类型，符合ISO 4217标准的三位字母代码，默认人民币：CNY，其他值列表详见货币类型 */
  public static final String REFUND_FEE_TYPE = "refund_fee_type";

  /** 操作员帐号, 默认为商户号的值 */
  public static final String OP_USER_ID = "op_user_id";

  /**
   * 微信退款单号refund_id、out_refund_no、out_trade_no、transaction_id四个参数必填一个，如果同时存在优先级为：refund_id&gt;out_refund_no&gt;transaction_id&gt;out_trade_no
   */
  public static final String REFUND_ID = "refund_id";

  /** 下载对账单的日期，格式：20140603 */
  public static final String BILL_DATE = "bill_date";

  /** 设置ALL，返回当日所有订单信息，默认值SUCCESS，返回当日成功支付的订单REFUND，返回当日退款订单REVOKED，已撤销的订单 */
  public static final String BILL_TYPE = "bill_type";

  /** 设置扫码支付授权码，设备读取用户微信中的条码或者二维码信息 */
  public static final String AUTH_CODE = "auth_code";

  /** 设置支付时间戳 */
  public static final String TIME_STAMP = "time_stamp";

}
