package com.bookrain.wechat.pay.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 提交被扫输入对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class WxPayMicroPayRequest extends WxPayBaseRequest {

    @JSONField(name = WxPayField.DEVICE_INFO)
    private String deviceInfo;

    @JSONField(name = WxPayField.BODY)
    private String body;

    @JSONField(name = WxPayField.DETAIL)
    private String detail;

    @JSONField(name = WxPayField.ATTACH)
    private String attach;

    @JSONField(name = WxPayField.OUT_TRADE_NO)
    private String outTradeNo;

    @JSONField(name = WxPayField.TOTAL_FEE)
    private String totalFee;

    @JSONField(name = WxPayField.FEE_TYPE)
    private String feeType;

    @JSONField(name = WxPayField.SPBILL_CREATE_IP)
    private String spbillCreateIp;

    @JSONField(name = WxPayField.TIME_START)
    private String timeStart;

    @JSONField(name = WxPayField.TIME_EXPIRE)
    private String timeExpire;

    @JSONField(name = WxPayField.GOODS_TAG)
    private String goodsTag;

    @JSONField(name = WxPayField.AUTH_CODE)
    private String authCode;
}
