package com.bookrain.wechat.pay.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 统一下单输入对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class WxPayUnifiedOrderRequest extends WxPayBaseRequest {

    @JSONField(name = WxPayField.DEVICE_INFO)
    private String deviceInfo;

    @JSONField(name = WxPayField.BODY)
    private String body;

    @JSONField(name = WxPayField.DETAIL)
    private String detail;

    @JSONField(name = WxPayField.ATTACH)
    private String attach;

    @JSONField(name = WxPayField.OUT_TRADE_NO)
    private String outTradeNo;

    @JSONField(name = WxPayField.FEE_TYPE)
    private String feeType;

    @JSONField(name = WxPayField.TOTAL_FEE)
    private String totalFee;

    @JSONField(name = WxPayField.SPBILL_CREATE_IP)
    private String spbillCreateIp;

    @JSONField(name = WxPayField.TIME_START)
    private String timeStart;

    @JSONField(name = WxPayField.TIME_EXPIRE)
    private String timeExpire;

    @JSONField(name = WxPayField.GOODS_TAG)
    private String goodsTag;

    @JSONField(name = WxPayField.NOTIFY_URL)
    private String notifyUrl;

    @JSONField(name = WxPayField.TRADE_TYPE)
    private String tradeType;

    @JSONField(name = WxPayField.PRODUCT_ID)
    private String productId;

    @JSONField(name = WxPayField.OPENID)
    private String openid;
}
