/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.wechat.pay.rest;

import com.bookrain.core.rest.RestTemplateBuilder;
import com.bookrain.core.ssl.SSLConnectionSocketFactoryBuilder;
import com.bookrain.wechat.properties.WeChatProperties;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * .
 *
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-07-25 15:08
 */
@Component
public class WxPayRestTemplateBuilder {

    private static final Integer DEFAULT_TIMEOUT = 60000;
    @Autowired
    private WeChatProperties weChatProperties;

    public RestTemplate createRestTemplate() throws Exception {
        return createRestTemplate(false, DEFAULT_TIMEOUT);
    }

    public RestTemplate createRestTemplate(Integer timeout) throws Exception {
        return createRestTemplate(false, timeout);
    }

    public RestTemplate createRestTemplate(Boolean ssl) throws Exception {
        return createRestTemplate(ssl, DEFAULT_TIMEOUT);
    }

    public RestTemplate createRestTemplate(Boolean ssl, int timeout) throws Exception {
        if (ssl) {
            SSLConnectionSocketFactory sslcf =
                SSLConnectionSocketFactoryBuilder.getInstance()
                    .protocol("TLSv1")
                    .keyStoreType("PKCS12")
                    .keyStoreUrl(new ClassPathResource(weChatProperties.getKeyStoreFilePath()).getURL())
                    .keyPassword(weChatProperties.getKeyStorePassword())
                    .trustAll(true)
                    .hostnameVerifier((urlHostName, session) -> true).build();
            return RestTemplateBuilder.getInstance().sslConnectionSocketFactory(sslcf).readTimeout(timeout).build();
        } else {
            return RestTemplateBuilder.getInstance().readTimeout(timeout).build();
        }
    }
}
