/*
 * Copyright (c) 2019, BookRain Ltd.
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of BookRain Ltd. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BookRain Ltd. AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.bookrain.wechat.pay.service;

import com.bookrain.wechat.pay.model.WXPayOrderQueryRequest;
import com.bookrain.wechat.pay.model.WxPayCloseOrderRequest;
import com.bookrain.wechat.pay.model.WxPayDownloadBillRequest;
import com.bookrain.wechat.pay.model.WxPayMicroPayRequest;
import com.bookrain.wechat.pay.model.WxPayRefundQueryRequest;
import com.bookrain.wechat.pay.model.WxPayRefundRequest;
import com.bookrain.wechat.pay.model.WxPayReverseRequest;
import com.bookrain.wechat.pay.model.WxPayShortUrlRequest;
import com.bookrain.wechat.pay.model.WxPayUnifiedOrderRequest;
import com.bookrain.wechat.pay.model.WxPayAuthCodeToOpenIdRequest;
import com.bookrain.wechat.pay.model.WxPayReportRequest;
import java.util.Map;

/**
 * .
 *
 * <p>
 *
 * @author Bookrain Chu
 * @version 1.0
 * @date 2019-07-25 14:36
 */
public interface WxPayService {

    /**
     * 作用：提交刷卡支付<br> 场景：刷卡支付
     *
     * @param microPayRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> microPay(WxPayMicroPayRequest microPayRequest) throws Exception;

    /**
     * 作用：提交刷卡支付<br> 场景：刷卡支付
     *
     * @param microPayRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> microPay(WxPayMicroPayRequest microPayRequest, int timeout) throws Exception;

    /**
     * 作用：统一下单<br> 场景：公共号支付、扫码支付、APP支付
     *
     * @param unifiedOrderRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> unifiedOrder(WxPayUnifiedOrderRequest unifiedOrderRequest) throws Exception;

    /**
     * 作用：统一下单<br> 场景：公共号支付、扫码支付、APP支付
     *
     * @param unifiedOrderRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> unifiedOrder(WxPayUnifiedOrderRequest unifiedOrderRequest, int timeout) throws Exception;

    /**
     * 作用：查询订单<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param orderQueryRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> orderQuery(WXPayOrderQueryRequest orderQueryRequest) throws Exception;

    /**
     * 作用：查询订单<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param orderQueryRequest 向wxpay post的请求数据 int
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> orderQuery(WXPayOrderQueryRequest orderQueryRequest, int timeout) throws Exception;

    /**
     * 作用：撤销订单<br> 场景：刷卡支付
     *
     * @param payReverseRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> reverse(WxPayReverseRequest payReverseRequest) throws Exception;

    /**
     * 作用：撤销订单<br> 场景：刷卡支付<br> 其他：需要证书
     *
     * @param payReverseRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> reverse(WxPayReverseRequest payReverseRequest, int timeout) throws Exception;

    /**
     * 作用：关闭订单<br> 场景：公共号支付、扫码支付、APP支付
     *
     * @param closeOrderRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> closeOrder(WxPayCloseOrderRequest closeOrderRequest) throws Exception;

    /**
     * 作用：关闭订单<br> 场景：公共号支付、扫码支付、APP支付
     *
     * @param closeOrderRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> closeOrder(WxPayCloseOrderRequest closeOrderRequest, int timeout) throws Exception;

    /**
     * 作用：申请退款<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param refundRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> refund(WxPayRefundRequest refundRequest) throws Exception;

    /**
     * 作用：申请退款<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付<br> 其他：需要证书
     *
     * @param refundRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> refund(WxPayRefundRequest refundRequest, int timeout) throws Exception;

    /**
     * 作用：退款查询<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param refundQueryRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> refundQuery(WxPayRefundQueryRequest refundQueryRequest) throws Exception;


    /**
     * 作用：退款查询<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param refundQueryRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> refundQuery(WxPayRefundQueryRequest refundQueryRequest, int timeout) throws Exception;


    /**
     * 作用：对账单下载（成功时返回对账单数据，失败时返回XML格式数据）<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param downloadBillRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> downloadBill(WxPayDownloadBillRequest downloadBillRequest) throws Exception;

    /**
     * 作用：对账单下载<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付<br> 其他：无论是否成功都返回Map。若成功，返回的Map中含有return_code、return_msg、data， 其中return_code为`SUCCESS`，data为对账单数据。
     *
     * @param downloadBillRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return 经过封装的API返回数据
     * @throws Exception 异常
     */
    Map<String, String> downloadBill(WxPayDownloadBillRequest downloadBillRequest, int timeout) throws Exception;

    /**
     * 作用：交易保障<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param reportRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> report(WxPayReportRequest reportRequest) throws Exception;

    /**
     * 作用：交易保障<br> 场景：刷卡支付、公共号支付、扫码支付、APP支付
     *
     * @param reportRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> report(WxPayReportRequest reportRequest, int timeout) throws Exception;

    /**
     * 作用：转换短链接<br> 场景：刷卡支付、扫码支付
     *
     * @param shortUrlRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> shortUrl(WxPayShortUrlRequest shortUrlRequest) throws Exception;

    /**
     * 作用：转换短链接<br> 场景：刷卡支付、扫码支付
     *
     * @param shortUrlRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> shortUrl(WxPayShortUrlRequest shortUrlRequest, int timeout) throws Exception;


    /**
     * 作用：授权码查询OPENID接口<br> 场景：刷卡支付
     *
     * @param authCodeToOpenIdRequest 向wxpay post的请求数据
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> authCodeToOpenid(WxPayAuthCodeToOpenIdRequest authCodeToOpenIdRequest) throws Exception;


    /**
     * 作用：授权码查询OPENID接口<br> 场景：刷卡支付
     *
     * @param authCodeToOpenIdRequest 向wxpay post的请求数据
     * @param timeout 超时时间
     * @return API返回数据
     * @throws Exception 异常
     */
    Map<String, String> authCodeToOpenid(WxPayAuthCodeToOpenIdRequest authCodeToOpenIdRequest, int timeout) throws Exception;
}
