/*
 * Copyright 2014 The LolDevs team (https://github.com/loldevs)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.boreeas.riotapi.rest;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * Created on 4/14/2014.
 */
@Getter
@NoArgsConstructor
@AllArgsConstructor
public class Stats {
    private int assists;
    private int barracksKilled;
    private int championsKilled;
    private int combatPlayerScore;
    private int consumablesPurchased;
    private int damageDealtPlayer;
    private int doubleKills;
    private int firstBlood;
    private int gold;
    private int goldEarned;
    private int goldSpent;
    private int item0;
    private int item1;
    private int item2;
    private int item3;
    private int item4;
    private int item5;
    private int item6;
    private int itemsPurchased;
    private int killingSprees;
    private int largestCriticalStrike;
    private int largestKillingSpree;
    private int largestMultiKill;
    private int legendaryItemsCreated;
    private int level;
    private int magicDamageDealtPlayer;
    private int magicDamageDealtToChampions;
    private int magicDamageTaken;
    private int minionsDenied;
    private int minionsKilled;
    private int neutralMinionsKilled;
    private int neutralMinionsKilledEnemyJungle;
    private int neutralMinionsKilledYourJungle;
    private boolean nexusKilled;
    private int nodeCapture;
    private int nodeCaptureAssist;
    private int nodeNeutralize;
    private int nodeNeutralizeAssist;
    private int numDeaths;
    private int numItemsBought;
    private int objectivePlayerScore;
    private int pentaKills;
    private int physicalDamageDealtPlayer;
    private int physicalDamageDealtToChampions;
    private int physicalDamageTaken;
    private int quadraKills;
    private int sightWardsBought;
    private int spell1Cast;
    private int spell2Cast;
    private int spell3Cast;
    private int spell4Cast;
    private int summonSpell1Cast;
    private int summonSpell2Cast;
    private int superMonstersKilled;
    private int team;
    private int teamObjective;
    private int timePlayed;
    private int totalDamageDealt;
    private int totalDamageDealtToChampions;
    private int totalDamageTaken;
    private int totalHeal;
    private int totalPlayerScore;
    private int totalScoreRank;
    private int totalTimeCrowdControlDealt;
    private int totalUnitsHealed;
    private int tripleKills;
    private int trueDamageDealtPlayer;
    private int trueDamageDealtToChampions;
    private int trueDamageTaken;
    private int turretsKilled;
    private int unrealKills;
    private int victoryPointTotal;
    private int visionWardsBought;
    private int wardsKilled;
    private int wardsPlaced;
    private boolean win;
}
