/*
 * Decompiled with CFR 0.152.
 */
package net.boreeas.riotapi.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.boreeas.riotapi.RequestException;
import net.boreeas.riotapi.Shard;
import net.boreeas.riotapi.Util;
import net.boreeas.riotapi.Version;
import net.boreeas.riotapi.com.riotgames.leagues.pojo.LeagueItem;
import net.boreeas.riotapi.com.riotgames.leagues.pojo.LeagueList;
import net.boreeas.riotapi.com.riotgames.platform.game.QueueType;
import net.boreeas.riotapi.com.riotgames.platform.summoner.spellbook.RunePage;
import net.boreeas.riotapi.constants.Season;
import net.boreeas.riotapi.rest.BasicChampData;
import net.boreeas.riotapi.rest.ChampData;
import net.boreeas.riotapi.rest.Champion;
import net.boreeas.riotapi.rest.ChampionList;
import net.boreeas.riotapi.rest.CurrentGameInfo;
import net.boreeas.riotapi.rest.FeaturedGames;
import net.boreeas.riotapi.rest.Game;
import net.boreeas.riotapi.rest.Item;
import net.boreeas.riotapi.rest.ItemData;
import net.boreeas.riotapi.rest.ItemList;
import net.boreeas.riotapi.rest.LocalizedMessages;
import net.boreeas.riotapi.rest.MapDataOverview;
import net.boreeas.riotapi.rest.Mastery;
import net.boreeas.riotapi.rest.MasteryData;
import net.boreeas.riotapi.rest.MasteryList;
import net.boreeas.riotapi.rest.MasteryPage;
import net.boreeas.riotapi.rest.MatchDetail;
import net.boreeas.riotapi.rest.MatchSummary;
import net.boreeas.riotapi.rest.PlayerStats;
import net.boreeas.riotapi.rest.RankedStats;
import net.boreeas.riotapi.rest.RankedTeam;
import net.boreeas.riotapi.rest.Realm;
import net.boreeas.riotapi.rest.RuneList;
import net.boreeas.riotapi.rest.ShardData;
import net.boreeas.riotapi.rest.ShardStatus;
import net.boreeas.riotapi.rest.SpellData;
import net.boreeas.riotapi.rest.Summoner;
import net.boreeas.riotapi.rest.SummonerSpell;
import net.boreeas.riotapi.rest.SummonerSpellList;
import net.boreeas.riotapi.rest.api.CurrentGameHandler;
import net.boreeas.riotapi.rest.api.LoLRestApi;
import org.apache.log4j.Logger;

public class ApiHandler
implements LoLRestApi {
    private static final Logger log = Logger.getLogger(ApiHandler.class);
    private static final GsonBuilder builder = new GsonBuilder();
    private static final String API_GLOBAL_URL = "https://global.api.pvp.net/api/lol";
    private static final String SPECTATOR_API_URL = "https://%s.api.pvp.net/observer-mode/rest";
    private Gson gson = builder.create();
    private WebTarget championInfoTarget;
    private WebTarget gameInfoTarget;
    private WebTarget leagueInfoTarget;
    private WebTarget matchInfoTarget;
    private WebTarget matchHistoryInfoTarget;
    private WebTarget staticDataTarget;
    private WebTarget statusTarget;
    private WebTarget statsTarget;
    private WebTarget summonerInfoTarget;
    private WebTarget teamInfoTarget;
    public final CurrentGame currentGameHandler;
    public final FeaturedGamesHandler featuredGamesHandler;

    public ApiHandler(Shard shard, String token) {
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("Need token");
        }
        String region = shard.name;
        Client c = ClientBuilder.newClient();
        if (shard.isGarena) {
            log.warn((Object)"Garena doesn't support a public API. Only static-data is supported for this shard.");
            this.currentGameHandler = null;
            this.featuredGamesHandler = null;
        } else {
            WebTarget defaultTarget = c.target(shard.apiUrl).queryParam("api_key", new Object[]{token}).path(region);
            WebTarget spectatorTarget = c.target(String.format(SPECTATOR_API_URL, shard.name)).queryParam("api_key", new Object[]{token});
            this.championInfoTarget = defaultTarget.path("v1.2").path("champion");
            this.gameInfoTarget = defaultTarget.path("v1.3").path("game/by-summoner");
            this.leagueInfoTarget = defaultTarget.path("v2.5").path("league");
            this.matchInfoTarget = defaultTarget.path("v2.2").path("match");
            this.matchHistoryInfoTarget = defaultTarget.path("v2.2").path("matchhistory");
            this.statsTarget = defaultTarget.path("v1.3").path("stats/by-summoner");
            this.summonerInfoTarget = defaultTarget.path("v1.4").path("summoner");
            this.teamInfoTarget = defaultTarget.path("v2.4").path("team");
            this.currentGameHandler = new CurrentGame("v1.0", spectatorTarget.path("consumer"));
            this.featuredGamesHandler = new FeaturedGamesHandler("v1.0", spectatorTarget.path("featured"));
        }
        WebTarget defaultStaticTarget = c.target(API_GLOBAL_URL).queryParam("api_key", new Object[]{token}).path("static-data").path(region);
        this.statusTarget = c.target("http://status.leagueoflegends.com").path("shards");
        this.staticDataTarget = defaultStaticTarget.path("v1.2");
    }

    public List<BasicChampData> getBasicChampData() {
        return ((BasicChampDataListDto)this.gson.fromJson((Reader)this.$((WebTarget)this.championInfoTarget), BasicChampDataListDto.class)).champions;
    }

    public List<BasicChampData> getFreeToPlayChampions() {
        WebTarget tgt = this.championInfoTarget.queryParam("freeToPlay", new Object[]{true});
        return ((BasicChampDataListDto)this.gson.fromJson((Reader)this.$((WebTarget)tgt), BasicChampDataListDto.class)).champions;
    }

    public BasicChampData getBasicChampData(int id) {
        return (BasicChampData)this.gson.fromJson((Reader)this.$(this.championInfoTarget.path("" + id)), BasicChampData.class);
    }

    public List<Game> getRecentGames(long summoner) {
        WebTarget tgt = this.gameInfoTarget.path(summoner + "/recent");
        return ((RecentGamesDto)this.gson.fromJson((Reader)this.$((WebTarget)tgt), RecentGamesDto.class)).games;
    }

    public List<LeagueList> getLeagues(long summoner) {
        return this.getLeaguesVarArgs(summoner).get(summoner);
    }

    public Map<Long, List<LeagueList>> getLeagues(long ... summoners) {
        return this.getLeaguesVarArgs(summoners);
    }

    private Map<Long, List<LeagueList>> getLeaguesVarArgs(long ... summoners) {
        Type type = new TypeToken<Map<String, List<LeagueList>>>(){}.getType();
        WebTarget tgt = this.leagueInfoTarget.path("by-summoner/" + this.concat(summoners));
        Map query = (Map)this.gson.fromJson((Reader)this.$(tgt), type);
        HashMap<Long, List<LeagueList>> result = new HashMap<Long, List<LeagueList>>();
        query.forEach((k, v) -> result.put(Long.parseLong(k), (List<LeagueList>)v));
        return result;
    }

    public List<LeagueItem> getLeagueEntries(long summoner) {
        return this.getLeagueItemsVarArgs(summoner).get(summoner);
    }

    public Map<Long, List<LeagueItem>> getLeagueEntries(long ... summoners) {
        return this.getLeagueItemsVarArgs(summoners);
    }

    private Map<Long, List<LeagueItem>> getLeagueItemsVarArgs(long ... summoners) {
        Type type = new TypeToken<Map<Long, List<LeagueItem>>>(){}.getType();
        WebTarget tgt = this.leagueInfoTarget.path("by-summoner/" + this.concat(summoners)).path("entry");
        return (Map)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public List<LeagueList> getLeagues(String teamId) {
        return this.getTeamLeaguesVarargs(teamId).get(teamId);
    }

    public Map<String, List<LeagueList>> getLeagues(String ... teamIds) {
        return this.getTeamLeaguesVarargs(teamIds);
    }

    private Map<String, List<LeagueList>> getTeamLeaguesVarargs(String ... teamIds) {
        Type type = new TypeToken<Map<String, List<LeagueList>>>(){}.getType();
        WebTarget tgt = this.leagueInfoTarget.path("by-team").path(this.concat(teamIds));
        log.warn((Object)("Team - League - " + tgt.getUri()));
        return (Map)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public List<LeagueItem> getLeagueEntries(String teamId) {
        return this.getTeamLeagueItemsVarargs(teamId).get(teamId);
    }

    public Map<String, List<LeagueItem>> getLeagueEntries(String ... teamIds) {
        return this.getTeamLeagueItemsVarargs(teamIds);
    }

    private Map<String, List<LeagueItem>> getTeamLeagueItemsVarargs(String ... teamIds) {
        Type type = new TypeToken<Map<String, List<LeagueItem>>>(){}.getType();
        WebTarget tgt = this.leagueInfoTarget.path("by-team").path(this.concat(teamIds)).path("entry");
        return (Map)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public LeagueList getChallenger(QueueType queue) {
        WebTarget tgt = this.leagueInfoTarget.path("challenger").queryParam("type", new Object[]{queue.name()});
        return (LeagueList)this.gson.fromJson((Reader)this.$(tgt), LeagueList.class);
    }

    public ChampionList getChampionListDto() {
        WebTarget tgt = this.staticDataTarget.path("champion");
        return (ChampionList)this.gson.fromJson((Reader)this.$(tgt), ChampionList.class);
    }

    public ChampionList getChampionListDto(ChampData champData) {
        WebTarget tgt = this.staticDataTarget.path("champion").queryParam("champData", new Object[]{champData.name});
        return (ChampionList)this.gson.fromJson((Reader)this.$(tgt), ChampionList.class);
    }

    public ChampionList getChampionListDto(String locale, String version, boolean dataById, ChampData champData) {
        WebTarget tgt = this.staticDataTarget.path("champion").queryParam("locale", new Object[]{locale}).queryParam("version", new Object[]{version}).queryParam("dataById", new Object[]{dataById}).queryParam("champData", new Object[]{champData.name});
        return (ChampionList)this.gson.fromJson((Reader)this.$(tgt), ChampionList.class);
    }

    public Collection<Champion> getChampions() {
        return this.getChampionListDto().getChampions();
    }

    public Collection<Champion> getChampions(ChampData champData) {
        return this.getChampionListDto(champData).getChampions();
    }

    public Collection<Champion> getChampions(ChampData champData, String version, String locale, boolean dataById) {
        return this.getChampionListDto(locale, version, dataById, champData).getChampions();
    }

    public Champion getChampion(int id) {
        WebTarget tgt = this.staticDataTarget.path("champion/" + id);
        return (Champion)this.gson.fromJson((Reader)this.$(tgt), Champion.class);
    }

    public Champion getChampion(int id, ChampData champData) {
        WebTarget tgt = this.staticDataTarget.path("champion/" + id).queryParam("champData", new Object[]{champData.name});
        return (Champion)this.gson.fromJson((Reader)this.$(tgt), Champion.class);
    }

    public Champion getChampion(int id, ChampData champData, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("champion/" + id).queryParam("champData", new Object[]{champData.name}).queryParam("locale", new Object[]{locale}).queryParam("version", new Object[]{version});
        return (Champion)this.gson.fromJson((Reader)this.$(tgt), Champion.class);
    }

    public ItemList getItemList() {
        WebTarget tgt = this.staticDataTarget.path("item");
        return (ItemList)this.gson.fromJson((Reader)this.$(tgt), ItemList.class);
    }

    public ItemList getItemList(ItemData data) {
        WebTarget tgt = this.staticDataTarget.path("item").queryParam("itemListData", new Object[]{data.name});
        return (ItemList)this.gson.fromJson((Reader)this.$(tgt), ItemList.class);
    }

    public ItemList getItemList(ItemData data, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("item").queryParam("itemListData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (ItemList)this.gson.fromJson((Reader)this.$(tgt), ItemList.class);
    }

    public Item getItem(int id) {
        WebTarget tgt = this.staticDataTarget.path("item/" + id);
        return (Item)this.gson.fromJson((Reader)this.$(tgt), Item.class);
    }

    public Item getItem(int id, ItemData data) {
        WebTarget tgt = this.staticDataTarget.path("item/" + id).queryParam("itemData", new Object[]{data.name});
        return (Item)this.gson.fromJson((Reader)this.$(tgt), Item.class);
    }

    public Item getItem(int id, ItemData data, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("item/" + id).queryParam("itemData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (Item)this.gson.fromJson((Reader)this.$(tgt), Item.class);
    }

    public MasteryList getMasteries() {
        WebTarget tgt = this.staticDataTarget.path("mastery");
        return (MasteryList)this.gson.fromJson((Reader)this.$(tgt), MasteryList.class);
    }

    public MasteryList getMasteries(MasteryData data) {
        WebTarget tgt = this.staticDataTarget.path("mastery").queryParam("masteryListData", new Object[]{data.name});
        return (MasteryList)this.gson.fromJson((Reader)this.$(tgt), MasteryList.class);
    }

    public MasteryList getMasteries(MasteryData data, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("mastery").queryParam("masterListData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (MasteryList)this.gson.fromJson((Reader)this.$(tgt), MasteryList.class);
    }

    public Mastery getMastery(int id) {
        WebTarget tgt = this.staticDataTarget.path("mastery/" + id);
        return (Mastery)this.gson.fromJson((Reader)this.$(tgt), Mastery.class);
    }

    public Mastery getMastery(int id, MasteryData data) {
        WebTarget tgt = this.staticDataTarget.path("mastery/" + id).queryParam("masteryData", new Object[]{data.name});
        return (Mastery)this.gson.fromJson((Reader)this.$(tgt), Mastery.class);
    }

    public Mastery getMastery(int id, MasteryData data, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("mastery/" + id).queryParam("masterListData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (Mastery)this.gson.fromJson((Reader)this.$(tgt), Mastery.class);
    }

    public Realm getRealm() {
        WebTarget tgt = this.staticDataTarget.path("realm");
        return (Realm)this.gson.fromJson((Reader)this.$(tgt), Realm.class);
    }

    public RuneList getRuneList() {
        WebTarget tgt = this.staticDataTarget.path("runes");
        return (RuneList)this.gson.fromJson((Reader)this.$(tgt), RuneList.class);
    }

    public RuneList getRuneList(ItemData data) {
        WebTarget tgt = this.staticDataTarget.path("rune").queryParam("runeListData", new Object[]{data.name});
        return (RuneList)this.gson.fromJson((Reader)this.$(tgt), RuneList.class);
    }

    public RuneList getRuneList(ItemData data, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("rune").queryParam("runeListData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (RuneList)this.gson.fromJson((Reader)this.$(tgt), RuneList.class);
    }

    public Item getRune(int id) {
        WebTarget tgt = this.staticDataTarget.path("runes/" + id);
        return (Item)this.gson.fromJson((Reader)this.$(tgt), Item.class);
    }

    public Item getRune(int id, ItemData data) {
        WebTarget tgt = this.staticDataTarget.path("rune/" + id).queryParam("runeData", new Object[]{data.name});
        return (Item)this.gson.fromJson((Reader)this.$(tgt), Item.class);
    }

    public Item getRune(int id, ItemData data, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("rune/" + id).queryParam("runeData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (Item)this.gson.fromJson((Reader)this.$(tgt), Item.class);
    }

    public SummonerSpellList getSummonerSpellListDto() {
        WebTarget tgt = this.staticDataTarget.path("summoner-spell");
        return (SummonerSpellList)this.gson.fromJson((Reader)this.$(tgt), SummonerSpellList.class);
    }

    public SummonerSpellList getSummonerSpellListDto(SpellData data) {
        WebTarget tgt = this.staticDataTarget.path("summoner-spell").queryParam("spellData", new Object[]{data.name});
        return (SummonerSpellList)this.gson.fromJson((Reader)this.$(tgt), SummonerSpellList.class);
    }

    public SummonerSpellList getSummonerSpellListDro(SpellData data, String version, String locale, boolean dataById) {
        WebTarget tgt = this.staticDataTarget.path("summoner-spell").queryParam("spellData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale}).queryParam("dataById", new Object[]{dataById});
        return (SummonerSpellList)this.gson.fromJson((Reader)this.$(tgt), SummonerSpellList.class);
    }

    public Collection<SummonerSpell> getSummonerSpells() {
        return this.getSummonerSpellListDto().getSpells();
    }

    public Collection<SummonerSpell> getSummonerSpells(SpellData data) {
        return this.getSummonerSpellListDto(data).getSpells();
    }

    public Collection<SummonerSpell> getSummonerSpells(SpellData data, String version, String locale, boolean dataById) {
        return this.getSummonerSpellListDro(data, version, locale, dataById).getSpells();
    }

    public SummonerSpell getSummonerSpell(int id) {
        WebTarget tgt = this.staticDataTarget.path("summoner-spell/" + id);
        return (SummonerSpell)this.gson.fromJson((Reader)this.$(tgt), SummonerSpell.class);
    }

    public SummonerSpell getSummonerSpell(int id, SpellData data) {
        WebTarget tgt = this.staticDataTarget.path("summoner-spell/" + id).queryParam("spellData", new Object[]{data.name});
        return (SummonerSpell)this.gson.fromJson((Reader)this.$(tgt), SummonerSpell.class);
    }

    public SummonerSpell getSummonerSpell(int id, SpellData data, String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("summoner-spell/" + id).queryParam("spellData", new Object[]{data.name}).queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (SummonerSpell)this.gson.fromJson((Reader)this.$(tgt), SummonerSpell.class);
    }

    public List<String> getVersions() {
        Type type = new TypeToken<List<String>>(){}.getType();
        WebTarget tgt = this.staticDataTarget.path("versions");
        return (List)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public MapDataOverview getMaps() {
        WebTarget tgt = this.staticDataTarget.path("map");
        return (MapDataOverview)this.gson.fromJson((Reader)this.$(tgt), MapDataOverview.class);
    }

    public MapDataOverview getMaps(String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("map").queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (MapDataOverview)this.gson.fromJson((Reader)this.$(tgt), MapDataOverview.class);
    }

    public List<String> getLocales() {
        Type type = new TypeToken<List<String>>(){}.getType();
        WebTarget tgt = this.staticDataTarget.path("languages");
        return (List)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public LocalizedMessages getLocalizedMessages() {
        WebTarget tgt = this.staticDataTarget.path("language-strings");
        return (LocalizedMessages)this.gson.fromJson((Reader)this.$(tgt), LocalizedMessages.class);
    }

    public LocalizedMessages getLocalizedMessages(String version, String locale) {
        WebTarget tgt = this.staticDataTarget.path("language-strings").queryParam("version", new Object[]{version}).queryParam("locale", new Object[]{locale});
        return (LocalizedMessages)this.gson.fromJson((Reader)this.$(tgt), LocalizedMessages.class);
    }

    public List<ShardData> getShards() {
        Type type = new TypeToken<ArrayList<ShardData>>(){}.getType();
        return (List)this.gson.fromJson((Reader)this.$(this.statusTarget), type);
    }

    public ShardStatus getShardStatus(Shard shard) {
        WebTarget tgt = this.statusTarget.path(shard.slug);
        return (ShardStatus)this.gson.fromJson((Reader)this.$(tgt), ShardStatus.class);
    }

    public MatchDetail getMatch(long matchId) {
        return this.getMatch(matchId, true);
    }

    public MatchDetail getMatch(long matchId, boolean includeTimeline) {
        WebTarget tgt = this.matchInfoTarget.path("" + matchId).queryParam("includeTimeline", new Object[]{includeTimeline});
        return (MatchDetail)this.gson.fromJson((Reader)this.$(tgt), MatchDetail.class);
    }

    public List<MatchSummary> getMatchHistory(long playerId) {
        WebTarget tgt = this.matchHistoryInfoTarget.path("" + playerId);
        return ((PlayerHistory)this.gson.fromJson((Reader)this.$(tgt), PlayerHistory.class)).matches;
    }

    public List<MatchSummary> getMatchHistory(long playerId, String ... championIds) {
        WebTarget tgt = this.matchHistoryInfoTarget.path("" + playerId).queryParam("championIds", new Object[]{this.concat(championIds)});
        return ((PlayerHistory)this.gson.fromJson((Reader)this.$(tgt), PlayerHistory.class)).matches;
    }

    public List<MatchSummary> getMatchHistory(long playerId, String[] championIds, QueueType ... queueTypes) {
        String rankedQueues = this.concatRankedQueues(queueTypes);
        WebTarget tgt = this.matchHistoryInfoTarget.path("" + playerId).queryParam("championIds", new Object[]{this.concat(championIds)}).queryParam("rankedQueues", new Object[]{rankedQueues});
        return ((PlayerHistory)this.gson.fromJson((Reader)this.$(tgt), PlayerHistory.class)).matches;
    }

    public List<MatchSummary> getMatchHistory(long playerId, String[] championIds, QueueType[] queueTypes, int beginIndex, int endIndex) {
        String rankedQueues = this.concatRankedQueues(queueTypes);
        WebTarget tgt = this.matchHistoryInfoTarget.path("" + playerId).queryParam("championIds", new Object[]{this.concat(championIds)}).queryParam("rankedQueues", new Object[]{rankedQueues}).queryParam("beginIndex", new Object[]{beginIndex}).queryParam("endIndex", new Object[]{endIndex});
        return ((PlayerHistory)this.gson.fromJson((Reader)this.$(tgt), PlayerHistory.class)).matches;
    }

    private String concatRankedQueues(QueueType[] types) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (QueueType type : types) {
            if (type != QueueType.RANKED_SOLO_5x5 && type != QueueType.RANKED_TEAM_3x3 && type != QueueType.RANKED_TEAM_5x5) {
                throw new IllegalArgumentException("Queue type must be one of RANKED_SOLO_5x5, RANKED_TEAM_3x3 or RANKED_TEAM_5x5, but was " + type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(type.name());
        }
        return builder.toString();
    }

    public RankedStats getRankedStats(long summoner) {
        WebTarget tgt = this.statsTarget.path(summoner + "/ranked");
        return (RankedStats)this.gson.fromJson((Reader)this.$(tgt), RankedStats.class);
    }

    public RankedStats getRankedStats(long summoner, Season season) {
        WebTarget tgt = this.statsTarget.path(summoner + "/ranked").queryParam("season", new Object[]{season});
        return (RankedStats)this.gson.fromJson((Reader)this.$(tgt), RankedStats.class);
    }

    public List<PlayerStats> getStatsSummary(long summoner) {
        WebTarget tgt = this.statsTarget.path(summoner + "/summary");
        return ((PlayerStatsSummaryListDto)this.gson.fromJson((Reader)this.$((WebTarget)tgt), PlayerStatsSummaryListDto.class)).playerStatSummaries;
    }

    public List<PlayerStats> getStatsSummary(long summoner, Season season) {
        WebTarget tgt = this.statsTarget.path(summoner + "/summary").queryParam("season", new Object[]{season});
        return ((PlayerStatsSummaryListDto)this.gson.fromJson((Reader)this.$((WebTarget)tgt), PlayerStatsSummaryListDto.class)).playerStatSummaries;
    }

    public Map<String, Summoner> getSummoners(String ... names) {
        Type type = new TypeToken<Map<String, Summoner>>(){}.getType();
        WebTarget tgt = this.summonerInfoTarget.path("by-name").path(String.join((CharSequence)",", names));
        return (Map)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public Summoner getSummoner(String name) {
        return this.getSummoners(name).get(Util.standardizeSummonerName((String)name));
    }

    public Map<Integer, Summoner> getSummoners(Integer ... ids) {
        Type type = new TypeToken<Map<String, Summoner>>(){}.getType();
        WebTarget tgt = this.summonerInfoTarget.path(Arrays.asList(ids).toString().replaceAll("[\\[\\] ]", ""));
        Map result = (Map)this.gson.fromJson((Reader)this.$(tgt), type);
        HashMap<Integer, Summoner> asIntMap = new HashMap<Integer, Summoner>();
        result.forEach((id, summoner) -> asIntMap.put(Integer.parseInt(id), (Summoner)summoner));
        return asIntMap;
    }

    public Summoner getSummoner(int id) {
        return this.getSummoners(id).get(id);
    }

    public Map<Integer, Set<MasteryPage>> getMasteryPagesMultipleUsers(Integer ... ids) {
        Type type = new TypeToken<Map<String, MasteryPagesDto>>(){}.getType();
        String idString = Arrays.asList(ids).toString().replaceAll("[\\[\\] ]", "");
        WebTarget tgt = this.summonerInfoTarget.path(idString).path("masteries");
        Map tmpResult = (Map)this.gson.fromJson((Reader)this.$(tgt), type);
        HashMap<Integer, Set<MasteryPage>> result = new HashMap<Integer, Set<MasteryPage>>();
        tmpResult.forEach((id, masteryPagesDto) -> result.put(Integer.parseInt(id), masteryPagesDto.pages));
        return result;
    }

    public Set<MasteryPage> getMasteryPages(int id) {
        return this.getMasteryPagesMultipleUsers(id).get(id);
    }

    public Map<Integer, String> getSummonerNames(Integer ... ids) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        String idString = Arrays.asList(ids).toString().replaceAll("[\\[\\] ]", "");
        WebTarget tgt = this.summonerInfoTarget.path(idString).path("name");
        Map tmpResult = (Map)this.gson.fromJson((Reader)this.$(tgt), type);
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        tmpResult.forEach((id, name) -> result.put(Integer.parseInt(id), (String)name));
        return result;
    }

    public String getSummonerName(int id) {
        return this.getSummonerNames(id).get(id);
    }

    public Map<Integer, Set<RunePage>> getRunePagesMultipleUsers(int ... ids) {
        Type type = new TypeToken<Map<String, RunePagesDto>>(){}.getType();
        WebTarget tgt = this.summonerInfoTarget.path(this.concat(ids)).path("runes");
        Map tmpResult = (Map)this.gson.fromJson((Reader)this.$(tgt), type);
        HashMap<Integer, Set<RunePage>> result = new HashMap<Integer, Set<RunePage>>();
        tmpResult.forEach((id, runePagesDto) -> result.put(Integer.parseInt(id), runePagesDto.pages));
        return result;
    }

    public Set<RunePage> getRunePages(int id) {
        return this.getRunePagesMultipleUsers(id).get(id);
    }

    public List<RankedTeam> getTeamsBySummoner(long id) {
        return this.getTeamsBySummoners(id).get(id);
    }

    public Map<Long, List<RankedTeam>> getTeamsBySummoners(long ... ids) {
        Type type = new TypeToken<Map<Long, List<RankedTeam>>>(){}.getType();
        WebTarget tgt = this.teamInfoTarget.path("by-summoner/" + this.concat(ids));
        return (Map)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public RankedTeam getTeam(String teamId) {
        return this.getTeams(teamId).get(teamId);
    }

    public Map<String, RankedTeam> getTeams(String ... teamIds) {
        Type type = new TypeToken<Map<String, RankedTeam>>(){}.getType();
        WebTarget tgt = this.teamInfoTarget.path(String.join((CharSequence)",", teamIds));
        return (Map)this.gson.fromJson((Reader)this.$(tgt), type);
    }

    public List<Long> getSummonerIds(String ... names) {
        return this.getSummoners(names).values().stream().map(Summoner::getId).collect(Collectors.toList());
    }

    public long getSummonerId(String name) {
        return this.getSummoner(name).getId();
    }

    private InputStreamReader $(WebTarget target) {
        Response response = target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).acceptEncoding(new String[]{"gzip"}).get();
        if (response.getStatus() != 200) {
            throw new RequestException(response.getStatus(), RequestException.ErrorType.getByCode((int)response.getStatus()));
        }
        String encoding = response.getHeaderString("Content-Encoding");
        if (encoding != null && encoding.equals("gzip")) {
            return new InputStreamReader(new GZIPInputStream((InputStream)response.getEntity()));
        }
        return new InputStreamReader((InputStream)response.getEntity());
    }

    private String concat(long ... values) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (long v : values) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(v);
        }
        return builder.toString();
    }

    private String concat(int ... values) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (int v : values) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(v);
        }
        return builder.toString();
    }

    private String concat(String ... values) {
        return String.join((CharSequence)",", values);
    }

    @Override
    public CurrentGame getCurrentGameHandler() {
        return this.currentGameHandler;
    }

    @Override
    public FeaturedGamesHandler getFeaturedGamesHandler() {
        return this.featuredGamesHandler;
    }

    static {
        builder.registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong()));
    }

    private class PlayerHistory {
        private List<MatchSummary> matches;

        private PlayerHistory() {
        }
    }

    private class RunePagesDto {
        Set<RunePage> pages;
        long summonerId;

        private RunePagesDto() {
        }
    }

    private class MasteryPagesDto {
        Set<MasteryPage> pages;
        long summonerId;

        private MasteryPagesDto() {
        }
    }

    private class PlayerStatsSummaryListDto {
        List<PlayerStats> playerStatSummaries;
        long summonerId;

        private PlayerStatsSummaryListDto() {
        }
    }

    private class RecentGamesDto {
        List<Game> games;
        long summonerId;

        private RecentGamesDto() {
        }
    }

    private class BasicChampDataListDto {
        List<BasicChampData> champions;

        private BasicChampDataListDto() {
        }
    }

    public class FeaturedGamesHandler
    implements net.boreeas.riotapi.rest.api.FeaturedGamesHandler {
        private String version;
        private WebTarget tgt;

        public FeaturedGamesHandler(String version, WebTarget featured) {
            this.version = version;
            this.tgt = featured;
        }

        @Override
        public FeaturedGames getFeaturedGames() {
            return (FeaturedGames)ApiHandler.this.gson.fromJson((Reader)ApiHandler.this.$(this.tgt), FeaturedGames.class);
        }

        @Override
        public Version getVersion() {
            return new Version(this.version);
        }
    }

    public class CurrentGame
    implements CurrentGameHandler {
        public final String version;
        private WebTarget target;

        public CurrentGame(String version, WebTarget target) {
            this.version = version;
            this.target = target;
        }

        @Override
        public CurrentGameInfo getCurrentGameInfo(long summoner) {
            WebTarget tgt = this.target.path("getSpectatorGameInfo");
            return (CurrentGameInfo)ApiHandler.this.gson.fromJson((Reader)ApiHandler.this.$(tgt), CurrentGameInfo.class);
        }

        @Override
        public Version getVersion() {
            return new Version(this.version);
        }
    }
}

