/*
 * Decompiled with CFR 0.152.
 */
package net.boreeas.riotapi.rest;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.boreeas.riotapi.Shard;
import net.boreeas.riotapi.Version;
import net.boreeas.riotapi.com.riotgames.leagues.pojo.LeagueItem;
import net.boreeas.riotapi.com.riotgames.leagues.pojo.LeagueList;
import net.boreeas.riotapi.com.riotgames.platform.game.QueueType;
import net.boreeas.riotapi.com.riotgames.platform.summoner.spellbook.RunePage;
import net.boreeas.riotapi.constants.Season;
import net.boreeas.riotapi.rest.ApiHandler;
import net.boreeas.riotapi.rest.BasicChampData;
import net.boreeas.riotapi.rest.ChampData;
import net.boreeas.riotapi.rest.Champion;
import net.boreeas.riotapi.rest.ChampionList;
import net.boreeas.riotapi.rest.CurrentGameInfo;
import net.boreeas.riotapi.rest.FeaturedGames;
import net.boreeas.riotapi.rest.Game;
import net.boreeas.riotapi.rest.Item;
import net.boreeas.riotapi.rest.ItemData;
import net.boreeas.riotapi.rest.ItemList;
import net.boreeas.riotapi.rest.LocalizedMessages;
import net.boreeas.riotapi.rest.MapDataOverview;
import net.boreeas.riotapi.rest.Mastery;
import net.boreeas.riotapi.rest.MasteryData;
import net.boreeas.riotapi.rest.MasteryList;
import net.boreeas.riotapi.rest.MasteryPage;
import net.boreeas.riotapi.rest.MatchDetail;
import net.boreeas.riotapi.rest.MatchSummary;
import net.boreeas.riotapi.rest.PlayerStats;
import net.boreeas.riotapi.rest.RankedStats;
import net.boreeas.riotapi.rest.RankedTeam;
import net.boreeas.riotapi.rest.Realm;
import net.boreeas.riotapi.rest.RuneList;
import net.boreeas.riotapi.rest.ShardData;
import net.boreeas.riotapi.rest.ShardStatus;
import net.boreeas.riotapi.rest.SpellData;
import net.boreeas.riotapi.rest.Summoner;
import net.boreeas.riotapi.rest.SummonerSpell;
import net.boreeas.riotapi.rest.SummonerSpellList;
import net.boreeas.riotapi.rest.api.CurrentGameHandler;
import net.boreeas.riotapi.rest.api.FeaturedGamesHandler;
import net.boreeas.riotapi.rest.api.LoLRestApi;

public class ThrottledApiHandler
implements AutoCloseable,
LoLRestApi {
    public static final int PERIOD = 50;
    private float[] limits;
    private Queue<ApiFuture> pending = new LinkedList<ApiFuture>();
    private Timer timer = new Timer(true);
    private ApiHandler handler;
    public final AsyncCurrentGameHandler currentGameHandler = new AsyncCurrentGameHandler();
    public final AsyncFeaturedGamesHandler featuredGamesHandler = new AsyncFeaturedGamesHandler();

    public ThrottledApiHandler(Shard shard, String token, final Limit ... lim) {
        this.handler = new ApiHandler(shard, token);
        this.limits = new float[lim.length];
        int i = 0;
        while (i < lim.length) {
            final int ii = i++;
            float ticksToMax = (float)lim[ii].unit.toMillis(lim[ii].timeDeltaToMax) / 50.0f;
            final float delta = (float)lim[ii].maxValue / ticksToMax;
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    float[] fArray = ThrottledApiHandler.this.limits;
                    int n = ii;
                    fArray[n] = fArray[n] + delta;
                    if (ThrottledApiHandler.this.limits[ii] > (float)lim[ii].maxValue) {
                        ((ThrottledApiHandler)ThrottledApiHandler.this).limits[ii] = lim[ii].maxValue;
                    }
                }
            }, 0L, 50L);
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                while (ThrottledApiHandler.this.limitsOpen() && !ThrottledApiHandler.this.pending.isEmpty()) {
                    ApiFuture future = (ApiFuture)ThrottledApiHandler.this.pending.poll();
                    ThrottledApiHandler.this.executeFutureRequest(future);
                    int i = 0;
                    while (i < ThrottledApiHandler.this.limits.length) {
                        float[] fArray = ThrottledApiHandler.this.limits;
                        int n = i++;
                        fArray[n] = fArray[n] - 1.0f;
                    }
                }
            }
        }, 0L, 50L);
    }

    private void executeFutureRequest(ApiFuture future) {
        Thread thread = new Thread(() -> {
            try {
                future.setValue(future.getRequest().call());
            }
            catch (Exception e) {
                future.setErr(e);
            }
            future.getSignal().countDown();
        });
        thread.setDaemon(true);
        thread.start();
    }

    private boolean limitsOpen() {
        for (float f : this.limits) {
            if (!(f < 1.0f)) continue;
            return false;
        }
        return true;
    }

    private synchronized void scheduleNext(ApiFuture t) {
        if (this.limitsOpen()) {
            this.executeFutureRequest(t);
            int i = 0;
            while (i < this.limits.length) {
                int n = i++;
                this.limits[n] = this.limits[n] - 1.0f;
            }
        } else {
            this.pending.add(t);
        }
    }

    public Future<List<BasicChampData>> getBasicChampData() {
        return new ApiFuture<List<BasicChampData>>(() -> this.handler.getBasicChampData());
    }

    public Future<BasicChampData> getBasicChampData(int id) {
        return new ApiFuture<BasicChampData>(() -> this.handler.getBasicChampData(id));
    }

    public Future<List<BasicChampData>> getFreeToPlayChampions() {
        return new ApiFuture<List<BasicChampData>>(() -> this.handler.getFreeToPlayChampions());
    }

    public Future<List<Game>> getRecentGames(long summoner) {
        return new ApiFuture<List<Game>>(() -> this.handler.getRecentGames(summoner));
    }

    public Future<List<LeagueList>> getLeagues(long summoner) {
        return new ApiFuture<List<LeagueList>>(() -> this.handler.getLeagues(summoner));
    }

    public Future<Map<Long, List<LeagueList>>> getLeagues(long ... summoners) {
        return new ApiFuture<Map<Long, List<LeagueList>>>(() -> this.handler.getLeagues(summoners));
    }

    public Future<List<LeagueItem>> getLeagueEntries(long summoner) {
        return new ApiFuture<List<LeagueItem>>(() -> this.handler.getLeagueEntries(summoner));
    }

    public Future<Map<Long, List<LeagueItem>>> getLeagueEntries(long ... summoners) {
        return new ApiFuture<Map<Long, List<LeagueItem>>>(() -> this.handler.getLeagueEntries(summoners));
    }

    public Future<List<LeagueList>> getLeagues(String teamId) {
        return new ApiFuture<List<LeagueList>>(() -> this.handler.getLeagues(teamId));
    }

    public Future<Map<String, List<LeagueList>>> getLeagues(String ... teamIds) {
        return new ApiFuture<Map<String, List<LeagueList>>>(() -> this.handler.getLeagues(teamIds));
    }

    public Future<List<LeagueItem>> getLeagueEntries(String teamId) {
        return new ApiFuture<List<LeagueItem>>(() -> this.handler.getLeagueEntries(teamId));
    }

    public Future<Map<String, List<LeagueItem>>> getLeagueEntries(String ... teamIds) {
        return new ApiFuture<Map<String, List<LeagueItem>>>(() -> this.handler.getLeagueEntries(teamIds));
    }

    public Future<LeagueList> getChallenger(QueueType queue) {
        return new ApiFuture<LeagueList>(() -> this.handler.getChallenger(queue));
    }

    public Future<ChampionList> getChampionListDto() {
        return new DummyFuture<ChampionList>(this.handler.getChampionListDto());
    }

    public Future<ChampionList> getChampionListDto(ChampData champData) {
        return new DummyFuture<ChampionList>(this.handler.getChampionListDto(champData));
    }

    public Future<ChampionList> getChampionListDto(String locale, String version, boolean dataById, ChampData champData) {
        return new DummyFuture<ChampionList>(this.handler.getChampionListDto(locale, version, dataById, champData));
    }

    public Future<Collection<Champion>> getChampions() {
        return new DummyFuture<Collection<Champion>>(this.handler.getChampions());
    }

    public Future<Collection<Champion>> getChampions(ChampData champData) {
        return new DummyFuture<Collection<Champion>>(this.handler.getChampions(champData));
    }

    public Future<Collection<Champion>> getChampions(ChampData champData, String version, String locale, boolean dataById) {
        return new DummyFuture<Collection<Champion>>(this.handler.getChampions(champData, version, locale, dataById));
    }

    public Future<Champion> getChampion(int id) {
        return new DummyFuture<Champion>(this.handler.getChampion(id));
    }

    public Future<Champion> getChampion(int id, ChampData champData) {
        return new DummyFuture<Champion>(this.handler.getChampion(id, champData));
    }

    public Future<Champion> getChampion(int id, ChampData champData, String version, String locale) {
        return new DummyFuture<Champion>(this.handler.getChampion(id, champData, version, locale));
    }

    public Future<ItemList> getItemList() {
        return new DummyFuture<ItemList>(this.handler.getItemList());
    }

    public Future<ItemList> getItemList(ItemData data) {
        return new DummyFuture<ItemList>(this.handler.getItemList(data));
    }

    public Future<ItemList> getItemList(ItemData data, String version, String locale) {
        return new DummyFuture<ItemList>(this.handler.getItemList(data, version, locale));
    }

    public Future<Item> getItem(int id) {
        return new DummyFuture<Item>(this.handler.getItem(id));
    }

    public Future<Item> getItem(int id, ItemData data) {
        return new DummyFuture<Item>(this.handler.getItem(id, data));
    }

    public Future<Item> getItem(int id, ItemData data, String version, String locale) {
        return new DummyFuture<Item>(this.handler.getItem(id, data, version, locale));
    }

    public Future<MasteryList> getMasteries() {
        return new DummyFuture<MasteryList>(this.handler.getMasteries());
    }

    public Future<MasteryList> getMasteries(MasteryData data) {
        return new DummyFuture<MasteryList>(this.handler.getMasteries(data));
    }

    public Future<MasteryList> getMasteries(MasteryData data, String version, String locale) {
        return new DummyFuture<MasteryList>(this.handler.getMasteries(data, version, locale));
    }

    public Future<Mastery> getMastery(int id) {
        return new DummyFuture<Mastery>(this.handler.getMastery(id));
    }

    public Future<Mastery> getMastery(int id, MasteryData data) {
        return new DummyFuture<Mastery>(this.handler.getMastery(id, data));
    }

    public Future<Mastery> getMastery(int id, MasteryData data, String version, String locale) {
        return new DummyFuture<Mastery>(this.handler.getMastery(id, data, version, locale));
    }

    public Future<Realm> getRealm() {
        return new DummyFuture<Realm>(this.handler.getRealm());
    }

    public Future<RuneList> getRuneList() {
        return new DummyFuture<RuneList>(this.handler.getRuneList());
    }

    public Future<RuneList> getRuneList(ItemData data) {
        return new DummyFuture<RuneList>(this.handler.getRuneList(data));
    }

    public Future<RuneList> getRuneList(ItemData data, String version, String locale) {
        return new DummyFuture<RuneList>(this.handler.getRuneList(data, version, locale));
    }

    public Future<Item> getRune(int id) {
        return new DummyFuture<Item>(this.handler.getRune(id));
    }

    public Future<Item> getRune(int id, ItemData data) {
        return new DummyFuture<Item>(this.handler.getRune(id, data));
    }

    public Future<Item> getRune(int id, ItemData data, String version, String locale) {
        return new DummyFuture<Item>(this.handler.getRune(id, data, version, locale));
    }

    public Future<SummonerSpellList> getSummonerSpellListDto() {
        return new DummyFuture<SummonerSpellList>(this.handler.getSummonerSpellListDto());
    }

    public Future<SummonerSpellList> getSummonerSpellListDto(SpellData data) {
        return new DummyFuture<SummonerSpellList>(this.handler.getSummonerSpellListDto(data));
    }

    public Future<SummonerSpellList> getSummonerSpellListDro(SpellData data, String version, String locale, boolean dataById) {
        return new DummyFuture<SummonerSpellList>(this.handler.getSummonerSpellListDro(data, version, locale, dataById));
    }

    public Future<Collection<SummonerSpell>> getSummonerSpells() {
        return new DummyFuture<Collection<SummonerSpell>>(this.handler.getSummonerSpells());
    }

    public Future<Collection<SummonerSpell>> getSummonerSpells(SpellData data) {
        return new DummyFuture<Collection<SummonerSpell>>(this.handler.getSummonerSpells(data));
    }

    public Future<Collection<SummonerSpell>> getSummonerSpells(SpellData data, String version, String locale, boolean dataById) {
        return new DummyFuture<Collection<SummonerSpell>>(this.handler.getSummonerSpells(data, version, locale, dataById));
    }

    public Future<SummonerSpell> getSummonerSpell(int id) {
        return new DummyFuture<SummonerSpell>(this.handler.getSummonerSpell(id));
    }

    public Future<SummonerSpell> getSummonerSpell(int id, SpellData data) {
        return new DummyFuture<SummonerSpell>(this.handler.getSummonerSpell(id, data));
    }

    public Future<SummonerSpell> getSummonerSpell(int id, SpellData data, String version, String locale) {
        return new DummyFuture<SummonerSpell>(this.handler.getSummonerSpell(id, data, version, locale));
    }

    public Future<List<String>> getVersions() {
        return new DummyFuture<List<String>>(this.handler.getVersions());
    }

    public Future<MapDataOverview> getMaps() {
        return new DummyFuture<MapDataOverview>(this.handler.getMaps());
    }

    public Future<MapDataOverview> getMaps(String version, String locale) {
        return new DummyFuture<MapDataOverview>(this.handler.getMaps(version, locale));
    }

    public Future<List<String>> getLocales() {
        return new DummyFuture<List<String>>(this.handler.getLocales());
    }

    public Future<LocalizedMessages> getLocalizedMessages() {
        return new DummyFuture<LocalizedMessages>(this.handler.getLocalizedMessages());
    }

    public Future<LocalizedMessages> getLocalizedMessages(String version, String locale) {
        return new DummyFuture<LocalizedMessages>(this.handler.getLocalizedMessages(version, locale));
    }

    public Future<List<ShardData>> getShards() {
        return new DummyFuture<List<ShardData>>(this.handler.getShards());
    }

    @Deprecated
    public Future<ShardStatus> getShardSatatus(Shard shard) {
        return new DummyFuture<ShardStatus>(this.handler.getShardStatus(shard));
    }

    public Future<ShardStatus> getShardStatus(Shard shard) {
        return new DummyFuture<ShardStatus>(this.handler.getShardStatus(shard));
    }

    public Future<MatchDetail> getMatch(long matchId) {
        return new ApiFuture<MatchDetail>(() -> this.handler.getMatch(matchId));
    }

    public Future<MatchDetail> getMatch(long matchId, boolean includeTimeline) {
        return new ApiFuture<MatchDetail>(() -> this.handler.getMatch(matchId, includeTimeline));
    }

    public Future<List<MatchSummary>> getMatchHistory(long playerId) {
        return new ApiFuture<List<MatchSummary>>(() -> this.handler.getMatchHistory(playerId));
    }

    public Future<List<MatchSummary>> getMatchHistory(long playerId, String ... championIds) {
        return new ApiFuture<List<MatchSummary>>(() -> this.handler.getMatchHistory(playerId, championIds));
    }

    public Future<List<MatchSummary>> getMatchHistory(long playerId, String[] championIds, QueueType ... queueTypes) {
        return new ApiFuture<List<MatchSummary>>(() -> this.handler.getMatchHistory(playerId, championIds, queueTypes));
    }

    public Future<List<MatchSummary>> getMatchHistory(long playerId, String[] championIds, QueueType[] queueTypes, int beginIndex, int endIndex) {
        return new ApiFuture<List<MatchSummary>>(() -> this.handler.getMatchHistory(playerId, championIds, queueTypes, beginIndex, endIndex));
    }

    public Future<RankedStats> getRankedStats(long summoner) {
        return new ApiFuture<RankedStats>(() -> this.handler.getRankedStats(summoner));
    }

    public Future<RankedStats> getRankedStats(long summoner, Season season) {
        return new ApiFuture<RankedStats>(() -> this.handler.getRankedStats(summoner, season));
    }

    public Future<List<PlayerStats>> getStatsSummary(long summoner) {
        return new ApiFuture<List<PlayerStats>>(() -> this.handler.getStatsSummary(summoner));
    }

    public Future<List<PlayerStats>> getStatsSummary(long summoner, Season season) {
        return new ApiFuture<List<PlayerStats>>(() -> this.handler.getStatsSummary(summoner, season));
    }

    public Future<Map<String, Summoner>> getSummoners(String ... names) {
        return new ApiFuture<Map<String, Summoner>>(() -> this.handler.getSummoners(names));
    }

    public Future<Summoner> getSummoner(String name) {
        return new ApiFuture<Summoner>(() -> this.handler.getSummoner(name));
    }

    public Future<Map<Integer, Summoner>> getSummoners(Integer ... ids) {
        return new ApiFuture<Map<Integer, Summoner>>(() -> this.handler.getSummoners(ids));
    }

    public Future<Summoner> getSummoner(int id) {
        return new ApiFuture<Summoner>(() -> this.handler.getSummoner(id));
    }

    public Future<Map<Integer, Set<MasteryPage>>> getMasteryPagesMultipleUsers(Integer ... ids) {
        return new ApiFuture<Map<Integer, Set<MasteryPage>>>(() -> this.handler.getMasteryPagesMultipleUsers(ids));
    }

    public Future<Set<MasteryPage>> getMasteryPages(int id) {
        return new ApiFuture<Set<MasteryPage>>(() -> this.handler.getMasteryPages(id));
    }

    public Future<Map<Integer, String>> getSummonerNames(Integer ... ids) {
        return new ApiFuture<Map<Integer, String>>(() -> this.handler.getSummonerNames(ids));
    }

    public Future<String> getSummonerName(int id) {
        return new ApiFuture<String>(() -> this.handler.getSummonerName(id));
    }

    public Future<Map<Integer, Set<RunePage>>> getRunePagesMultipleUsers(int ... ids) {
        return new ApiFuture<Map<Integer, Set<RunePage>>>(() -> this.handler.getRunePagesMultipleUsers(ids));
    }

    public Future<Set<RunePage>> getRunePages(int id) {
        return new ApiFuture<Set<RunePage>>(() -> this.handler.getRunePages(id));
    }

    public Future<List<RankedTeam>> getTeams(long id) {
        return new ApiFuture<List<RankedTeam>>(() -> this.handler.getTeamsBySummoner(id));
    }

    public Future<Map<Long, List<RankedTeam>>> getTeams(long ... ids) {
        return new ApiFuture<Map<Long, List<RankedTeam>>>(() -> this.handler.getTeamsBySummoners(ids));
    }

    public Future<RankedTeam> getTeam(String teamId) {
        return new ApiFuture<RankedTeam>(() -> this.handler.getTeam(teamId));
    }

    public Future<Map<String, RankedTeam>> getTeams(String ... teamIds) {
        return new ApiFuture<Map<String, RankedTeam>>(() -> this.handler.getTeams(teamIds));
    }

    public Future<List<Long>> getSummonerIds(String ... names) {
        return new ApiFuture<List<Long>>(() -> this.handler.getSummonerIds(names));
    }

    public Future<Long> getSummonerId(String name) {
        return new ApiFuture<Long>(() -> this.handler.getSummonerId(name));
    }

    @Override
    public void close() {
        this.timer.cancel();
    }

    public static ThrottledApiHandler developmentDefault(Shard shard, String token) {
        return new ThrottledApiHandler(shard, token, new Limit(10, 10, TimeUnit.SECONDS), new Limit(500, 10, TimeUnit.MINUTES));
    }

    @Override
    public AsyncCurrentGameHandler getCurrentGameHandler() {
        return this.currentGameHandler;
    }

    @Override
    public AsyncFeaturedGamesHandler getFeaturedGamesHandler() {
        return this.featuredGamesHandler;
    }

    private class DummyFuture<T>
    implements Future<T> {
        private T value;

        private DummyFuture(T value) {
            this.value = value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.value;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.value;
        }
    }

    private class ApiFuture<T>
    implements Future<T> {
        private boolean cancelled;
        private Callable<T> request;
        private T value;
        private Exception err;
        private CountDownLatch signal = new CountDownLatch(1);

        public ApiFuture(Callable<T> request) {
            this.request = request;
            ThrottledApiHandler.this.scheduleNext(this);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.value != null || this.err != null;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.isCancelled()) {
                throw new ExecutionException("Task was cancelled", null);
            }
            this.signal.await();
            if (this.err != null) {
                throw new ExecutionException(this.err);
            }
            return this.value;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.isCancelled()) {
                throw new ExecutionException("Task was cancelled", null);
            }
            if (!this.signal.await(timeout, unit)) {
                throw new TimeoutException("Wait time for reply exceeded " + timeout + " " + (Object)((Object)unit));
            }
            if (this.err != null) {
                throw new ExecutionException(this.err);
            }
            return this.value;
        }

        public Exception getErr() {
            return this.err;
        }

        public Callable<T> getRequest() {
            return this.request;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public void setErr(Exception err) {
            this.err = err;
        }

        public CountDownLatch getSignal() {
            return this.signal;
        }
    }

    public static class Limit {
        public final int maxValue;
        public final int timeDeltaToMax;
        public final TimeUnit unit;

        @ConstructorProperties(value={"maxValue", "timeDeltaToMax", "unit"})
        public Limit(int maxValue, int timeDeltaToMax, TimeUnit unit) {
            this.maxValue = maxValue;
            this.timeDeltaToMax = timeDeltaToMax;
            this.unit = unit;
        }
    }

    public class AsyncFeaturedGamesHandler
    implements FeaturedGamesHandler {
        @Override
        public FeaturedGames getFeaturedGames() {
            try {
                return this.asyncGetFeaturedGames().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        public Future<FeaturedGames> asyncGetFeaturedGames() {
            return new ApiFuture<FeaturedGames>(((ThrottledApiHandler)ThrottledApiHandler.this).handler.featuredGamesHandler::getFeaturedGames);
        }

        @Override
        public Version getVersion() {
            return ThrottledApiHandler.this.handler.getFeaturedGamesHandler().getVersion();
        }
    }

    public class AsyncCurrentGameHandler
    implements CurrentGameHandler {
        @Override
        public CurrentGameInfo getCurrentGameInfo(long summoner) {
            try {
                return this.asyncGetCurrentGameInfo(summoner).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        public Future<CurrentGameInfo> asyncGetCurrentGameInfo(long summoner) {
            return new ApiFuture<CurrentGameInfo>(() -> ((ThrottledApiHandler)ThrottledApiHandler.this).handler.currentGameHandler.getCurrentGameInfo(summoner));
        }

        @Override
        public Version getVersion() {
            return ((ThrottledApiHandler)ThrottledApiHandler.this).handler.currentGameHandler.getVersion();
        }
    }
}

