package com.box.boxjavalibv2.requests;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.requests.requestobjects.BoxPagingRequestObject;
import com.box.restclientv2.RestMethod;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.DefaultBoxRequest;

/**
 * Request to get the items inside a folder. These items can be files, sub-folders, weblinks, and etc.
 */
public class GetCollectionItemsRequest extends DefaultBoxRequest {

    public static final String URI = "/collections/%s/items";

    /**
     * Constructor.
     * 
     * @param config
     *            config
     * @param parser
     *            json parser
     * @param collectionId
     *            id of the collection
     * @param requestObject
     *            request object
     * @throws BoxRestException
     *             exception
     */
    public GetCollectionItemsRequest(final IBoxConfig config, final IBoxJSONParser parser, final String collectionId, BoxPagingRequestObject requestObject)
        throws BoxRestException {
        super(config, parser, getUri(collectionId), RestMethod.GET, requestObject);
    }

    /**
     * Get uri.
     * 
     * @param collectionId
     *            id of the collection
     * @return uri
     */
    public static String getUri(final String collectionId) {
        return String.format(URI, collectionId);
    }
}
