/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2;

import com.box.boxjavalibv2.BoxConfigBuilder;
import com.box.boxjavalibv2.BoxConnectionManagerBuilder;
import com.box.boxjavalibv2.BoxRESTClient;
import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.authorization.IAuthDataController;
import com.box.boxjavalibv2.authorization.IAuthEvent;
import com.box.boxjavalibv2.authorization.IAuthFlowListener;
import com.box.boxjavalibv2.authorization.IAuthFlowMessage;
import com.box.boxjavalibv2.authorization.IAuthFlowUI;
import com.box.boxjavalibv2.authorization.IAuthSecureStorage;
import com.box.boxjavalibv2.authorization.IOAuthAuthorization;
import com.box.boxjavalibv2.authorization.OAuthAuthorization;
import com.box.boxjavalibv2.authorization.OAuthDataController;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.authorization.SharedLinkAuthorization;
import com.box.boxjavalibv2.dao.BoxBase;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.IAuthData;
import com.box.boxjavalibv2.events.OAuthEvent;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.jsonparsing.BoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.BoxResourceHub;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.resourcemanagers.BoxCollaborationsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxCollectionsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxCommentsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxEventsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxFilesManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxFoldersManageImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxGroupsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxItemsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxOAuthManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxSearchManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxSharedItemsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxTrashManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxUsersManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.BoxWebLinksManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.IBoxCollaborationsManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxCollectionsManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxCommentsManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxEventsManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxFilesManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxFoldersManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxGroupsManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxItemsManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxOAuthManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxSearchManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxSharedItemsManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxTrashManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxUsersManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxWebLinksManager;
import com.box.boxjavalibv2.resourcemanagers.IPluginResourceManagerBuilder;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public class BoxClient
extends BoxBase
implements IAuthFlowListener {
    private static final boolean DEFAULT_AUTO_REFRESH = true;
    private final IAuthDataController authController;
    private final IBoxRequestAuth auth;
    private final IBoxResourceHub resourceHub;
    private final IBoxJSONParser jsonParser;
    private final IBoxRESTClient restClient;
    private final IBoxConfig config;
    private final IBoxFilesManager filesManager;
    private final IBoxFoldersManager foldersManager;
    private final IBoxItemsManager boxItemsManager;
    private final IBoxSearchManager searchManager;
    private final IBoxEventsManager eventsManager;
    private final IBoxCollaborationsManager collaborationsManager;
    private final IBoxCommentsManager commentsManager;
    private final IBoxUsersManager usersManager;
    private final IBoxOAuthManager oauthManager;
    private final IBoxGroupsManager groupsManager;
    private final IBoxTrashManager trashManager;
    private final IBoxCollectionsManager collectionsManager;
    private final IBoxWebLinksManager webLinksManager;
    private final Map<String, IBoxResourceManager> pluginResourceManagers = new HashMap<String, IBoxResourceManager>();
    private IAuthFlowListener boxClientAuthListener;

    public BoxClient(String clientId, String clientSecret, IBoxResourceHub hub, IBoxJSONParser parser, IBoxConfig config, BoxConnectionManagerBuilder.BoxConnectionManager connectionManager) {
        this(clientId, clientSecret, hub, parser, BoxClient.createMonitoredRestClient(connectionManager), config);
    }

    public BoxClient(String clientId, String clientSecret, IBoxResourceHub hub, IBoxJSONParser parser, IBoxConfig config) {
        this(clientId, clientSecret, hub, parser, BoxClient.createRestClient(), config);
    }

    public BoxClient(String clientId, String clientSecret, IBoxResourceHub hub, IBoxJSONParser parser, IBoxRESTClient restClient, IBoxConfig config) {
        this.resourceHub = hub == null ? this.createResourceHub() : hub;
        this.jsonParser = parser == null ? this.createJSONParser(this.resourceHub) : parser;
        this.restClient = restClient;
        this.config = config == null ? new BoxConfigBuilder().build() : config;
        this.authController = this.createAuthDataController(clientId, clientSecret);
        this.auth = this.createAuthorization(this.authController);
        this.boxItemsManager = new BoxItemsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.filesManager = new BoxFilesManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.foldersManager = new BoxFoldersManageImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.searchManager = new BoxSearchManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.eventsManager = new BoxEventsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.collaborationsManager = new BoxCollaborationsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.commentsManager = new BoxCommentsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.usersManager = new BoxUsersManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.oauthManager = new BoxOAuthManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getRestClient());
        this.groupsManager = new BoxGroupsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.trashManager = new BoxTrashManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.collectionsManager = new BoxCollectionsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.webLinksManager = new BoxWebLinksManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
    }

    @Deprecated
    public BoxClient(String clientId, String clientSecret, IBoxConfig config) {
        this(clientId, clientSecret, null, null, config);
    }

    public IBoxResourceManager pluginResourceManager(String key, IPluginResourceManagerBuilder builder) {
        IBoxResourceManager manager = builder.build(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getAuth(), this.getRestClient());
        this.pluginResourceManagers.put(key, manager);
        return manager;
    }

    public boolean isAuthenticated() {
        return this.getOAuthDataController().getTokenState() == OAuthDataController.OAuthTokenState.AVAILABLE;
    }

    public void setAutoRefreshOAuth(boolean autoRefresh) {
        this.getOAuthDataController().setAutoRefreshOAuth(autoRefresh);
    }

    public void setConnectionOpen(boolean connectionOpen) {
        ((BoxRESTClient)this.getRestClient()).setConnectionOpen(connectionOpen);
    }

    public void setConnectionTimeOut(int timeOut) {
        ((BoxRESTClient)this.getRestClient()).setConnectionTimeOut(timeOut);
    }

    public OAuthDataController getOAuthDataController() {
        return (OAuthDataController)this.authController;
    }

    public void addOAuthRefreshListener(OAuthRefreshListener listener) {
        this.getOAuthDataController().setOAuthRefreshListener(listener);
    }

    public IAuthData getAuthData() throws AuthFatalFailureException {
        return this.getOAuthDataController().getAuthData();
    }

    public IAuthData guaranteedGetAuthData() throws AuthFatalFailureException {
        return this.getOAuthDataController().guaranteedGetAuthData();
    }

    public void saveAuth(IAuthSecureStorage storage) throws AuthFatalFailureException {
        storage.saveAuth(this.getAuthData());
    }

    public void authenticateFromSecureStorage(IAuthSecureStorage storage) {
        this.authenticate(storage.getAuth());
    }

    public IBoxFilesManager getFilesManager() {
        return this.filesManager;
    }

    public IBoxItemsManager getBoxItemsManager() {
        return this.boxItemsManager;
    }

    public IBoxItemsManager getSharedBoxItemsManager(String sharedLink, String password) {
        return new BoxItemsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public IBoxTrashManager getTrashManager() {
        return this.trashManager;
    }

    public IBoxOAuthManager getOAuthManager() {
        return this.oauthManager;
    }

    public IBoxGroupsManager getGroupsManager() {
        return this.groupsManager;
    }

    public IBoxSharedItemsManager getSharedItemsManager(String sharedLink, String password) {
        return new BoxSharedItemsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public IBoxFilesManager getSharedFilesManager(String sharedLink, String password) {
        return new BoxFilesManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public IBoxFoldersManager getSharedFoldersManager(String sharedLink, String password) {
        return new BoxFoldersManageImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public IBoxCommentsManager getSharedCommentsManager(String sharedLink, String password) {
        return new BoxCommentsManagerImpl(this.getConfig(), this.getResourceHub(), this.getJSONParser(), this.getSharedItemAuth(sharedLink, password), this.getRestClient());
    }

    public IBoxResourceManager getResourceManagerWithSharedLinkAuth(BoxResourceType type, String sharedLink, String password) {
        switch (type) {
            case FILE: {
                return this.getSharedFilesManager(sharedLink, password);
            }
            case FOLDER: {
                return this.getSharedFoldersManager(sharedLink, password);
            }
            case COMMENT: {
                return this.getSharedCommentsManager(sharedLink, password);
            }
        }
        throw new NotImplementedException();
    }

    public IBoxResourceManager getPluginManager(String pluginManagerKey) {
        return this.pluginResourceManagers.get(pluginManagerKey);
    }

    public IBoxFoldersManager getFoldersManager() {
        return this.foldersManager;
    }

    public IBoxWebLinksManager getWebLinksManager() {
        return this.webLinksManager;
    }

    public IBoxSearchManager getSearchManager() {
        return this.searchManager;
    }

    public IBoxEventsManager getEventsManager() {
        return this.eventsManager;
    }

    public IBoxCollaborationsManager getCollaborationsManager() {
        return this.collaborationsManager;
    }

    public IBoxCollectionsManager getCollectionsManager() {
        return this.collectionsManager;
    }

    public IBoxCommentsManager getCommentsManager() {
        return this.commentsManager;
    }

    public IBoxUsersManager getUsersManager() {
        return this.usersManager;
    }

    public synchronized void authenticate(IAuthData authData) {
        OAuthDataController oauthController = this.getOAuthDataController();
        oauthController.setOAuthData(authData);
    }

    public void authenticate(IAuthFlowUI authFlowUI, boolean autoRefreshOAuth, IAuthFlowListener listener) {
        this.setAutoRefreshOAuth(autoRefreshOAuth);
        this.setBoxClientAuthListener(listener);
        authFlowUI.authenticate(this);
    }

    protected IAuthFlowListener getBoxClientAuthenticationListener() {
        return this.boxClientAuthListener;
    }

    protected void setBoxClientAuthListener(IAuthFlowListener listener) {
        this.boxClientAuthListener = listener;
    }

    public OAuthDataController.OAuthTokenState getAuthState() {
        return this.getOAuthDataController().getTokenState();
    }

    public IBoxConfig getConfig() {
        return this.config;
    }

    protected IBoxResourceHub createResourceHub() {
        return new BoxResourceHub();
    }

    protected IBoxJSONParser createJSONParser(IBoxResourceHub resourceHub) {
        return new BoxJSONParser(resourceHub);
    }

    public IBoxResourceHub getResourceHub() {
        return this.resourceHub;
    }

    public IBoxJSONParser getJSONParser() {
        return this.jsonParser;
    }

    protected IBoxRESTClient getRestClient() {
        return this.restClient;
    }

    protected static IBoxRESTClient createRestClient() {
        return new BoxRESTClient();
    }

    protected static IBoxRESTClient createMonitoredRestClient(BoxConnectionManagerBuilder.BoxConnectionManager connectionManager) {
        return new BoxRESTClient(connectionManager);
    }

    public IBoxRequestAuth getSharedItemAuth(String sharedLink, String password) {
        return new SharedLinkAuthorization((OAuthAuthorization)this.getAuth(), sharedLink, password);
    }

    protected IAuthDataController createAuthDataController(String clientId, String clientSecret) {
        return new OAuthDataController(this, clientId, clientSecret, true);
    }

    protected IBoxRequestAuth createAuthorization(IAuthDataController controller) {
        return new OAuthAuthorization((OAuthDataController)this.authController);
    }

    public IBoxRequestAuth getAuth() {
        return this.auth;
    }

    public void clearBoxClientAuthListener() {
        this.setBoxClientAuthListener(null);
    }

    @Override
    public void onAuthFlowEvent(IAuthEvent event, IAuthFlowMessage message) {
        IBoxRequestAuth auth;
        OAuthEvent oe = (OAuthEvent)event;
        if (oe == OAuthEvent.OAUTH_CREATED && (auth = this.getAuth()) instanceof IOAuthAuthorization) {
            ((IOAuthAuthorization)((Object)auth)).setOAuthData(this.getOAuthTokenFromMessage(message));
        }
        if (this.getBoxClientAuthenticationListener() != null) {
            this.getBoxClientAuthenticationListener().onAuthFlowEvent(event, message);
            if (oe == OAuthEvent.OAUTH_CREATED) {
                this.clearBoxClientAuthListener();
            }
        }
    }

    @Override
    public void onAuthFlowMessage(IAuthFlowMessage message) {
        if (this.getBoxClientAuthenticationListener() != null) {
            this.getBoxClientAuthenticationListener().onAuthFlowMessage(message);
        }
    }

    @Override
    public void onAuthFlowException(Exception e) {
        if (this.getBoxClientAuthenticationListener() != null) {
            this.getBoxClientAuthenticationListener().onAuthFlowException(e);
            this.clearBoxClientAuthListener();
        }
    }

    protected BoxOAuthToken getOAuthTokenFromMessage(IAuthFlowMessage message) {
        return (BoxOAuthToken)message.getData();
    }
}

