/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.authorization;

import com.box.boxjavalibv2.authorization.IOAuthAuthorization;
import com.box.boxjavalibv2.authorization.OAuthDataController;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.dao.IAuthData;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.restclientv2.authorization.DefaultRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.IBoxRequest;

public class OAuthAuthorization
extends DefaultRequestAuth
implements IOAuthAuthorization {
    private static final String BEARER = "Bearer";
    private final OAuthDataController mOAuth;

    public OAuthAuthorization(OAuthDataController oAuth) {
        this.mOAuth = oAuth;
    }

    @Override
    public void setOAuthData(BoxOAuthToken data) {
        this.mOAuth.setOAuthData(data);
        this.mOAuth.initialize();
    }

    @Override
    public void refresh() throws AuthFatalFailureException {
        this.mOAuth.refresh();
    }

    @Override
    public void initOAuthForRequest() {
        this.mOAuth.initialize();
    }

    @Override
    public void setAuth(IBoxRequest request) throws BoxRestException, AuthFatalFailureException {
        super.setAuth(request);
        request.addHeader("Authorization", this.getAuthString());
    }

    private String getAuthString() throws AuthFatalFailureException {
        IAuthData data;
        if (this.mOAuth != null && (data = this.mOAuth.guaranteedGetAuthData()) != null) {
            return "Bearer " + data.getAccessToken();
        }
        return "";
    }
}

