/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.authorization;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.authorization.IAuthDataController;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.dao.IAuthData;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.restclientv2.exceptions.BoxRestException;

public class OAuthDataController
implements IAuthDataController {
    private static final int WAIT = 200;
    private static final int WAIT_TIME_OUT = 60000;
    private final BoxClient mClient;
    private final String mClientId;
    private final String mClientSecret;
    private String mDeviceId = null;
    private String mDeviceName = null;
    private volatile IAuthData mOAuthToken;
    private volatile OAuthTokenState mTokenState = OAuthTokenState.PRE_CREATION;
    private boolean mAutoRefresh;
    private int mWaitTimeOut = 60000;
    private Exception refreshFailException;
    private volatile boolean locked = false;
    private OAuthRefreshListener refreshListener;

    public OAuthDataController(BoxClient boxClient, String clientId, String clientSecret, boolean autoRefresh) {
        this.mClient = boxClient;
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
        this.mAutoRefresh = autoRefresh;
    }

    public void setAutoRefreshOAuth(boolean autoRefresh) {
        this.mAutoRefresh = autoRefresh;
    }

    public void setWaitTimeOut(int timeout) {
        this.mWaitTimeOut = timeout;
    }

    public String getScheme() {
        return this.mClient.getConfig().getOAuthUrlScheme();
    }

    public String getAuthority() {
        return this.mClient.getConfig().getOAuthUrlAuthority();
    }

    public String getUrlPath() {
        return this.mClient.getConfig().getOAuthWebUrlPath();
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOAuthData(IAuthData token) {
        try {
            this.waitForLock(true, 200L);
            this.mOAuthToken = token;
            if (this.mOAuthToken != null) {
                this.internalSetTokenState(OAuthTokenState.AVAILABLE);
            } else {
                this.internalSetTokenState(OAuthTokenState.PRE_CREATION);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void setDeviceId(String deviceId) {
        this.mDeviceId = deviceId;
    }

    public void setDeviceName(String deviceName) {
        this.mDeviceName = deviceName;
    }

    public OAuthTokenState getTokenState() {
        return this.mTokenState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTokenState() {
        try {
            this.waitForLock(true, 200L);
            this.internalSetTokenState(OAuthTokenState.PRE_CREATION);
        }
        finally {
            this.unlock();
        }
    }

    protected void internalSetTokenState(OAuthTokenState tokenState) {
        this.mTokenState = tokenState;
    }

    public Exception getRefreshFailException() {
        return this.refreshFailException;
    }

    public void setRefreshFail(Exception refreshFailException) {
        this.refreshFailException = refreshFailException;
        if (refreshFailException != null) {
            this.internalSetTokenState(OAuthTokenState.FAIL);
        }
    }

    public void initialize() {
        this.internalSetTokenState(OAuthTokenState.AVAILABLE);
        this.setRefreshFail(null);
        this.unlock();
    }

    @Override
    public IAuthData getAuthData() throws AuthFatalFailureException {
        long num = 0L;
        while (num * 200L <= (long)this.mWaitTimeOut) {
            if (this.getAndSetLock(false)) {
                return this.mOAuthToken;
            }
            this.doWait(200L);
            ++num;
        }
        throw new AuthFatalFailureException(this.getRefreshFailException());
    }

    public IAuthData guaranteedGetAuthData() throws AuthFatalFailureException {
        long num = 0L;
        while (num * 200L <= (long)this.mWaitTimeOut) {
            if (this.getAndSetLock(false)) {
                if (this.getTokenState() == OAuthTokenState.PRE_CREATION) {
                    if (!this.mAutoRefresh) {
                        throw new AuthFatalFailureException(this.getRefreshFailException());
                    }
                    this.refresh();
                    return this.guaranteedGetAuthData();
                }
                if (this.getTokenState() == OAuthTokenState.FAIL) {
                    throw new AuthFatalFailureException(this.getRefreshFailException());
                }
                return this.mOAuthToken;
            }
            this.doWait(200L);
            ++num;
        }
        throw new AuthFatalFailureException(this.getRefreshFailException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws AuthFatalFailureException {
        if (!this.getAndSetLock(true)) {
            this.getAuthData();
        } else {
            try {
                if (this.getTokenState() == OAuthTokenState.FAIL || !this.mAutoRefresh) {
                    this.internalSetTokenState(OAuthTokenState.FAIL);
                    throw new AuthFatalFailureException(this.getRefreshFailException());
                }
                this.doRefresh();
            }
            finally {
                this.unlock();
            }
        }
    }

    @Deprecated
    public void addOAuthRefreshListener(OAuthRefreshListener listener) {
        this.refreshListener = listener;
    }

    public void setOAuthRefreshListener(OAuthRefreshListener listener) {
        this.refreshListener = listener;
    }

    protected final synchronized boolean getAndSetLock(boolean doLock) {
        boolean lockRetrieved = false;
        if (doLock) {
            if (this.locked) {
                lockRetrieved = false;
            } else {
                this.locked = true;
                lockRetrieved = true;
            }
        } else {
            lockRetrieved = !this.locked;
        }
        return lockRetrieved;
    }

    protected void unlock() {
        this.locked = false;
    }

    protected void doRefresh() throws AuthFatalFailureException {
        this.internalSetTokenState(OAuthTokenState.REFRESHING);
        if (this.mOAuthToken == null) {
            this.setRefreshFail(new BoxRestException("OAuthToken is null"));
            throw new AuthFatalFailureException(this.getRefreshFailException());
        }
        String refreshToken = this.mOAuthToken.getRefreshToken();
        try {
            this.mOAuthToken = this.mClient.getOAuthManager().refreshOAuth(refreshToken, this.mClientId, this.mClientSecret, this.mDeviceId, this.mDeviceName);
            this.internalSetTokenState(OAuthTokenState.AVAILABLE);
            this.setRefreshFail(null);
            if (this.refreshListener != null) {
                this.refreshListener.onRefresh(this.mOAuthToken);
            }
        }
        catch (BoxRestException e) {
            this.internalSetTokenState(OAuthTokenState.AVAILABLE);
            throw new AuthFatalFailureException(e, refreshToken);
        }
        catch (BoxServerException e) {
            if (e.getStatusCode() == 400) {
                this.setRefreshFail(e);
            } else {
                this.internalSetTokenState(OAuthTokenState.AVAILABLE);
            }
            throw new AuthFatalFailureException(e, refreshToken);
        }
    }

    protected void doWait(long interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void waitForLock(boolean doLock, long interval) {
        while (!this.getAndSetLock(doLock)) {
            this.doWait(interval);
        }
    }

    public static enum OAuthTokenState {
        PRE_CREATION,
        AVAILABLE,
        REFRESHING,
        FAIL;

    }
}

