/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.authorization;

import com.box.boxjavalibv2.authorization.OAuthDataController;
import com.box.restclientv2.httpclientsupport.HttpClientURIBuilder;
import com.box.restclientv2.httpclientsupport.HttpClientURLEncodedUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class OAuthWebViewData {
    public static final String STATE = "state";
    private final String RESPONSE_TYPE = "code";
    private final OAuthDataController mOAuthDataController;
    private String mOptionalState;
    private String redirectUrl;
    private final HashMap<String, String> extraQueryParams = new HashMap();

    public void appendQueryParam(String key, String value) {
        this.extraQueryParams.put(key, value);
    }

    public OAuthWebViewData(OAuthDataController oAuthDataController) {
        this.mOAuthDataController = oAuthDataController;
    }

    public String getOptionalState() {
        return this.mOptionalState;
    }

    public void setOptionalState(String optionalState) {
        this.mOptionalState = optionalState;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String url) {
        this.redirectUrl = url;
    }

    public String getClientId() {
        return this.mOAuthDataController.getClientId();
    }

    public String getResponseType() {
        return "code";
    }

    public String getScheme() {
        return this.mOAuthDataController.getScheme();
    }

    public String getHost() {
        return this.mOAuthDataController.getAuthority();
    }

    public String getUrlPath() {
        return this.mOAuthDataController.getUrlPath();
    }

    public String getClientSecret() {
        return this.mOAuthDataController.getClientSecret();
    }

    public URI buildUrl() throws URISyntaxException {
        HttpClientURIBuilder ub = new HttpClientURIBuilder(this.getUrlPath());
        ub.setHost(this.getHost());
        ub.setScheme(this.getScheme());
        ub.addParameter("response_type", this.getResponseType());
        ub.addParameter("client_id", this.getClientId());
        if (StringUtils.isNotEmpty((String)this.getOptionalState())) {
            ub.addParameter(STATE, this.getOptionalState());
        }
        if (StringUtils.isNotEmpty((String)this.getRedirectUrl())) {
            ub.addParameter("redirect_uri", this.getRedirectUrl());
        }
        for (Map.Entry<String, String> entry : this.extraQueryParams.entrySet()) {
            ub.addParameter(entry.getKey(), entry.getValue());
        }
        HttpClientURLEncodedUtils.format(ub.getQueryParams(), "UTF-8");
        return ub.build();
    }
}

