/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.jsonparsing;

import com.box.boxjavalibv2.dao.IBoxType;
import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;
import java.io.InputStream;

public class BoxJSONParser
implements IBoxJSONParser {
    private final ObjectMapper mObjectMapper = new ObjectMapper();

    public BoxJSONParser(IBoxResourceHub hub) {
        this.mObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mObjectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        this.mObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (IBoxType type : hub.getAllTypes()) {
            this.mObjectMapper.registerSubtypes(new NamedType[]{new NamedType(hub.getClass(type), type.toString())});
        }
    }

    protected ObjectMapper getObjectMapper() {
        return this.mObjectMapper;
    }

    @Override
    public String convertBoxObjectToJSONStringQuietly(Object object) {
        try {
            return this.convertBoxObjectToJSONString(object);
        }
        catch (BoxJSONException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public <T> T parseIntoBoxObjectQuietly(InputStream inputStream, Class<T> theClass) {
        try {
            return this.parseIntoBoxObject(inputStream, theClass);
        }
        catch (BoxJSONException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public <T> T parseIntoBoxObjectQuietly(String jsonString, Class<T> theClass) {
        try {
            return this.parseIntoBoxObject(jsonString, theClass);
        }
        catch (BoxJSONException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String convertBoxObjectToJSONString(Object object) throws BoxJSONException, IOException {
        try {
            return this.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
    }

    @Override
    public <T> T parseIntoBoxObject(InputStream inputStream, Class<T> theClass) throws BoxJSONException, IOException {
        try {
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jp = jsonFactory.createParser(inputStream);
            return (T)this.getObjectMapper().readValue(jp, theClass);
        }
        catch (JsonGenerationException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
        catch (JsonParseException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
    }

    @Override
    public <T> T parseIntoBoxObject(String jsonString, Class<T> theClass) throws BoxJSONException, IOException {
        try {
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jp = jsonFactory.createParser(jsonString);
            return (T)this.getObjectMapper().readValue(jp, theClass);
        }
        catch (JsonGenerationException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
        catch (JsonParseException e) {
            throw new BoxJSONException((Exception)((Object)e));
        }
    }
}

