/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxGroup;
import com.box.boxjavalibv2.dao.BoxGroupMembership;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateGroupMembershipRequest;
import com.box.boxjavalibv2.requests.CreateGroupRequest;
import com.box.boxjavalibv2.requests.DeleteGroupMembershipRequest;
import com.box.boxjavalibv2.requests.DeleteGroupRequest;
import com.box.boxjavalibv2.requests.GetAllGroupsRequest;
import com.box.boxjavalibv2.requests.GetGroupCollaborationsRequest;
import com.box.boxjavalibv2.requests.GetGroupMembershipRequest;
import com.box.boxjavalibv2.requests.GetGroupMembershipsRequest;
import com.box.boxjavalibv2.requests.GetItemRequest;
import com.box.boxjavalibv2.requests.UpdateGroupMembershipRequest;
import com.box.boxjavalibv2.requests.UpdateGroupRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxGroupMembershipRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxGroupRequestObject;
import com.box.boxjavalibv2.resourcemanagers.AbstractBoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxGroupsManager;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;

public class BoxGroupsManagerImpl
extends AbstractBoxResourceManager
implements IBoxGroupsManager {
    public BoxGroupsManagerImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    @Override
    public BoxCollection getAllGroups(BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetAllGroupsRequest request = new GetAllGroupsRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUPS, this.getJSONParser());
    }

    @Override
    public BoxGroup createGroup(BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        CreateGroupRequest request = new CreateGroupRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxGroup)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP, this.getJSONParser());
    }

    @Override
    public BoxGroup createGroup(String name) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        BoxGroupRequestObject requestObj = BoxGroupRequestObject.createGroupRequestObject(name);
        return this.createGroup(requestObj);
    }

    @Override
    public BoxGroup updateGroup(String groupId, BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        UpdateGroupRequest request = new UpdateGroupRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        return (BoxGroup)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP, this.getJSONParser());
    }

    @Override
    public void deleteGroup(String groupId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        DeleteGroupRequest request = new DeleteGroupRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    @Override
    public BoxGroup getGroup(String groupId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetItemRequest request = new GetItemRequest(this.getConfig(), this.getJSONParser(), groupId, BoxResourceType.GROUP, requestObject);
        return (BoxGroup)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP, this.getJSONParser());
    }

    @Override
    public BoxCollection getMemberships(String groupId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetGroupMembershipsRequest request = new GetGroupMembershipsRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIPS, this.getJSONParser());
    }

    @Override
    public BoxGroupMembership getMembership(String membershipId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetGroupMembershipRequest request = new GetGroupMembershipRequest(this.getConfig(), this.getJSONParser(), membershipId, requestObject);
        return (BoxGroupMembership)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIP, this.getJSONParser());
    }

    @Override
    public BoxGroupMembership createMembership(BoxGroupMembershipRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        CreateGroupMembershipRequest request = new CreateGroupMembershipRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxGroupMembership)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIP, this.getJSONParser());
    }

    @Override
    public BoxGroupMembership createMembership(String groupId, String userId, String role) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        BoxGroupMembershipRequestObject obj = BoxGroupMembershipRequestObject.addMembershipRequestObject(groupId, userId, role);
        return this.createMembership(obj);
    }

    @Override
    public BoxGroupMembership updateMembership(String membershipId, BoxGroupMembershipRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        UpdateGroupMembershipRequest request = new UpdateGroupMembershipRequest(this.getConfig(), this.getJSONParser(), membershipId, requestObject);
        return (BoxGroupMembership)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIP, this.getJSONParser());
    }

    @Override
    public BoxGroupMembership updateMembership(String membershipId, String role) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        BoxGroupMembershipRequestObject obj = BoxGroupMembershipRequestObject.updateMembershipRequestObject(role);
        return this.updateMembership(membershipId, obj);
    }

    @Override
    public void deleteMembership(String membershipId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        DeleteGroupMembershipRequest request = new DeleteGroupMembershipRequest(this.getConfig(), this.getJSONParser(), membershipId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    @Override
    public BoxCollection getAllCollaborations(String groupId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetGroupCollaborationsRequest request = new GetGroupCollaborationsRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATIONS, this.getJSONParser());
    }
}

