/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.utils;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;

public final class Utils {
    private Utils() {
    }

    public static String getContainerString(BoxResourceType type) {
        switch (type) {
            case FILE_VERSION: {
                return "versions";
            }
        }
        return type.toPluralString();
    }

    public static <T extends BoxTypedObject> List<T> getTypedObjects(BoxCollection collection, Class<T> cls) {
        ArrayList<BoxTypedObject> objects = new ArrayList<BoxTypedObject>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!cls.isInstance(object)) continue;
            objects.add(object);
        }
        return objects;
    }

    public static void consumeHttpEntityQuietly(HttpEntity entity) {
        try {
            Utils.consumeHttpEntity(entity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consumeHttpEntity(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }

    public static String generateStateToken() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(UUID.randomUUID().toString().getBytes());
            return new String(Hex.encodeHex((byte[])digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            return UUID.randomUUID().toString();
        }
    }
}

