/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploymentchanger.endpointreplacement;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.control.deploy.IBPELProcess;
import net.bpelunit.framework.control.deploy.IDeployment;
import net.bpelunit.framework.control.ext.IDeploymentChanger;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.model.bpel.IPartnerLink;
import net.bpelunit.model.bpel.IProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReplacer
implements IDeploymentChanger {
    @Override
    public void changeDeployment(IDeployment d, TestSuite testSuite) throws DeploymentException {
        List<String> partnerTrackNames = this.getPartnerTrackNames(testSuite);
        for (IBPELProcess p : d.getBPELProcesses()) {
            List<String> partnerLinkNames = this.getPartnerLinkNamesWithPartnerRole(p.getProcessModel());
            partnerLinkNames.retainAll(partnerTrackNames);
            for (String partnerLinkName : partnerLinkNames) {
                p.changePartnerEndpoint(partnerLinkName, this.getEndpointForPartnerTrack(testSuite, partnerLinkName));
            }
        }
    }

    private String getEndpointForPartnerTrack(TestSuite testSuite, String partnerLinkName) {
        return ((Partner)testSuite.getProcessUnderTest().getPartners().get(partnerLinkName)).getSimulatedURL();
    }

    private List<String> getPartnerLinkNamesWithPartnerRole(IProcess iProcess) {
        ArrayList<String> names = new ArrayList<String>();
        for (IPartnerLink pl : iProcess.getPartnerLinks()) {
            if (pl.getPartnerRole() == null || pl.getPartnerRole().equals("")) continue;
            names.add(pl.getName());
        }
        return names;
    }

    private List<String> getPartnerTrackNames(TestSuite testSuite) {
        ArrayList<String> partnerTrackNames = new ArrayList<String>();
        if (testSuite != null && testSuite.getProcessUnderTest() != null && testSuite.getProcessUnderTest().getPartners() != null) {
            for (String name : testSuite.getProcessUnderTest().getPartners().keySet()) {
                partnerTrackNames.add(name);
            }
        }
        return partnerTrackNames;
    }
}

