/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.utils.bptstool.functions.create;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLPUTDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import net.bpelunit.model.bpel.BpelFactory;
import net.bpelunit.model.bpel.IImport;
import net.bpelunit.model.bpel.IPartnerLink;
import net.bpelunit.model.bpel.IProcess;
import net.bpelunit.util.FileUtil;
import net.bpelunit.util.XMLUtil;
import net.bpelunit.utils.bptstool.functions.IFunction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CreateFunction
implements IFunction {
    private static final String PARAMETER_TESTSUITE_DIRECTORY = "d";
    private static final String PARAMETER_BASEURL = "u";
    private String baseUrl = "http://localhost:7777/ws";
    private String deployerType = "fixed";
    private Options options;
    private String testSuiteDir;
    private String bpelFileName;
    private Map<String, File> wsdlFilesByNamespace = new HashMap<String, File>();

    public CreateFunction() {
        this.createOptions();
    }

    private final void createOptions() {
        this.options = new Options();
        OptionBuilder.withDescription((String)"directory into which the test suite and associated files shall be created");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIRECTORY");
        this.options.addOption(OptionBuilder.create((String)PARAMETER_TESTSUITE_DIRECTORY));
        OptionBuilder.withDescription((String)String.format("Base URL at which the mock services shall be made available. Must start with http://localhost. Defaults to: %s", this.baseUrl));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"URL");
        this.options.addOption(OptionBuilder.create((String)PARAMETER_BASEURL));
    }

    public String getName() {
        return "create";
    }

    public String getDescription() {
        return "some description";
    }

    public String getHelp() {
        return null;
    }

    private final void parseOptionsFromCommandLine(String[] args) {
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(this.options, args);
            if (cmd.hasOption(PARAMETER_TESTSUITE_DIRECTORY)) {
                this.testSuiteDir = cmd.getOptionValue(PARAMETER_TESTSUITE_DIRECTORY);
            }
            ArrayList remainingOptions = new ArrayList(cmd.getArgList());
            this.bpelFileName = (String)remainingOptions.get(0);
        }
        catch (ParseException e) {
            this.showHelpAndExit();
        }
    }

    private void showHelpAndExit() {
    }

    public void execute(String[] params) {
        this.parseOptionsFromCommandLine(params);
        WSDLReader wsdlReader = null;
        try {
            wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        }
        catch (WSDLException e) {
            throw new RuntimeException(e);
        }
        File bpelFile = new File(this.bpelFileName);
        File bptsFile = this.getBptsFile(bpelFile, this.testSuiteDir);
        try {
            IProcess bpel = BpelFactory.loadProcess((InputStream)new FileInputStream(bpelFile));
            List imports = bpel.getImports();
            for (IImport i : imports) {
                this.wsdlFilesByNamespace.put(i.getNamespace(), new File(bpelFile.getParentFile(), i.getLocation()).getCanonicalFile());
            }
            XMLTestSuiteDocument testSuiteDoc = XMLTestSuiteDocument.Factory.newInstance();
            XMLTestSuite testSuite = testSuiteDoc.addNewTestSuite();
            XMLDeploymentSection deployment = testSuite.addNewDeployment();
            testSuite.addNewTestCases();
            testSuite.setName(bptsFile.getName());
            testSuite.setBaseURL(this.baseUrl);
            XMLPUTDeploymentInformation processUnderTest = deployment.addNewPut();
            processUnderTest.setName(bpel.getName());
            processUnderTest.setType(this.deployerType);
            List partnerLinks = bpel.getPartnerLinks();
            for (IPartnerLink pl : partnerLinks) {
                if (pl.getPartnerRole() == null) continue;
                XMLPartnerDeploymentInformation partner = deployment.addNewPartner();
                partner.setName(pl.getName());
                QName plt = pl.getPartnerLinkType();
                String pltNS = plt.getNamespaceURI();
                File wsdlFile = this.wsdlFilesByNamespace.get(pltNS);
                Document wsdlXml = XMLUtil.parseXML((InputStream)new FileInputStream(wsdlFile));
                List partnerLinkTypeDefinitions = XMLUtil.getChildElementsByName((Element)wsdlXml.getDocumentElement(), (String)"partnerLinkType");
            }
            System.out.println(bptsFile);
            testSuiteDoc.save(bptsFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    File getBptsFile(File bpelFile, String testSuiteDir) {
        File bptsFile;
        if (testSuiteDir == null) {
            bptsFile = new File(FileUtil.getFileNameWithoutSuffix((String)bpelFile.getAbsolutePath()) + ".bpts");
        } else {
            bptsFile = new File(testSuiteDir);
            bptsFile = bptsFile.isAbsolute() ? new File(bptsFile, FileUtil.getFileNameWithoutSuffix((String)bpelFile.getName()) + ".bpts") : new File(new File(bpelFile.getParentFile(), testSuiteDir), FileUtil.getFileNameWithoutSuffix((String)bpelFile.getName()) + ".bpts");
            bptsFile.getParentFile().mkdirs();
        }
        try {
            return bptsFile.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return bptsFile;
        }
    }
}

