/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.TypeAttributes;
import com.google.gson.internal.$Gson$Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldAttributes
implements TypeAttributes {
    public static final TypeAttributes DEFAULT_ATTRIBUTES;
    private static final Object _default_field;
    private final Field field;

    public FieldAttributes(Field f) {
        $Gson$Preconditions.checkNotNull(f);
        this.field = f;
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public String getName() {
        return this.field.getName();
    }

    @Override
    public Type getDeclaredType() {
        return this.field.getGenericType();
    }

    @Override
    public Class<?> getDeclaredClass() {
        return this.field.getType();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.field.getAnnotation(annotation);
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return Arrays.asList(this.field.getAnnotations());
    }

    public boolean hasModifier(int modifier) {
        return (this.field.getModifiers() & modifier) != 0;
    }

    Object get(Object instance) throws IllegalAccessException {
        return this.field.get(instance);
    }

    boolean isSynthetic() {
        return this.field.isSynthetic();
    }

    static {
        try {
            DEFAULT_ATTRIBUTES = new FieldAttributes(FieldAttributes.class.getDeclaredField("_default_field"));
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)"Should not happen");
        }
        _default_field = null;
    }
}

