/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import net.bull.javamelody.ExcludingPointcut;
import net.bull.javamelody.JavaMelodyConfigurationProperties;
import net.bull.javamelody.JobGlobalListener;
import net.bull.javamelody.MonitoredWithAnnotationPointcut;
import net.bull.javamelody.MonitoringEndpoint;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.MonitoringSpringAdvisor;
import net.bull.javamelody.MonitoringSpringInterceptor;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.SpringContext;
import net.bull.javamelody.SpringDataSourceBeanPostProcessor;
import net.bull.javamelody.SpringElasticsearchOperationsBeanPostProcessor;
import net.bull.javamelody.SpringMongoDbFactoryBeanPostProcessor;
import net.bull.javamelody.SpringRestTemplateBeanPostProcessor;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.quartz.JobListener;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.Pointcuts;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.quartz.SchedulerFactoryBeanCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Schedules;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@EnableConfigurationProperties(value={JavaMelodyConfigurationProperties.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="javamelody", name={"enabled"}, matchIfMissing=true)
public class JavaMelodyAutoConfiguration {
    public static final String REGISTRATION_BEAN_NAME = "javamelody-registration";
    private final MonitoredWithAnnotationPointcut monitoredWithSpringAnnotationPointcut = new MonitoredWithAnnotationPointcut();
    private final Pointcut asyncAnnotationPointcut = Pointcuts.union((Pointcut)new AnnotationMatchingPointcut(Async.class), (Pointcut)new AnnotationMatchingPointcut(null, Async.class));
    private final Pointcut scheduledAnnotationPointcut = Pointcuts.union((Pointcut)new AnnotationMatchingPointcut(null, Scheduled.class), (Pointcut)new AnnotationMatchingPointcut(null, Schedules.class));

    @Bean
    public ServletListenerRegistrationBean<EventListener> monitoringSessionListener(ServletContext servletContext) {
        ServletListenerRegistrationBean servletListenerRegistrationBean = new ServletListenerRegistrationBean((EventListener)new SessionListener());
        if (servletContext.getFilterRegistration("javamelody") != null) {
            servletListenerRegistrationBean.setEnabled(false);
        }
        return servletListenerRegistrationBean;
    }

    @Bean(name={"javamelody-registration"})
    @ConditionalOnMissingBean(name={"javamelody-registration"})
    public FilterRegistrationBean<MonitoringFilter> monitoringFilter(JavaMelodyConfigurationProperties properties, ServletContext servletContext) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        MonitoringFilter filter = properties.isManagementEndpointMonitoringEnabled() ? new MonitoringFilter(){

            protected boolean isAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.sendError(403, "Forbidden access");
                return false;
            }
        } : new MonitoringFilter();
        filter.setApplicationType("Spring Boot");
        registrationBean.setFilter((Filter)filter);
        registrationBean.setAsyncSupported(true);
        registrationBean.setName("javamelody");
        registrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        for (Map.Entry<String, String> parameter : properties.getInitParameters().entrySet()) {
            registrationBean.addInitParameter(parameter.getKey(), parameter.getValue());
        }
        registrationBean.addUrlPatterns(new String[]{"/*"});
        FilterRegistration filterRegistration = servletContext.getFilterRegistration("javamelody");
        if (filterRegistration != null) {
            registrationBean.setEnabled(false);
            for (Map.Entry entry : registrationBean.getInitParameters().entrySet()) {
                filterRegistration.setInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"management-endpoint-monitoring-enabled"}, matchIfMissing=false)
    public MonitoringEndpoint monitoringEndpoint(ServletContext servletContext) {
        return new MonitoringEndpoint(servletContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultAdvisorAutoProxyCreator.class})
    @ConditionalOnProperty(prefix="javamelody", name={"advisor-auto-proxy-creator-enabled"}, matchIfMissing=false)
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        return new DefaultAdvisorAutoProxyCreator();
    }

    @Bean
    public SpringDataSourceBeanPostProcessor monitoringDataSourceBeanPostProcessor(@Value(value="${javamelody.excluded-datasources:}") String excludedDatasources) {
        SpringDataSourceBeanPostProcessor processor = new SpringDataSourceBeanPostProcessor();
        if (excludedDatasources != null && excludedDatasources.trim().length() > 0) {
            processor.setExcludedDatasources(new HashSet<String>(Arrays.asList(excludedDatasources.split(","))));
        }
        return processor;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringAdvisor() {
        return new MonitoringSpringAdvisor((Pointcut)this.monitoredWithSpringAnnotationPointcut);
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringServiceAdvisor() {
        return this.createMonitoringSpringAdvisorWithExclusions((Pointcut)new AnnotationMatchingPointcut(Service.class), new Pointcut[]{this.monitoredWithSpringAnnotationPointcut, this.asyncAnnotationPointcut, this.scheduledAnnotationPointcut});
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringControllerAdvisor() {
        return this.createMonitoringSpringAdvisorWithExclusions((Pointcut)new AnnotationMatchingPointcut(Controller.class), new Pointcut[]{this.monitoredWithSpringAnnotationPointcut, this.asyncAnnotationPointcut, this.scheduledAnnotationPointcut});
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringRestControllerAdvisor() {
        return this.createMonitoringSpringAdvisorWithExclusions((Pointcut)new AnnotationMatchingPointcut(RestController.class), new Pointcut[]{this.monitoredWithSpringAnnotationPointcut, this.asyncAnnotationPointcut, this.scheduledAnnotationPointcut});
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringAsyncAdvisor() {
        return this.createMonitoringSpringAdvisorWithExclusions(this.asyncAnnotationPointcut, new Pointcut[]{this.monitoredWithSpringAnnotationPointcut, this.scheduledAnnotationPointcut});
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"scheduled-monitoring-enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={DefaultAdvisorAutoProxyCreator.class})
    public MonitoringSpringAdvisor monitoringSpringScheduledAdvisor() {
        return this.createMonitoringSpringAdvisorWithExclusions(this.scheduledAnnotationPointcut, new Pointcut[]{this.monitoredWithSpringAnnotationPointcut, this.asyncAnnotationPointcut});
    }

    private MonitoringSpringAdvisor createMonitoringSpringAdvisorWithExclusions(Pointcut pointcut, Pointcut ... excludedPointcuts) {
        Pointcut myPointcut;
        if (excludedPointcuts.length == 0) {
            myPointcut = pointcut;
        } else {
            Pointcut excludedPointcut = excludedPointcuts[0];
            if (excludedPointcuts.length > 1) {
                for (int i = 1; i < excludedPointcuts.length; ++i) {
                    excludedPointcut = Pointcuts.union((Pointcut)excludedPointcut, (Pointcut)excludedPointcuts[i]);
                }
            }
            myPointcut = new ExcludingPointcut(pointcut).exclude(excludedPointcut);
        }
        return new MonitoringSpringAdvisor(myPointcut);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignClient"})
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={DefaultAdvisorAutoProxyCreator.class})
    public MonitoringSpringAdvisor monitoringFeignClientAdvisor() throws ClassNotFoundException {
        Class<?> feignClientClass = Class.forName("org.springframework.cloud.openfeign.FeignClient");
        MonitoringSpringAdvisor advisor = new MonitoringSpringAdvisor((Pointcut)new AnnotationMatchingPointcut(feignClientClass, true));
        advisor.setAdvice((Advice)new MonitoringSpringInterceptor(){
            private static final long serialVersionUID = 1L;

            protected String getRequestName(MethodInvocation invocation) {
                StringBuilder sb = new StringBuilder();
                Method method = invocation.getMethod();
                RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                if (requestMapping != null) {
                    String[] path = requestMapping.value();
                    if (path.length == 0) {
                        path = requestMapping.path();
                    }
                    if (path.length > 0) {
                        sb.append(path[0]);
                        sb.append(' ');
                        if (requestMapping.method().length > 0) {
                            sb.append(requestMapping.method()[0].name());
                        } else {
                            sb.append("GET");
                        }
                        sb.append('\n');
                    }
                }
                Class<?> declaringClass = method.getDeclaringClass();
                String classPart = declaringClass.getSimpleName();
                String methodPart = method.getName();
                sb.append(classPart).append('.').append(methodPart);
                return sb.toString();
            }
        });
        return advisor;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public SpringRestTemplateBeanPostProcessor monitoringRestTemplateBeanPostProcessor() {
        return new SpringRestTemplateBeanPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public SpringMongoDbFactoryBeanPostProcessor monitoringMongoDbFactoryBeanPostProcessor() {
        return new SpringMongoDbFactoryBeanPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public SpringElasticsearchOperationsBeanPostProcessor monitoringElasticsearchOperationsBeanPostProcessor() {
        return new SpringElasticsearchOperationsBeanPostProcessor();
    }

    @ConditionalOnClass(name={"org.springframework.boot.autoconfigure.quartz.SchedulerFactoryBeanCustomizer", "org.springframework.scheduling.quartz.SchedulerFactoryBean", "org.quartz.JobListener"})
    @Bean
    @ConditionalOnMissingBean
    public SchedulerFactoryBeanCustomizer schedulerFactoryBeanCustomizer() {
        return new SchedulerFactoryBeanCustomizer(){

            public void customize(SchedulerFactoryBean schedulerFactoryBean) {
                JobGlobalListener jobGlobalListener = new JobGlobalListener();
                schedulerFactoryBean.setGlobalJobListeners(new JobListener[]{jobGlobalListener});
                schedulerFactoryBean.setExposeSchedulerInRepository(true);
            }
        };
    }

    @Bean
    public SpringContext javamelodySpringContext() {
        return new SpringContext();
    }
}

