/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import net.bytebuddy.agent.Installer;

public class ByteBuddyAgent {
    private static final String AGENT_CLASS_PROPERTY = "Agent-Class";
    private static final String CAN_REDEFINE_CLASSES_PROPERTY = "Can-Redefine-Classes";
    private static final String CAN_RETRANSFORM_CLASSES_PROPERTY = "Can-Retransform-Classes";
    private static final String CAN_SET_NATIVE_METHOD_PREFIX = "Can-Set-Native-Method-Prefix";
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    private static final int BUFFER_SIZE = 1024;
    private static final int START_INDEX = 0;
    private static final int END_OF_FILE = -1;
    private static final Object STATIC_MEMBER = null;
    private static final ClassLoader BOOTSTRAP_CLASS_LOADER = null;
    private static final String WITHOUT_ARGUMENTS = "";
    private static final String AGENT_FILE_NAME = "byteBuddyAgent";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String ATTACH_METHOD_NAME = "attach";
    private static final String LOAD_AGENT_METHOD_NAME = "loadAgent";
    private static final String DETACH_METHOD_NAME = "detach";
    private static final String INSTRUMENTATION_FIELD_NAME = "instrumentation";

    private ByteBuddyAgent() {
        throw new UnsupportedOperationException();
    }

    public static Instrumentation install() {
        return ByteBuddyAgent.install(AttachmentProvider.DEFAULT);
    }

    public static synchronized Instrumentation install(AttachmentProvider attachmentProvider) {
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation != null) {
            return instrumentation;
        }
        AttachmentProvider.Accessor accessor = attachmentProvider.attempt();
        if (accessor.isAvailable()) {
            try {
                ByteBuddyAgent.doInstall(accessor);
                return ByteBuddyAgent.doGetInstrumentation();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Current JVM does not support attachment with " + attachmentProvider);
            }
        }
        throw new IllegalStateException("Attachment provider cannot connect on the current JVM: " + attachmentProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInstall(AttachmentProvider.Accessor accessor) throws Exception {
        Class<?> virtualMachine = accessor.getVirtualMachineType();
        Object virtualMachineInstance = virtualMachine.getDeclaredMethod(ATTACH_METHOD_NAME, String.class).invoke(STATIC_MEMBER, accessor.getProcessId());
        File agentJar = File.createTempFile(AGENT_FILE_NAME, JAR_FILE_EXTENSION);
        try {
            ByteBuddyAgent.saveAgentJar(agentJar);
            virtualMachine.getDeclaredMethod(LOAD_AGENT_METHOD_NAME, String.class, String.class).invoke(virtualMachineInstance, agentJar.getAbsolutePath(), WITHOUT_ARGUMENTS);
        }
        finally {
            try {
                virtualMachine.getDeclaredMethod(DETACH_METHOD_NAME, new Class[0]).invoke(virtualMachineInstance, new Object[0]);
            }
            finally {
                if (!agentJar.delete()) {
                    Logger.getAnonymousLogger().info("Cannot delete temporary file: " + agentJar);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveAgentJar(File agentFile) throws Exception {
        InputStream inputStream = Installer.class.getResourceAsStream('/' + Installer.class.getName().replace('.', '/') + CLASS_FILE_EXTENSION);
        if (inputStream == null) {
            throw new IllegalStateException("Cannot locate class file for Byte Buddy agent");
        }
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION_VALUE);
            manifest.getMainAttributes().put(new Attributes.Name(AGENT_CLASS_PROPERTY), Installer.class.getName());
            manifest.getMainAttributes().put(new Attributes.Name(CAN_REDEFINE_CLASSES_PROPERTY), Boolean.TRUE.toString());
            manifest.getMainAttributes().put(new Attributes.Name(CAN_RETRANSFORM_CLASSES_PROPERTY), Boolean.TRUE.toString());
            manifest.getMainAttributes().put(new Attributes.Name(CAN_SET_NATIVE_METHOD_PREFIX), Boolean.TRUE.toString());
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(agentFile), manifest);
            try {
                int index;
                jarOutputStream.putNextEntry(new JarEntry('/' + Installer.class.getName().replace('.', '/') + CLASS_FILE_EXTENSION));
                byte[] buffer = new byte[1024];
                while ((index = inputStream.read(buffer)) != -1) {
                    jarOutputStream.write(buffer, 0, index);
                }
                jarOutputStream.closeEntry();
            }
            finally {
                jarOutputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static Instrumentation getInstrumentation() {
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation == null) {
            throw new IllegalStateException("The Byte Buddy agent is not initialized");
        }
        return instrumentation;
    }

    private static Instrumentation doGetInstrumentation() {
        try {
            return (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(Installer.class.getName()).getDeclaredField(INSTRUMENTATION_FIELD_NAME).get(STATIC_MEMBER);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not properly initialized", exception);
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="No circularity, initialization is safe")
    public static interface AttachmentProvider {
        public static final AttachmentProvider DEFAULT = new Compound(ForJigsawVm.INSTANCE, ForToolsJarVm.JVM_ROOT, ForToolsJarVm.JDK_ROOT, ForToolsJarVm.MACINTOSH);

        public Accessor attempt();

        public static class Compound
        implements AttachmentProvider {
            private final List<? extends AttachmentProvider> attachmentProviders;

            public Compound(AttachmentProvider ... attachmentProvider) {
                this(Arrays.asList(attachmentProvider));
            }

            public Compound(List<? extends AttachmentProvider> attachmentProviders) {
                this.attachmentProviders = attachmentProviders;
            }

            @Override
            public Accessor attempt() {
                for (AttachmentProvider attachmentProvider : this.attachmentProviders) {
                    Accessor accessor = attachmentProvider.attempt();
                    if (!accessor.isAvailable()) continue;
                    return accessor;
                }
                return Accessor.Unavailable.INSTANCE;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Compound compound = (Compound)other;
                return this.attachmentProviders.equals(compound.attachmentProviders);
            }

            public int hashCode() {
                return this.attachmentProviders.hashCode();
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.Compound{attachmentProviders=" + this.attachmentProviders + '}';
            }
        }

        public static enum ForToolsJarVm implements AttachmentProvider
        {
            JVM_ROOT("../lib/tools.jar"),
            JDK_ROOT("lib/tools.jar"),
            MACINTOSH("../Classes/classes.jar");

            private static final String JAVA_HOME_PROPERTY = "java.home";
            private final String toolsJarPath;

            private ForToolsJarVm(String toolsJarPath) {
                this.toolsJarPath = toolsJarPath;
            }

            @Override
            public Accessor attempt() {
                File toolsJar = new File(System.getProperty(JAVA_HOME_PROPERTY).replace('\\', '/') + "/../" + this.toolsJarPath);
                return toolsJar.isFile() && toolsJar.canRead() ? Accessor.Simple.of(AccessController.doPrivileged(new ClassLoaderCreationAction(toolsJar))) : Accessor.Unavailable.INSTANCE;
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.ForToolsJarVm." + this.name();
            }

            protected static class ClassLoaderCreationAction
            implements PrivilegedAction<ClassLoader> {
                private final File toolsJar;

                public ClassLoaderCreationAction(File toolsJar) {
                    this.toolsJar = toolsJar;
                }

                @Override
                public ClassLoader run() {
                    try {
                        return new URLClassLoader(new URL[]{this.toolsJar.toURI().toURL()}, BOOTSTRAP_CLASS_LOADER);
                    }
                    catch (MalformedURLException exception) {
                        throw new IllegalStateException("Could not represent " + this.toolsJar + " as URL");
                    }
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ClassLoaderCreationAction that = (ClassLoaderCreationAction)other;
                    return this.toolsJar.equals(that.toolsJar);
                }

                public int hashCode() {
                    return this.toolsJar.hashCode();
                }

                public String toString() {
                    return "ByteBuddyAgent.AttachmentProvider.ForToolsJarVm.ClassLoaderCreationAction{toolsJar=" + this.toolsJar + '}';
                }
            }
        }

        public static enum ForJigsawVm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public Accessor attempt() {
                return Accessor.Simple.of(ClassLoader.getSystemClassLoader());
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.ForJigsawVm." + this.name();
            }
        }

        public static interface Accessor {
            public static final String VIRTUAL_MACHINE_TYPE_NAME = "com.sun.tools.attach.VirtualMachine";

            public boolean isAvailable();

            public Class<?> getVirtualMachineType();

            public String getProcessId();

            public static class Simple
            implements Accessor {
                private final Class<?> virtualMachineType;
                private final String processId;

                protected Simple(Class<?> virtualMachineType, String processId) {
                    this.virtualMachineType = virtualMachineType;
                    this.processId = processId;
                }

                public static Accessor of(ClassLoader classLoader) {
                    try {
                        return Simple.of(classLoader.loadClass(Accessor.VIRTUAL_MACHINE_TYPE_NAME));
                    }
                    catch (ClassNotFoundException ignored) {
                        return Unavailable.INSTANCE;
                    }
                }

                protected static Accessor of(Class<?> virtualMachineType) {
                    String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
                    int processIdIndex = runtimeName.indexOf(64);
                    return processIdIndex == -1 ? Unavailable.INSTANCE : new Simple(virtualMachineType, runtimeName.substring(0, processIdIndex));
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Class<?> getVirtualMachineType() {
                    return this.virtualMachineType;
                }

                @Override
                public String getProcessId() {
                    return this.processId;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Simple simple = (Simple)other;
                    return this.virtualMachineType.equals(simple.virtualMachineType) && this.processId.equals(simple.processId);
                }

                public int hashCode() {
                    int result = this.virtualMachineType.hashCode();
                    result = 31 * result + this.processId.hashCode();
                    return result;
                }

                public String toString() {
                    return "ByteBuddyAgent.AttachmentProvider.Accessor.Simple{virtualMachineType=" + this.virtualMachineType + ", processId='" + this.processId + '\'' + '}';
                }
            }

            public static enum Unavailable implements Accessor
            {
                INSTANCE;


                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public Class<?> getVirtualMachineType() {
                    throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                }

                @Override
                public String getProcessId() {
                    throw new IllegalStateException("Cannot read process ID for an unavailable accessor");
                }

                public String toString() {
                    return "ByteBuddyAgent.AttachmentProvider.Accessor.Unavailable." + this.name();
                }
            }
        }
    }
}

