/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public interface VirtualMachine {
    public void loadAgent(String var1, String var2) throws IOException;

    public void loadAgentPath(String var1, String var2) throws IOException;

    public void detach() throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForHotSpotVm
    implements VirtualMachine {
        private static final String UTF_8 = "UTF-8";
        private static final String PROTOCOL_VERSION = "1";
        private static final String LOAD_COMMAND = "load";
        private static final String INSTRUMENT_COMMAND = "instrument";
        private static final String ARGUMENT_DELIMITER = "=";
        private static final byte[] BLANK = new byte[]{0};
        private final Connection connection;

        protected ForHotSpotVm(Connection connection) {
            this.connection = connection;
        }

        public static Class<?> assertAvailability() throws Throwable {
            if (Platform.isWindows() || Platform.isWindowsCE()) {
                throw new IllegalStateException("POSIX sockets are not available on Windows");
            }
            Class.forName(Native.class.getName());
            return ForHotSpotVm.class;
        }

        public static VirtualMachine attach(String processId) throws IOException {
            return ForHotSpotVm.attach(processId, new Connection.ForJnaPosixSocket.Factory(10, 100L, TimeUnit.MILLISECONDS));
        }

        public static VirtualMachine attach(String processId, Connection.Factory connectionFactory) throws IOException {
            return new ForHotSpotVm(connectionFactory.connect(processId));
        }

        @Override
        public void loadAgent(String jarFile, String argument) throws IOException {
            this.load(jarFile, false, argument);
        }

        @Override
        public void loadAgentPath(String library, String argument) throws IOException {
            this.load(library, true, argument);
        }

        protected void load(String file, boolean isNative, String argument) throws IOException {
            int length;
            this.connection.write(PROTOCOL_VERSION.getBytes(UTF_8));
            this.connection.write(BLANK);
            this.connection.write(LOAD_COMMAND.getBytes(UTF_8));
            this.connection.write(BLANK);
            this.connection.write(INSTRUMENT_COMMAND.getBytes(UTF_8));
            this.connection.write(BLANK);
            this.connection.write(Boolean.toString(isNative).getBytes(UTF_8));
            this.connection.write(BLANK);
            this.connection.write((argument == null ? file : file + ARGUMENT_DELIMITER + argument).getBytes(UTF_8));
            this.connection.write(BLANK);
            byte[] buffer = new byte[1];
            StringBuilder stringBuilder = new StringBuilder();
            while ((length = this.connection.read(buffer)) != -1) {
                if (length <= 0) continue;
                if (buffer[0] == 10) break;
                stringBuilder.append((char)buffer[0]);
            }
            switch (Integer.parseInt(stringBuilder.toString())) {
                case 0: {
                    return;
                }
                case 101: {
                    throw new IOException("Protocol mismatch with target VM");
                }
            }
            buffer = new byte[1024];
            stringBuilder = new StringBuilder();
            while ((length = this.connection.read(buffer)) != -1) {
                stringBuilder.append(new String(buffer, 0, length, UTF_8));
            }
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public void detach() throws IOException {
            this.connection.close();
        }

        public static interface Connection
        extends Closeable {
            public int read(byte[] var1) throws IOException;

            public void write(byte[] var1) throws IOException;

            public static class ForJnaPosixSocket
            implements Connection {
                private final PosixSocketLibrary library;
                private final int handle;

                protected ForJnaPosixSocket(PosixSocketLibrary library, int handle) {
                    this.library = library;
                    this.handle = handle;
                }

                public int read(byte[] buffer) {
                    return this.library.read(this.handle, ByteBuffer.wrap(buffer), buffer.length);
                }

                public void write(byte[] buffer) {
                    int write = this.library.write(this.handle, ByteBuffer.wrap(buffer), buffer.length);
                    if (write != buffer.length) {
                        throw new IllegalStateException("Could not write entire buffer to socket");
                    }
                }

                public void close() {
                    this.library.close(this.handle);
                }

                public static class Factory
                extends Factory.ForPosixSocket {
                    private final PosixSocketLibrary library = (PosixSocketLibrary)Native.load((String)"c", PosixSocketLibrary.class);

                    public Factory(int attempts, long pause, TimeUnit timeUnit) {
                        super(attempts, pause, timeUnit);
                    }

                    public Connection doConnect(File socket) {
                        int handle = this.library.socket(1, 1, 0);
                        if (handle == 0) {
                            throw new IllegalStateException("Could not open POSIX socket");
                        }
                        PosixSocketLibrary.SocketAddress address = new PosixSocketLibrary.SocketAddress();
                        address.setPath(socket.getAbsolutePath());
                        if (this.library.connect(handle, address, address.size()) != 0) {
                            throw new IllegalStateException("Could not connect to POSIX socket on " + socket);
                        }
                        return new ForJnaPosixSocket(this.library, handle);
                    }
                }

                protected static interface PosixSocketLibrary
                extends Library {
                    public int socket(int var1, int var2, int var3);

                    public int connect(int var1, SocketAddress var2, int var3);

                    public int read(int var1, ByteBuffer var2, int var3);

                    public int write(int var1, ByteBuffer var2, int var3);

                    public int close(int var1);

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public static class SocketAddress
                    extends Structure {
                        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field required by native implementation.")
                        public short family = 1;
                        public byte[] path = new byte[100];

                        public void setPath(String path) {
                            try {
                                System.arraycopy(path.getBytes(ForHotSpotVm.UTF_8), 0, this.path, 0, path.length());
                                System.arraycopy(new byte[]{0}, 0, this.path, path.length(), 1);
                            }
                            catch (UnsupportedEncodingException exception) {
                                throw new IllegalStateException(exception);
                            }
                        }

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("family", "path");
                        }
                    }
                }
            }

            public static interface Factory {
                public Connection connect(String var1) throws IOException;

                public static abstract class ForPosixSocket
                implements Factory {
                    private static final String TEMPORARY_DIRECTORY = "/tmp";
                    private static final String SOCKET_FILE_PREFIX = ".java_pid";
                    private static final String ATTACH_FILE_PREFIX = ".attach_pid";
                    private final int attempts;
                    private final long pause;
                    private final TimeUnit timeUnit;

                    protected ForPosixSocket(int attempts, long pause, TimeUnit timeUnit) {
                        this.attempts = attempts;
                        this.pause = pause;
                        this.timeUnit = timeUnit;
                    }

                    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="File name convention is specified.")
                    public Connection connect(String processId) throws IOException {
                        File socket = new File(TEMPORARY_DIRECTORY, SOCKET_FILE_PREFIX + processId);
                        if (!socket.exists()) {
                            File attachFile;
                            block17: {
                                String target = ATTACH_FILE_PREFIX + processId;
                                String path = "/proc/" + processId + "/cwd/" + target;
                                attachFile = new File(path);
                                try {
                                    if (!attachFile.createNewFile() && !attachFile.isFile()) {
                                        throw new IllegalStateException("Could not create attach file: " + attachFile);
                                    }
                                }
                                catch (IOException ignored) {
                                    attachFile = new File(TEMPORARY_DIRECTORY, target);
                                    if (attachFile.createNewFile() || attachFile.isFile()) break block17;
                                    throw new IllegalStateException("Could not create attach file: " + attachFile);
                                }
                            }
                            try {
                                Process process = Runtime.getRuntime().exec("kill -3 " + processId);
                                int attempts = this.attempts;
                                boolean killed = false;
                                while (true) {
                                    try {
                                        if (process.exitValue() != 0) {
                                            throw new IllegalStateException("Error while sending signal to target VM: " + processId);
                                        }
                                        killed = true;
                                    }
                                    catch (IllegalThreadStateException ignored) {
                                        Thread.sleep(this.timeUnit.toMillis(this.pause));
                                        if (--attempts > 0) continue;
                                    }
                                    break;
                                }
                                if (!killed) {
                                    throw new IllegalStateException("Target VM did not respond to signal: " + processId);
                                }
                                attempts = this.attempts;
                                while (attempts-- > 0 && !socket.exists()) {
                                    Thread.sleep(this.timeUnit.toMillis(this.pause));
                                }
                                if (!socket.exists()) {
                                    throw new IllegalStateException("Target VM did not respond: " + processId);
                                }
                            }
                            catch (InterruptedException exception) {
                                Thread.currentThread().interrupt();
                                throw new IllegalStateException("Interrupted during wait for process", exception);
                            }
                            finally {
                                if (!attachFile.delete()) {
                                    attachFile.deleteOnExit();
                                }
                            }
                        }
                        return this.doConnect(socket);
                    }

                    protected abstract Connection doConnect(File var1) throws IOException;
                }
            }
        }
    }
}

