/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.android;

import android.annotation.TargetApi;
import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexClassLoader;
import dalvik.system.DexFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.utility.RandomString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AndroidClassLoadingStrategy
implements ClassLoadingStrategy<ClassLoader> {
    private static final String DEX_CLASS_FILE = "classes.dex";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String EMPTY_LIBRARY_PATH = null;
    private final DexProcessor dexProcessor;
    protected final File privateDirectory;
    protected final RandomString randomString;

    protected AndroidClassLoadingStrategy(File privateDirectory, DexProcessor dexProcessor) {
        if (!privateDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + privateDirectory);
        }
        this.privateDirectory = privateDirectory;
        this.dexProcessor = dexProcessor;
        this.randomString = new RandomString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        DexProcessor.Conversion conversion = this.dexProcessor.create();
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            conversion.register(entry.getKey().getName(), entry.getValue());
        }
        File jar = new File(this.privateDirectory, this.randomString.nextString() + JAR_FILE_EXTENSION);
        try {
            if (!jar.createNewFile()) {
                throw new IllegalStateException("Cannot create " + jar);
            }
            JarOutputStream zipOutputStream = new JarOutputStream(new FileOutputStream(jar));
            try {
                zipOutputStream.putNextEntry(new JarEntry(DEX_CLASS_FILE));
                conversion.drainTo(zipOutputStream);
                zipOutputStream.closeEntry();
            }
            finally {
                zipOutputStream.close();
            }
            Map<TypeDescription, Class<?>> map = this.doLoad(classLoader, types.keySet(), jar);
            return map;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Cannot write to zip file " + jar, exception);
        }
        finally {
            if (!jar.delete()) {
                Logger.getLogger("net.bytebuddy").warning("Could not delete " + jar);
            }
        }
    }

    protected abstract Map<TypeDescription, Class<?>> doLoad(ClassLoader var1, Set<TypeDescription> var2, File var3) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TargetApi(value=3)
    public static class Injecting
    extends AndroidClassLoadingStrategy {
        private static final Dispatcher DISPATCHER;

        public Injecting(File privateDirectory) {
            this(privateDirectory, DexProcessor.ForSdkCompiler.makeDefault());
        }

        public Injecting(File privateDirectory, DexProcessor dexProcessor) {
            super(privateDirectory, dexProcessor);
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader on Android");
            }
            return super.load(classLoader, types);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Map<TypeDescription, Class<?>> doLoad(ClassLoader classLoader, Set<TypeDescription> typeDescriptions, File jar) throws IOException {
            DexFile dexFile = DISPATCHER.loadDex(this.privateDirectory, jar, classLoader, this.randomString);
            HashMap loadedTypes = new HashMap();
            for (TypeDescription typeDescription : typeDescriptions) {
                ClassLoader classLoader2 = classLoader;
                synchronized (classLoader2) {
                    Class<?> type = DISPATCHER.loadClass(dexFile, classLoader, typeDescription);
                    if (type == null) {
                        throw new IllegalStateException("Could not load " + typeDescription);
                    }
                    loadedTypes.put(typeDescription, type);
                }
            }
            return loadedTypes;
        }

        static {
            Dispatcher dispatcher;
            try {
                dispatcher = new Dispatcher.ForAndroidPVm(BaseDexClassLoader.class.getMethod("addDexPath", String.class, Boolean.TYPE));
            }
            catch (Throwable ignored) {
                dispatcher = Dispatcher.ForLegacyVm.INSTANCE;
            }
            DISPATCHER = dispatcher;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public DexFile loadDex(File var1, File var2, ClassLoader var3, RandomString var4) throws IOException;

            public Class<?> loadClass(DexFile var1, ClassLoader var2, TypeDescription var3);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class ForAndroidPVm
            implements Dispatcher {
                private static final DexFile NO_RETURN_VALUE = null;
                private final Method addDexPath;

                protected ForAndroidPVm(Method addDexPath) {
                    this.addDexPath = addDexPath;
                }

                @Override
                public DexFile loadDex(File privateDirectory, File jar, ClassLoader classLoader, RandomString randomString) throws IOException {
                    if (!(classLoader instanceof BaseDexClassLoader)) {
                        throw new IllegalArgumentException("On Android P, a class injection can only be applied to BaseDexClassLoader: " + classLoader);
                    }
                    try {
                        this.addDexPath.invoke((Object)classLoader, jar.getAbsolutePath(), true);
                        return NO_RETURN_VALUE;
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access BaseDexClassLoader#addDexPath(String, boolean)", exception);
                    }
                    catch (InvocationTargetException exception) {
                        Throwable cause = exception.getCause();
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        throw new IllegalStateException("Cannot invoke BaseDexClassLoader#addDexPath(String, boolean)", cause);
                    }
                }

                @Override
                public Class<?> loadClass(DexFile dexFile, ClassLoader classLoader, TypeDescription typeDescription) {
                    try {
                        return Class.forName(typeDescription.getName(), false, classLoader);
                    }
                    catch (ClassNotFoundException exception) {
                        throw new IllegalStateException("Could not locate " + typeDescription, exception);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;

                private static final int NO_FLAGS = 0;
                private static final String EXTENSION = ".data";

                @Override
                public DexFile loadDex(File privateDirectory, File jar, ClassLoader classLoader, RandomString randomString) throws IOException {
                    return DexFile.loadDex((String)jar.getAbsolutePath(), (String)new File(privateDirectory.getAbsolutePath(), randomString.nextString() + EXTENSION).getAbsolutePath(), (int)0);
                }

                @Override
                public Class<?> loadClass(DexFile dexFile, ClassLoader classLoader, TypeDescription typeDescription) {
                    return dexFile.loadClass(typeDescription.getName(), classLoader);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TargetApi(value=3)
    public static class Wrapping
    extends AndroidClassLoadingStrategy {
        public Wrapping(File privateDirectory) {
            this(privateDirectory, DexProcessor.ForSdkCompiler.makeDefault());
        }

        public Wrapping(File privateDirectory, DexProcessor dexProcessor) {
            super(privateDirectory, dexProcessor);
        }

        @Override
        @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Android discourages the use of access controllers")
        protected Map<TypeDescription, Class<?>> doLoad(ClassLoader classLoader, Set<TypeDescription> typeDescriptions, File jar) {
            DexClassLoader dexClassLoader = new DexClassLoader(jar.getAbsolutePath(), this.privateDirectory.getAbsolutePath(), EMPTY_LIBRARY_PATH, classLoader);
            HashMap loadedTypes = new HashMap();
            for (TypeDescription typeDescription : typeDescriptions) {
                try {
                    loadedTypes.put(typeDescription, Class.forName(typeDescription.getName(), false, (ClassLoader)dexClassLoader));
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalStateException("Cannot load " + typeDescription, exception);
                }
            }
            return loadedTypes;
        }
    }

    public static interface DexProcessor {
        public Conversion create();

        public static class ForSdkCompiler
        implements DexProcessor {
            private static final int DEX_COMPATIBLE_API_VERSION = 13;
            private static final Dispatcher DISPATCHER;
            private static final String CLASS_FILE_EXTENSION = ".class";
            private static final Writer NO_PRINT_OUTPUT;
            private static final boolean NOT_VERBOSE = false;
            private final DexOptions dexFileOptions;
            private final CfOptions dexCompilerOptions;

            protected static DexProcessor makeDefault() {
                DexOptions dexOptions = new DexOptions();
                DISPATCHER.setTargetApi(dexOptions, 13);
                return new ForSdkCompiler(dexOptions, new CfOptions());
            }

            public ForSdkCompiler(DexOptions dexFileOptions, CfOptions dexCompilerOptions) {
                this.dexFileOptions = dexFileOptions;
                this.dexCompilerOptions = dexCompilerOptions;
            }

            public net.bytebuddy.android.AndroidClassLoadingStrategy$DexProcessor$Conversion create() {
                return new Conversion(new com.android.dx.dex.file.DexFile(this.dexFileOptions));
            }

            static {
                Dispatcher dispatcher;
                try {
                    Class<?> dxContextType = Class.forName("com.android.dx.command.dexer.DxContext");
                    dispatcher = new Dispatcher.ForApi26LevelCompatibleVm(CfTranslator.class.getMethod("translate", dxContextType, DirectClassFile.class, byte[].class, CfOptions.class, DexOptions.class, com.android.dx.dex.file.DexFile.class), dxContextType.getConstructor(new Class[0]));
                }
                catch (Throwable ignored) {
                    try {
                        dispatcher = new Dispatcher.ForLegacyVm(CfTranslator.class.getMethod("translate", DirectClassFile.class, byte[].class, CfOptions.class, DexOptions.class, com.android.dx.dex.file.DexFile.class), DexOptions.class.getField("targetApiLevel"));
                    }
                    catch (Throwable throwable) {
                        dispatcher = new Dispatcher.Unavailable(throwable.getMessage());
                    }
                }
                DISPATCHER = dispatcher;
                NO_PRINT_OUTPUT = null;
            }

            protected static interface Dispatcher {
                public ClassDefItem translate(DirectClassFile var1, byte[] var2, CfOptions var3, DexOptions var4, com.android.dx.dex.file.DexFile var5);

                public void setTargetApi(DexOptions var1, int var2);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ForApi26LevelCompatibleVm
                implements Dispatcher {
                    private final Method translate;
                    private final Constructor<?> dxContext;

                    protected ForApi26LevelCompatibleVm(Method translate, Constructor<?> dxContext) {
                        this.translate = translate;
                        this.dxContext = dxContext;
                    }

                    @Override
                    public ClassDefItem translate(DirectClassFile directClassFile, byte[] binaryRepresentation, CfOptions dexCompilerOptions, DexOptions dexFileOptions, com.android.dx.dex.file.DexFile dexFile) {
                        try {
                            return (ClassDefItem)this.translate.invoke(null, this.dxContext.newInstance(new Object[0]), directClassFile, binaryRepresentation, dexCompilerOptions, dexFileOptions, new com.android.dx.dex.file.DexFile(dexFileOptions));
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access an Android dex file translation method", exception);
                        }
                        catch (InstantiationException exception) {
                            throw new IllegalStateException("Cannot instantiate dex context", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Cannot invoke Android dex file translation method", exception.getCause());
                        }
                    }

                    @Override
                    public void setTargetApi(DexOptions dexOptions, int targetApiLevel) {
                    }
                }

                public static class ForLegacyVm
                implements Dispatcher {
                    private final Method translate;
                    private final Field targetApi;

                    protected ForLegacyVm(Method translate, Field targetApi) {
                        this.translate = translate;
                        this.targetApi = targetApi;
                    }

                    public ClassDefItem translate(DirectClassFile directClassFile, byte[] binaryRepresentation, CfOptions dexCompilerOptions, DexOptions dexFileOptions, com.android.dx.dex.file.DexFile dexFile) {
                        try {
                            return (ClassDefItem)this.translate.invoke(null, directClassFile, binaryRepresentation, dexCompilerOptions, dexFileOptions, new com.android.dx.dex.file.DexFile(dexFileOptions));
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access an Android dex file translation method", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Cannot invoke Android dex file translation method", exception.getCause());
                        }
                    }

                    public void setTargetApi(DexOptions dexOptions, int targetApiLevel) {
                        try {
                            this.targetApi.set(dexOptions, targetApiLevel);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access an Android dex file translation method", exception);
                        }
                    }
                }

                public static class Unavailable
                implements Dispatcher {
                    private final String message;

                    protected Unavailable(String message) {
                        this.message = message;
                    }

                    public ClassDefItem translate(DirectClassFile directClassFile, byte[] binaryRepresentation, CfOptions dexCompilerOptions, DexOptions dexFileOptions, com.android.dx.dex.file.DexFile dexFile) {
                        throw new IllegalStateException("Could not resolve dispatcher: " + this.message);
                    }

                    public void setTargetApi(DexOptions dexOptions, int targetApiLevel) {
                        throw new IllegalStateException("Could not resolve dispatcher: " + this.message);
                    }
                }
            }

            protected class Conversion
            implements net.bytebuddy.android.AndroidClassLoadingStrategy$DexProcessor$Conversion {
                private static final boolean NON_STRICT = false;
                private final com.android.dx.dex.file.DexFile dexFile;

                protected Conversion(com.android.dx.dex.file.DexFile dexFile) {
                    this.dexFile = dexFile;
                }

                public void register(String name, byte[] binaryRepresentation) {
                    DirectClassFile directClassFile = new DirectClassFile(binaryRepresentation, name.replace('.', '/') + ForSdkCompiler.CLASS_FILE_EXTENSION, false);
                    directClassFile.setAttributeFactory((AttributeFactory)new StdAttributeFactory());
                    this.dexFile.add(DISPATCHER.translate(directClassFile, binaryRepresentation, ForSdkCompiler.this.dexCompilerOptions, ForSdkCompiler.this.dexFileOptions, new com.android.dx.dex.file.DexFile(ForSdkCompiler.this.dexFileOptions)));
                }

                public void drainTo(OutputStream outputStream) throws IOException {
                    this.dexFile.writeTo(outputStream, NO_PRINT_OUTPUT, false);
                }
            }
        }

        public static interface Conversion {
            public void register(String var1, byte[] var2);

            public void drainTo(OutputStream var1) throws IOException;
        }
    }
}

